/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.runtime.RawQuery;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.IdentityMap;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class EntityTreeQueryBuilderTest {
    EntityTreeQueryBuilderTest() {
    }

    @Test
    void buildSelectQuery_robustToSeveralJoinsUsingSameTable() {
        ClassMapping totoMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        Column totoPrimaryKey = totoTable.addColumn("id", Long.TYPE);
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        Key totoTata1IdColumn = Key.ofSingleColumn((JoinLink)totoTable.addColumn("tata1Id", String.class));
        Key totoTata2IdColumn = Key.ofSingleColumn((JoinLink)totoTable.addColumn("tata2Id", String.class));
        ClassMapping tataMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tata1NodeName = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), totoTata1IdColumn, (Key)tataPrimaryKey, "x", EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tata2NodeName = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), totoTata2IdColumn, (Key)tataPrimaryKey, "y", EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        final IdentityMap tableCloneMap = new IdentityMap();
        EntityTreeQueryBuilder testInstance = new EntityTreeQueryBuilder(entityJoinTree, (ResultSetReaderRegistry)new ColumnBinderRegistry()){

            Duo<Fromable, IdentityHashMap<Selectable, Selectable>> cloneTable(JoinNode joinNode) {
                Duo tableClone = super.cloneTable(joinNode);
                tableCloneMap.put((Object)joinNode, tableClone.getLeft());
                return tableClone;
            }
        };
        EntityTreeQueryBuilder.EntityTreeQuery entityTreeQuery = testInstance.buildSelectQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = new QuerySQLBuilderFactory((JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), DMLNameProvider::new, new ColumnBinderRegistry()).queryBuilder(entityTreeQuery.getQuery());
        RawQuery actual = new RawQuery(sqlQueryBuilder.toSQL());
        Assertions.assertThat(actual.getColumns()).containsExactlyInAnyOrder((Object[])new String[]{"Toto.id as Toto_id", "Toto.name as Toto_name", "Toto.tata1Id as Toto_tata1Id", "Toto.tata2Id as Toto_tata2Id", "x.name as x_name", "x.id as x_id", "y.name as y_name", "y.id as y_id"});
        Assertions.assertThat((String)actual.getFrom()).isEqualTo("Toto inner join Tata as x on Toto.tata1Id = x.id inner join Tata as y on Toto.tata2Id = y.id");
        JoinRoot root = entityJoinTree.getRoot();
        Map totoTableClone = ((Fromable)tableCloneMap.get((Object)root)).mapColumnsOnName();
        HashMap actualTotoJoinAliases = new HashMap();
        totoTableClone.forEach((columnName, column) -> {
            String cfr_ignored_0 = (String)actualTotoJoinAliases.put(columnName, entityTreeQuery.getColumnAliases().get(column));
        });
        Maps.ChainingHashMap expectedAliases = Maps.forHashMap(String.class, String.class).add((Object)"id", (Object)"Toto_id").add((Object)"name", (Object)"Toto_name").add((Object)"tata1Id", (Object)"Toto_tata1Id").add((Object)"tata2Id", (Object)"Toto_tata2Id");
        Assertions.assertThat(actualTotoJoinAliases).isEqualTo((Object)expectedAliases);
        JoinNode tata1JoinNode = entityJoinTree.getJoin(tata1NodeName);
        Map tata1TableClone = ((Fromable)tableCloneMap.get((Object)tata1JoinNode)).mapColumnsOnName();
        HashMap actualTata1JoinAliases = new HashMap();
        tata1TableClone.forEach((columnName, column) -> {
            String cfr_ignored_0 = (String)actualTata1JoinAliases.put(columnName, entityTreeQuery.getColumnAliases().get(column));
        });
        Maps.ChainingHashMap expectedAliases1 = Maps.forHashMap(String.class, String.class).add((Object)"id", (Object)"x_id").add((Object)"name", (Object)"x_name");
        Assertions.assertThat(actualTata1JoinAliases).isEqualTo((Object)expectedAliases1);
        JoinNode tata2JoinNode = entityJoinTree.getJoin(tata2NodeName);
        Map tata2TableClone = ((Fromable)tableCloneMap.get((Object)tata2JoinNode)).mapColumnsOnName();
        HashMap actualTata2JoinAliases = new HashMap();
        tata2TableClone.forEach((columnName, column) -> {
            String cfr_ignored_0 = (String)actualTata2JoinAliases.put(columnName, entityTreeQuery.getColumnAliases().get(column));
        });
        Maps.ChainingHashMap expectedAliases2 = Maps.forHashMap(String.class, String.class).add((Object)"id", (Object)"y_id").add((Object)"name", (Object)"y_name");
        Assertions.assertThat(actualTata2JoinAliases).isEqualTo((Object)expectedAliases2);
    }

    static ClassMapping buildMappingStrategyMock(String tableName) {
        return EntityTreeQueryBuilderTest.buildMappingStrategyMock(new Table(tableName));
    }

    static ClassMapping buildMappingStrategyMock(Table table) {
        ClassMapping mappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)mappingStrategyMock.getTargetTable()).thenReturn((Object)table);
        Mockito.when((Object)mappingStrategyMock.getSelectableColumns()).thenAnswer(invocation -> table.getColumns());
        return mappingStrategyMock;
    }

    static Object[][] toSQL_singleStrategyData() {
        Table table1 = new Table("Toto");
        Column id1 = table1.addColumn("id", Long.TYPE);
        Table table2 = new Table("Toto");
        Column id2 = table2.addColumn("id", Long.TYPE);
        Column name2 = table2.addColumn("name", String.class);
        return new Object[][]{{table1, "select Toto.id as Toto_id from Toto", Maps.forHashMap(Column.class, String.class).add((Object)id1, (Object)"Toto_id")}, {table2, "select Toto.id as Toto_id, Toto.name as Toto_name from Toto", Maps.forHashMap(Column.class, String.class).add((Object)id2, (Object)"Toto_id").add((Object)name2, (Object)"Toto_name")}};
    }

    @ParameterizedTest
    @MethodSource(value={"toSQL_singleStrategyData"})
    void toSQL_singleStrategy(Table table, String expected, Map<Column, String> expectedAliases) {
        ClassMapping mappingStrategyMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock(table);
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)mappingStrategyMock), (Fromable)table);
        final IdentityMap tableCloneMap = new IdentityMap();
        EntityTreeQueryBuilder testInstance = new EntityTreeQueryBuilder(entityJoinTree, (ResultSetReaderRegistry)new ColumnBinderRegistry()){

            Duo<Fromable, IdentityHashMap<Selectable, Selectable>> cloneTable(JoinNode joinNode) {
                Duo tableClone = super.cloneTable(joinNode);
                tableCloneMap.put((Object)((Table)joinNode.getTable()), tableClone.getLeft());
                return tableClone;
            }
        };
        EntityTreeQueryBuilder.EntityTreeQuery treeQuery = testInstance.buildSelectQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = new QuerySQLBuilderFactory((JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), DMLNameProvider::new, new ColumnBinderRegistry()).queryBuilder(treeQuery.getQuery());
        Assertions.assertThat((String)sqlQueryBuilder.toSQL()).isEqualTo(expected);
        HashMap expectedColumnClones = new HashMap();
        expectedAliases.forEach((column, value) -> expectedColumnClones.put(((Fromable)tableCloneMap.get((Object)column.getTable())).findColumn(column.getName()), value));
        Assertions.assertThat((Map)treeQuery.getColumnAliases()).isEqualTo(expectedColumnClones);
    }

    private static Object[] inheritance_tablePerClass_2Classes_testData() {
        ClassMapping totoMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        Column totoPrimaryKey = totoTable.addColumn("id", Long.TYPE).primaryKey();
        totoTable.addColumn("name", String.class);
        ClassMapping tataMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        Column tataPrimaryKey = tataTable.addColumn("id", Long.TYPE).primaryKey();
        return new Object[]{totoMappingMock, tataMappingMock, totoTable.getPrimaryKey(), tataTable.getPrimaryKey(), "select Toto.id as Toto_id, Toto.name as Toto_name, Tata.id as Tata_id from Toto inner join Tata as Tata on Toto.id = Tata.id"};
    }

    private static Object[] relationOwnedByTarget_testData() {
        ClassMapping totoMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        totoTable.addColumn("id", Long.TYPE);
        totoTable.addColumn("name", String.class);
        ClassMapping tataMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Key totoOtherTableId = Key.ofSingleColumn((JoinLink)totoTable.addColumn("otherTable_id", Long.TYPE));
        return new Object[]{totoMappingMock, tataMappingMock, totoOtherTableId, tataPrimaryKey, "select Toto.id as Toto_id, Toto.name as Toto_name, Toto.otherTable_id as Toto_otherTable_id, Tata.id as Tata_id from Toto inner join Tata as Tata on Toto.otherTable_id = Tata.id"};
    }

    static Object[][] dataToSQL_multipleStrategy() {
        return new Object[][]{EntityTreeQueryBuilderTest.inheritance_tablePerClass_2Classes_testData(), EntityTreeQueryBuilderTest.relationOwnedByTarget_testData()};
    }

    @ParameterizedTest
    @MethodSource(value={"dataToSQL_multipleStrategy"})
    void toSQL_multipleStrategy(ClassMapping rootMappingStrategy, ClassMapping classMappingStrategy, Key leftJoinColumn, Key rightJoinColumn, String expectedSQL) {
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)rootMappingStrategy), (Fromable)rootMappingStrategy.getTargetTable());
        EntityTreeQueryBuilder testInstance = new EntityTreeQueryBuilder(entityJoinTree, (ResultSetReaderRegistry)new ColumnBinderRegistry());
        entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)classMappingStrategy), leftJoinColumn, rightJoinColumn, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = new QuerySQLBuilderFactory((JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), DMLNameProvider::new, new ColumnBinderRegistry()).queryBuilder(testInstance.buildSelectQuery().getQuery());
        Assertions.assertThat((String)sqlQueryBuilder.toSQL()).isEqualTo(expectedSQL);
    }

    @Test
    void testInheritance_tablePerClass_3Classes() {
        ClassMapping totoMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        Column totoPKColumn = totoTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey totoPrimaryKey = totoTable.getPrimaryKey();
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        ClassMapping tataMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        Column tataPKColumn = tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        ClassMapping tutuMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tutu");
        Table tutuTable = tutuMappingMock.getTargetTable();
        Column tutuPKColumn = tutuTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuPrimaryKey = tutuTable.getPrimaryKey();
        Column tutuNameColumn = tutuTable.addColumn("name", String.class);
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tataAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), (Key)totoPrimaryKey, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuMappingMock), (Key)tataPrimaryKey, (Key)tutuPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        final IdentityMap tableCloneMap = new IdentityMap();
        EntityTreeQueryBuilder testInstance = new EntityTreeQueryBuilder(entityJoinTree, (ResultSetReaderRegistry)new ColumnBinderRegistry()){

            Duo<Fromable, IdentityHashMap<Selectable, Selectable>> cloneTable(JoinNode joinNode) {
                Duo tableClone = super.cloneTable(joinNode);
                tableCloneMap.put((Object)((Table)joinNode.getTable()), tableClone.getLeft());
                return tableClone;
            }
        };
        EntityTreeQueryBuilder.EntityTreeQuery entityTreeQuery = testInstance.buildSelectQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = new QuerySQLBuilderFactory((JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), DMLNameProvider::new, new ColumnBinderRegistry()).queryBuilder(entityTreeQuery.getQuery());
        RawQuery actual = new RawQuery(sqlQueryBuilder.toSQL());
        Assertions.assertThat(actual.getColumns()).containsExactlyInAnyOrder((Object[])new String[]{"Toto.id as Toto_id", "Toto.name as Toto_name", "Tata.name as Tata_name", "Tata.id as Tata_id", "Tata_Tutu.id as Tata_Tutu_id", "Tata_Tutu.name as Tata_Tutu_name"});
        Assertions.assertThat((String)actual.getFrom()).isEqualTo("Toto inner join Tata as Tata on Toto.id = Tata.id inner join Tutu as Tata_Tutu on Tata.id = Tata_Tutu.id");
        Maps.ChainingHashMap expectedAliases = Maps.forHashMap(Column.class, String.class).add((Object)totoPKColumn, (Object)"Toto_id").add((Object)totoNameColumn, (Object)"Toto_name").add((Object)tataPKColumn, (Object)"Tata_id").add((Object)tataNameColumn, (Object)"Tata_name").add((Object)tutuPKColumn, (Object)"Tata_Tutu_id").add((Object)tutuNameColumn, (Object)"Tata_Tutu_name");
        HashMap expectedColumnClones = new HashMap();
        expectedAliases.forEach((column, value) -> expectedColumnClones.put(((Fromable)tableCloneMap.get((Object)column.getTable())).findColumn(column.getName()), value));
        Assertions.assertThat((Map)entityTreeQuery.getColumnAliases()).isEqualTo(expectedColumnClones);
    }

    @Test
    void testJoin_2Relations() {
        ClassMapping totoMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        Column totoPrimaryKey = totoTable.addColumn("id", Long.TYPE);
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        Column tataId = totoTable.addColumn("tataId", String.class);
        Key tataFK = Key.ofSingleColumn((JoinLink)tataId);
        Column tutuId = totoTable.addColumn("tutuId", String.class);
        Key tutuFK = Key.ofSingleColumn((JoinLink)tutuId);
        ClassMapping tataMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        Column tataPKColumn = tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        ClassMapping tutuMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tutu");
        Table tutuTable = tutuMappingMock.getTargetTable();
        Column tutuPKColumn = tutuTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuPrimaryKey = tutuTable.getPrimaryKey();
        Column tutuNameColumn = tutuTable.addColumn("name", String.class);
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tataAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), tataFK, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuMappingMock), tutuFK, (Key)tutuPrimaryKey, null, EntityJoinTree.JoinType.OUTER, null, Collections.emptySet());
        final IdentityMap tableCloneMap = new IdentityMap();
        EntityTreeQueryBuilder testInstance = new EntityTreeQueryBuilder(entityJoinTree, (ResultSetReaderRegistry)new ColumnBinderRegistry()){

            Duo<Fromable, IdentityHashMap<Selectable, Selectable>> cloneTable(JoinNode joinNode) {
                Duo tableClone = super.cloneTable(joinNode);
                tableCloneMap.put((Object)((Table)joinNode.getTable()), tableClone.getLeft());
                return tableClone;
            }
        };
        EntityTreeQueryBuilder.EntityTreeQuery entityTreeQuery = testInstance.buildSelectQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = new QuerySQLBuilderFactory((JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), DMLNameProvider::new, new ColumnBinderRegistry()).queryBuilder(entityTreeQuery.getQuery());
        RawQuery actual = new RawQuery(sqlQueryBuilder.toSQL());
        Assertions.assertThat(actual.getColumns()).containsExactlyInAnyOrder((Object[])new String[]{"Toto.id as Toto_id", "Toto.name as Toto_name", "Toto.tataId as Toto_tataId", "Toto.tutuId as Toto_tutuId", "Tata.name as Tata_name", "Tata.id as Tata_id", "Tutu.name as Tutu_name", "Tutu.id as Tutu_id"});
        Assertions.assertThat((String)actual.getFrom()).isEqualTo("Toto inner join Tata as Tata on Toto.tataId = Tata.id left outer join Tutu as Tutu on Toto.tutuId = Tutu.id");
        Maps.ChainingHashMap expectedAliases = Maps.forHashMap(Column.class, String.class).add((Object)totoPrimaryKey, (Object)"Toto_id").add((Object)totoNameColumn, (Object)"Toto_name").add((Object)tataId, (Object)"Toto_tataId").add((Object)tutuId, (Object)"Toto_tutuId").add((Object)tataPKColumn, (Object)"Tata_id").add((Object)tataNameColumn, (Object)"Tata_name").add((Object)tutuPKColumn, (Object)"Tutu_id").add((Object)tutuNameColumn, (Object)"Tutu_name");
        HashMap expectedColumnClones = new HashMap();
        expectedAliases.forEach((column, value) -> expectedColumnClones.put(((Fromable)tableCloneMap.get((Object)column.getTable())).findColumn(column.getName()), value));
        Assertions.assertThat((Map)entityTreeQuery.getColumnAliases()).isEqualTo(expectedColumnClones);
    }

    @Test
    void testInheritance_tablePerClass_NClasses() {
        ClassMapping totoMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        Column totoPKColumn = totoTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey totoPrimaryKey = totoTable.getPrimaryKey();
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        ClassMapping tataMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        Column tataPKColumn = tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        ClassMapping tutuMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Tutu");
        Table tutuTable = tutuMappingMock.getTargetTable();
        Column tutuPKColumn = tutuTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuPrimaryKey = tutuTable.getPrimaryKey();
        Column tutuNameColumn = tutuTable.addColumn("name", String.class);
        ClassMapping titiMappingMock = EntityTreeQueryBuilderTest.buildMappingStrategyMock("Titi");
        Table titiTable = titiMappingMock.getTargetTable();
        Column titiPKColumn = titiTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey titiPrimaryKey = titiTable.getPrimaryKey();
        Column titiNameColumn = titiTable.addColumn("name", String.class);
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tataAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), (Key)totoPrimaryKey, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey = entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuMappingMock), (Key)tataPrimaryKey, (Key)tutuPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String titiAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)titiMappingMock), (Key)totoPrimaryKey, (Key)titiPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        final IdentityMap tableCloneMap = new IdentityMap();
        EntityTreeQueryBuilder testInstance = new EntityTreeQueryBuilder(entityJoinTree, (ResultSetReaderRegistry)new ColumnBinderRegistry()){

            Duo<Fromable, IdentityHashMap<Selectable, Selectable>> cloneTable(JoinNode joinNode) {
                Duo tableClone = super.cloneTable(joinNode);
                tableCloneMap.put((Object)((Table)joinNode.getTable()), tableClone.getLeft());
                return tableClone;
            }
        };
        EntityTreeQueryBuilder.EntityTreeQuery entityTreeQuery = testInstance.buildSelectQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = new QuerySQLBuilderFactory((JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), DMLNameProvider::new, new ColumnBinderRegistry()).queryBuilder(entityTreeQuery.getQuery());
        RawQuery actual = new RawQuery(sqlQueryBuilder.toSQL());
        Assertions.assertThat(actual.getColumns()).containsExactlyInAnyOrder((Object[])new String[]{"Toto.id as Toto_id", "Toto.name as Toto_name", "Tata.name as Tata_name", "Tata.id as Tata_id", "Titi.name as Titi_name", "Titi.id as Titi_id", "Tata_Tutu.id as Tata_Tutu_id", "Tata_Tutu.name as Tata_Tutu_name"});
        Assertions.assertThat((String)actual.getFrom()).isEqualTo("Toto inner join Tata as Tata on Toto.id = Tata.id inner join Titi as Titi on Toto.id = Titi.id inner join Tutu as Tata_Tutu on Tata.id = Tata_Tutu.id");
        Maps.ChainingHashMap expectedAliases = Maps.forHashMap(Column.class, String.class).add((Object)totoPKColumn, (Object)"Toto_id").add((Object)totoNameColumn, (Object)"Toto_name").add((Object)tataPKColumn, (Object)"Tata_id").add((Object)tataNameColumn, (Object)"Tata_name").add((Object)tutuPKColumn, (Object)"Tata_Tutu_id").add((Object)tutuNameColumn, (Object)"Tata_Tutu_name").add((Object)titiPKColumn, (Object)"Titi_id").add((Object)titiNameColumn, (Object)"Titi_name");
        HashMap expectedColumnClones = new HashMap();
        expectedAliases.forEach((column, value) -> expectedColumnClones.put(((Fromable)tableCloneMap.get((Object)column.getTable())).findColumn(column.getName()), value));
        Assertions.assertThat((Map)entityTreeQuery.getColumnAliases()).isEqualTo(expectedColumnClones);
    }
}

