/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.sequence;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequence;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceOptions;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequencePersister;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceStorageOptions;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.DDLGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.tool.trace.ModifiableInt;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PooledHiLoSequenceTest {
    PooledHiLoSequenceTest() {
    }

    @Test
    void next_noExistingValueInDatabase() {
        PooledHiLoSequenceOptions totoSequenceOptions = new PooledHiLoSequenceOptions(10, "Toto", PooledHiLoSequenceStorageOptions.DEFAULT);
        PooledHiLoSequencePersister sequencePersisterMock = (PooledHiLoSequencePersister)Mockito.mock(PooledHiLoSequencePersister.class);
        ModifiableInt sequenceValue = new ModifiableInt();
        Mockito.when((Object)sequencePersisterMock.select((Object)"Toto")).thenReturn(null);
        Mockito.when((Object)sequencePersisterMock.reservePool("Toto", 10)).thenReturn((Object)((long)sequenceValue.increment() * (long)totoSequenceOptions.getPoolSize()));
        PooledHiLoSequence testInstance = new PooledHiLoSequence(totoSequenceOptions, sequencePersisterMock);
        for (int i = 1; i < 45; ++i) {
            Assertions.assertThat((int)testInstance.next().intValue()).isEqualTo(i);
        }
        ((PooledHiLoSequencePersister)Mockito.verify((Object)sequencePersisterMock, (VerificationMode)Mockito.times((int)5))).reservePool("Toto", 10);
    }

    @Test
    void next_existingValueInDatabase() {
        PooledHiLoSequenceOptions totoSequenceOptions = new PooledHiLoSequenceOptions(10, "Toto", PooledHiLoSequenceStorageOptions.DEFAULT);
        PooledHiLoSequencePersister sequencePersisterMock = (PooledHiLoSequencePersister)Mockito.mock(PooledHiLoSequencePersister.class);
        ModifiableInt sequenceValue = new ModifiableInt(50);
        Mockito.when((Object)sequencePersisterMock.select((Object)"Toto")).thenReturn((Object)new PooledHiLoSequencePersister.Sequence("Toto", (long)sequenceValue.getValue()));
        Mockito.when((Object)sequencePersisterMock.reservePool("Toto", 10)).thenReturn((Object)((long)sequenceValue.increment() * (long)totoSequenceOptions.getPoolSize()));
        PooledHiLoSequence testInstance = new PooledHiLoSequence(totoSequenceOptions, sequencePersisterMock);
        for (int i = 0; i < 45; ++i) {
            Assertions.assertThat((int)testInstance.next().intValue()).isEqualTo(50 + i);
        }
        ((PooledHiLoSequencePersister)Mockito.verify((Object)sequencePersisterMock, (VerificationMode)Mockito.times((int)5))).reservePool("Toto", 10);
    }

    @Test
    void next_withInitialValue() {
        PooledHiLoSequenceOptions totoSequenceOptions = new PooledHiLoSequenceOptions(10, "Toto", PooledHiLoSequenceStorageOptions.DEFAULT, -42L);
        PooledHiLoSequencePersister sequencePersisterMock = (PooledHiLoSequencePersister)Mockito.mock(PooledHiLoSequencePersister.class);
        ModifiableInt sequenceValue = new ModifiableInt(50);
        Mockito.when((Object)sequencePersisterMock.select((Object)"Toto")).thenReturn(null);
        Mockito.when((Object)sequencePersisterMock.reservePool("Toto", 10)).thenReturn((Object)((long)sequenceValue.increment() * (long)totoSequenceOptions.getPoolSize()));
        PooledHiLoSequence testInstance = new PooledHiLoSequence(totoSequenceOptions, sequencePersisterMock);
        for (int i = -42; i < -25; ++i) {
            Assertions.assertThat((int)testInstance.next().intValue()).isEqualTo(i);
        }
    }

    @Test
    void generateDDL() {
        JavaTypeToSqlTypeMapping simpleTypeMapping = new JavaTypeToSqlTypeMapping();
        simpleTypeMapping.put(Long.TYPE, "int");
        simpleTypeMapping.put(String.class, "VARCHAR(255)");
        PooledHiLoSequenceOptions totoSequenceOptions = new PooledHiLoSequenceOptions(10, "Toto", PooledHiLoSequenceStorageOptions.DEFAULT);
        DefaultDialect dialect = new DefaultDialect(simpleTypeMapping);
        PooledHiLoSequence testInstance = new PooledHiLoSequence(totoSequenceOptions, (Dialect)dialect, (SeparateTransactionExecutor)Mockito.mock(SeparateTransactionExecutor.class), 50);
        DDLGenerator ddlGenerator = new DDLGenerator(dialect.getDdlTableGenerator(), dialect.getDdlSequenceGenerator());
        ddlGenerator.setTables(testInstance.getPersister().giveImpliedTables());
        Assertions.assertThat((List)ddlGenerator.getCreationScripts()).containsExactly((Object[])new String[]{"create table sequence_table(sequence_name VARCHAR(255), next_val int not null, primary key (sequence_name))"});
    }
}

