/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository;

import java.util.Optional;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.spring.repository.StalactiteRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class SimpleStalactiteRepository<C, I>
implements StalactiteRepository<C, I> {
    private final EntityPersister<C, I> persister;

    public SimpleStalactiteRepository(EntityPersister<C, I> persister) {
        this.persister = persister;
    }

    @Override
    @Transactional
    public <S extends C> S save(S entity) {
        this.persister.persist(entity);
        return entity;
    }

    @Override
    @Transactional
    public <S extends C> Iterable<S> saveAll(Iterable<S> entities) {
        this.persister.persist(entities);
        return entities;
    }

    @Override
    public Iterable<C> findAll() {
        return this.persister.selectAll();
    }

    @Override
    public Optional<C> findById(I id) {
        return Optional.ofNullable(this.persister.select(id));
    }

    @Override
    public Iterable<C> findAllById(Iterable<I> ids) {
        return this.persister.select(ids);
    }

    @Override
    @Transactional
    public void delete(C entity) {
        this.persister.delete(entity);
    }

    @Override
    @Transactional
    public void deleteAll(Iterable<? extends C> entities) {
        this.persister.delete(entities);
    }
}

