/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.config;

import org.codefilarete.stalactite.engine.ConnectionSettings;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.PersistenceContextConfigurationBuilder;
import org.codefilarete.stalactite.spring.transaction.StalactitePlatformTransactionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringDataPersistenceContextConfigurationBuilder
extends PersistenceContextConfigurationBuilder {
    public SpringDataPersistenceContextConfigurationBuilder(DatabaseVendorSettings vendorSettings, ConnectionSettings connectionSettings) {
        super(vendorSettings, connectionSettings);
    }

    protected ConnectionConfiguration buildConnectionConfiguration() {
        return new PlatformTransactionManagerConnectionConfigurationSupport(new StalactitePlatformTransactionManager(this.connectionSettings.getDataSource()), this.connectionSettings.getBatchSize());
    }

    static class PlatformTransactionManagerConnectionConfigurationSupport
    extends ConnectionConfiguration.ConnectionConfigurationSupport {
        private final PlatformTransactionManager platformTransactionManager;

        public PlatformTransactionManagerConnectionConfigurationSupport(StalactitePlatformTransactionManager connectionProvider, int batchSize) {
            super((ConnectionProvider)connectionProvider, batchSize);
            this.platformTransactionManager = connectionProvider;
        }

        public PlatformTransactionManager getPlatformTransactionManager() {
            return this.platformTransactionManager;
        }
    }
}

