/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl.structure;

import javax.annotation.Nullable;
import org.codefilarete.stalactite.sql.ddl.structure.Database;

public class Sequence {
    @Nullable
    private final Database.Schema schema;
    private final String name;
    private final String absoluteName;
    @Nullable
    private Integer initialValue;
    @Nullable
    private Integer batchSize;

    public Sequence(String name) {
        this(null, name);
    }

    public Sequence(@Nullable Database.Schema schema, String name) {
        this.schema = schema;
        if (this.schema != null) {
            this.schema.addSequence(this);
        }
        this.name = name;
        this.absoluteName = (String)org.codefilarete.tool.Nullable.nullable((Object)schema).map(Database.Schema::getName).map(s -> s + "." + name).getOr((Object)name);
    }

    @Nullable
    public Database.Schema getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getAbsoluteName() {
        return this.absoluteName;
    }

    @Nullable
    public Integer getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(@Nullable Integer initialValue) {
        this.initialValue = initialValue;
    }

    public Sequence withInitialValue(@Nullable Integer initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(@Nullable Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Sequence withBatchSize(@Nullable Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }
}

