/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSelect;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.PreparedUpdate;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Sorter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DMLGeneratorTest {
    private ParameterBinder stringBinder;
    private DMLGenerator testInstance;
    private Dialect currentDialect;

    DMLGeneratorTest() {
    }

    @BeforeEach
    public void setUp() {
        this.currentDialect = new DefaultDialect(new JavaTypeToSqlTypeMapping());
        this.stringBinder = this.currentDialect.getColumnBinderRegistry().getBinder(String.class);
        this.testInstance = new DMLGenerator((ParameterBinderIndex)this.currentDialect.getColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, DMLNameProvider::new);
    }

    @Test
    public void buildInsert() {
        Table toto = new Table(null, "Toto");
        Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        ColumnParameterizedSQL builtInsert = this.testInstance.buildInsert((Iterable)toto.getColumns());
        Assertions.assertThat((String)builtInsert.getSQL()).isEqualTo("insert into Toto(A, B) values (?, ?)");
        Assertions.assertThat((int)builtInsert.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((int)builtInsert.getIndexes(colB)[0]).isEqualTo(2);
        Assertions.assertThat((Object)builtInsert.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
        Assertions.assertThat((Object)builtInsert.getParameterBinder((Object)colB)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildInsert_dmlNameProviderUsed() {
        Table toto = new Table(null, "Toto");
        final Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap()){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        DMLGenerator testInstance = new DMLGenerator((ParameterBinderIndex)this.currentDialect.getColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, k -> dmlNameProvider);
        ColumnParameterizedSQL builtInsert = testInstance.buildInsert((Iterable)toto.getColumns());
        Assertions.assertThat((String)builtInsert.getSQL()).isEqualTo("insert into Toto('key', B) values (?, ?)");
        Assertions.assertThat((int)builtInsert.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((int)builtInsert.getIndexes(colB)[0]).isEqualTo(2);
        Assertions.assertThat((Object)builtInsert.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
        Assertions.assertThat((Object)builtInsert.getParameterBinder((Object)colB)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildUpdate() {
        Table toto = new Table(null, "Toto");
        Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        PreparedUpdate builtUpdate = this.testInstance.buildUpdate((Iterable)toto.getColumns(), (Iterable)Arrays.asList((Object[])new Column[]{colA}));
        Assertions.assertThat((String)builtUpdate.getSQL()).isEqualTo("update Toto set A = ?, B = ? where A = ?");
        Assertions.assertThat((int)builtUpdate.getIndex(new Mapping.UpwhereColumn(colA, true))).isEqualTo(1);
        Assertions.assertThat((int)builtUpdate.getIndex(new Mapping.UpwhereColumn(colB, true))).isEqualTo(2);
        Assertions.assertThat((int)builtUpdate.getIndex(new Mapping.UpwhereColumn(colA, false))).isEqualTo(3);
        Assertions.assertThat((Object)builtUpdate.getParameterBinder((Object)new Mapping.UpwhereColumn(colA, true))).isEqualTo((Object)this.stringBinder);
        Assertions.assertThat((Object)builtUpdate.getParameterBinder((Object)new Mapping.UpwhereColumn(colB, true))).isEqualTo((Object)this.stringBinder);
        Assertions.assertThat((Object)builtUpdate.getParameterBinder((Object)new Mapping.UpwhereColumn(colA, false))).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildUpdate_dmlNameProviderUsed() {
        Table toto = new Table(null, "Toto");
        final Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap()){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        DMLGenerator testInstance = new DMLGenerator((ParameterBinderIndex)this.currentDialect.getColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, k -> dmlNameProvider);
        PreparedUpdate builtUpdate = testInstance.buildUpdate((Iterable)toto.getColumns(), (Iterable)Arrays.asList((Object[])new Column[]{colA, colB}));
        Assertions.assertThat((String)builtUpdate.getSQL()).isEqualTo("update Toto set 'key' = ?, B = ? where 'key' = ? and B = ?");
        Assertions.assertThat((int)builtUpdate.getIndex(new Mapping.UpwhereColumn(colA, true))).isEqualTo(1);
        Assertions.assertThat((int)builtUpdate.getIndex(new Mapping.UpwhereColumn(colB, true))).isEqualTo(2);
        Assertions.assertThat((int)builtUpdate.getIndex(new Mapping.UpwhereColumn(colA, false))).isEqualTo(3);
        Assertions.assertThat((Object)builtUpdate.getParameterBinder((Object)new Mapping.UpwhereColumn(colA, true))).isEqualTo((Object)this.stringBinder);
        Assertions.assertThat((Object)builtUpdate.getParameterBinder((Object)new Mapping.UpwhereColumn(colB, true))).isEqualTo((Object)this.stringBinder);
        Assertions.assertThat((Object)builtUpdate.getParameterBinder((Object)new Mapping.UpwhereColumn(colA, false))).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildDelete() {
        Table toto = new Table(null, "Toto");
        Column colA = toto.addColumn("A", String.class);
        toto.addColumn("B", String.class);
        ColumnParameterizedSQL builtDelete = this.testInstance.buildDelete(toto, (Iterable)Arrays.asList((Object[])new Column[]{colA}));
        Assertions.assertThat((String)builtDelete.getSQL()).isEqualTo("delete from Toto where A = ?");
        Assertions.assertThat((int)builtDelete.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtDelete.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildDelete_dmlNameProviderUsed() {
        Table toto = new Table(null, "Toto");
        final Column colA = toto.addColumn("A", String.class);
        toto.addColumn("B", String.class);
        DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap()){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        DMLGenerator testInstance = new DMLGenerator((ParameterBinderIndex)this.currentDialect.getColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, k -> dmlNameProvider);
        ColumnParameterizedSQL builtDelete = testInstance.buildDelete(toto, (Iterable)Arrays.asList((Object[])new Column[]{colA}));
        Assertions.assertThat((String)builtDelete.getSQL()).isEqualTo("delete from Toto where 'key' = ?");
        Assertions.assertThat((int)builtDelete.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtDelete.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildMassiveDelete() {
        Table toto = new Table(null, "Toto");
        Column colA = toto.addColumn("A", String.class);
        toto.addColumn("B", String.class);
        Set<Column> keys = Collections.singleton(colA);
        ColumnParameterizedSQL builtDelete = this.testInstance.buildDeleteByKey(toto, keys, 2);
        Assertions.assertThat((String)builtDelete.getSQL()).isEqualTo("delete from Toto where A in (?, ?)");
        Assertions.assertThat((int)builtDelete.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtDelete.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildMassiveDelete_multipleKeys() {
        Table toto = new Table(null, "Toto");
        Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        toto.addColumn("C", String.class);
        List keys = Arrays.asList((Object[])new Column[]{colA, colB});
        ColumnParameterizedSQL builtDelete = this.testInstance.buildDeleteByKey(toto, (Collection)keys, 3);
        Assertions.assertThat((String)builtDelete.getSQL()).isEqualTo("delete from Toto where (A, B) in ((?, ?), (?, ?), (?, ?))");
        Assertions.assertThat((int)builtDelete.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtDelete.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildMassiveDelete_dmlNameProviderUsed() {
        Table toto = new Table(null, "Toto");
        final Column colA = toto.addColumn("A", String.class);
        toto.addColumn("B", String.class);
        DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap()){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        DMLGenerator testInstance = new DMLGenerator((ParameterBinderIndex)this.currentDialect.getColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, k -> dmlNameProvider);
        Set<Column> singleton = Collections.singleton(colA);
        ColumnParameterizedSQL builtDelete = testInstance.buildDeleteByKey(toto, singleton, 1);
        Assertions.assertThat((String)builtDelete.getSQL()).isEqualTo("delete from Toto where 'key' in (?)");
        Assertions.assertThat((int)builtDelete.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtDelete.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildSelect() {
        Table toto = new Table(null, "Toto");
        Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        ColumnParameterizedSQL builtSelect = this.testInstance.buildSelect(toto, (Iterable)Arrays.asList((Object[])new Column[]{colA, colB}), (Iterable)Arrays.asList((Object[])new Column[]{colA, colB}));
        Assertions.assertThat((String)builtSelect.getSQL()).isEqualTo("select A, B from Toto where A = ? and B = ?");
        Assertions.assertThat((int)builtSelect.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtSelect.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildSelect_dmlNameProviderUsed() {
        Table toto = new Table(null, "Toto");
        final Column colA = toto.addColumn("key", String.class);
        Column colB = toto.addColumn("B", String.class);
        DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap()){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        DMLGenerator testInstance = new DMLGenerator((ParameterBinderIndex)this.currentDialect.getColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, k -> dmlNameProvider);
        ColumnParameterizedSQL builtSelect = testInstance.buildSelect(toto, (Iterable)Arrays.asList((Object[])new Column[]{colA, colB}), (Iterable)Arrays.asList((Object[])new Column[]{colA, colB}));
        Assertions.assertThat((String)builtSelect.getSQL()).isEqualTo("select 'key', B from Toto where 'key' = ? and B = ?");
        Assertions.assertThat((int)builtSelect.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtSelect.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildMassiveSelect() {
        Table toto = new Table(null, "Toto");
        Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        List selection = Arrays.asList((Object[])new Column[]{colA, colB});
        Set<Column> keys = Collections.singleton(colA);
        ColumnParameterizedSelect builtSelect = this.testInstance.buildSelectByKey(toto, (Iterable)selection, keys, 5);
        Assertions.assertThat((String)builtSelect.getSQL()).isEqualTo("select A, B from Toto where A in (?, ?, ?, ?, ?)");
        Assertions.assertThat((int)builtSelect.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtSelect.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildMassiveSelect_multipleKeys() {
        Table toto = new Table(null, "Toto");
        Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        List selection = Arrays.asList((Object[])new Column[]{colA, colB});
        LinkedHashSet keys = Arrays.asSet((Object[])new Column[]{colA, colB});
        ColumnParameterizedSelect builtSelect = this.testInstance.buildSelectByKey(toto, (Iterable)selection, (Collection)keys, 3);
        Assertions.assertThat((String)builtSelect.getSQL()).isEqualTo("select A, B from Toto where (A, B) in ((?, ?), (?, ?), (?, ?))");
        Assertions.assertThat((int)builtSelect.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtSelect.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }

    @Test
    public void buildMassiveSelect_dmlNameProviderUsed() {
        Table toto = new Table(null, "Toto");
        final Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap()){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        DMLGenerator testInstance = new DMLGenerator((ParameterBinderIndex)this.currentDialect.getColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, k -> dmlNameProvider);
        Set<Column> keys = Collections.singleton(colA);
        ColumnParameterizedSelect builtSelect = testInstance.buildSelectByKey(toto, (Iterable)Arrays.asList((Object[])new Column[]{colA, colB}), keys, 5);
        Assertions.assertThat((String)builtSelect.getSQL()).isEqualTo("select 'key', B from Toto where 'key' in (?, ?, ?, ?, ?)");
        Assertions.assertThat((int)builtSelect.getIndexes(colA)[0]).isEqualTo(1);
        Assertions.assertThat((Object)builtSelect.getParameterBinder((Object)colA)).isEqualTo((Object)this.stringBinder);
    }
}

