/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.ConnectionSettings;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.PersistenceContextConfigurationBuilder;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSelector;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Sorter;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class PersistenceContextConfigurationBuilderTest {
    private final DatabaseSequenceSelectorFactory SEQUENCE_SELECT_BUILDER = new DatabaseSequenceSelectorFactory(){

        public DatabaseSequenceSelector create(Sequence databaseSequence, ConnectionProvider connectionProvider) {
            return new DatabaseSequenceSelector(databaseSequence, "SELECT NEXT VALUE FOR " + databaseSequence.getAbsoluteName(), new ReadOperationFactory(), connectionProvider);
        }
    };

    PersistenceContextConfigurationBuilderTest() {
    }

    @Test
    void inOperatorMaxSize() {
        final ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        DefaultTypeMapping javaTypeToSqlTypes = new DefaultTypeMapping();
        ParameterBinderRegistry parameterBinderRegistry = new ParameterBinderRegistry();
        PersistenceContextConfigurationBuilder testInstance = new PersistenceContextConfigurationBuilder(new DatabaseVendorSettings((Set)Arrays.asSet((Object[])new String[]{"aKeyWord"}), '`', (JavaTypeToSqlTypeMapping)javaTypeToSqlTypes, parameterBinderRegistry, (parameterBinders, dmlNameProviderFactory, sqlTypeRegistry) -> {
            DMLGenerator dmlGenerator = new DMLGenerator(parameterBinders, (Sorter)DMLGenerator.NoopSorter.INSTANCE, dmlNameProviderFactory);
            DDLTableGenerator ddlTableGenerator = new DDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
            DDLSequenceGenerator ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
            return new SQLOperationsFactories(new WriteOperationFactory(), new ReadOperationFactory(), dmlGenerator, ddlTableGenerator, ddlSequenceGenerator);
        }, new GeneratedKeysReaderFactory(){

            public <I> GeneratedKeysReader<I> build(String keyName, Class<I> columnType) {
                return new GeneratedKeysReader(keyName, (ResultSetReader)columnBinderRegistry.getBinder(columnType));
            }
        }, this.SEQUENCE_SELECT_BUILDER, 100, false), new ConnectionSettings((DataSource)Mockito.mock(DataSource.class), 10, 150, 3));
        PersistenceContextConfigurationBuilder.PersistenceContextConfiguration builtConfiguration = testInstance.build();
        Assertions.assertThat((int)builtConfiguration.getDialect().getInOperatorMaxSize()).isEqualTo(150);
    }

    @Test
    <T extends Table<T>> void quoteKeyWords() {
        final ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        DefaultTypeMapping javaTypeToSqlTypes = new DefaultTypeMapping();
        ParameterBinderRegistry parameterBinderRegistry = new ParameterBinderRegistry();
        PersistenceContextConfigurationBuilder testInstance = new PersistenceContextConfigurationBuilder(new DatabaseVendorSettings((Set)Arrays.asSet((Object[])new String[]{"aKeyWord"}), '`', (JavaTypeToSqlTypeMapping)javaTypeToSqlTypes, parameterBinderRegistry, (parameterBinders, dmlNameProviderFactory, sqlTypeRegistry) -> {
            DMLGenerator dmlGenerator = new DMLGenerator(parameterBinders, (Sorter)DMLGenerator.NoopSorter.INSTANCE, dmlNameProviderFactory);
            DDLTableGenerator ddlTableGenerator = new DDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
            DDLSequenceGenerator ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
            return new SQLOperationsFactories(new WriteOperationFactory(), new ReadOperationFactory(), dmlGenerator, ddlTableGenerator, ddlSequenceGenerator);
        }, new GeneratedKeysReaderFactory(){

            public <I> GeneratedKeysReader<I> build(String keyName, Class<I> columnType) {
                return new GeneratedKeysReader(keyName, (ResultSetReader)columnBinderRegistry.getBinder(columnType));
            }
        }, this.SEQUENCE_SELECT_BUILDER, 100, false), new ConnectionSettings((DataSource)Mockito.mock(DataSource.class), 10, 150, 3));
        PersistenceContextConfigurationBuilder.PersistenceContextConfiguration builtConfiguration = testInstance.build();
        Table totoTable = new Table("aKeyWord");
        Column idColumn = totoTable.addColumn("id", Long.TYPE);
        Assertions.assertThat((String)builtConfiguration.getDialect().getDdlTableGenerator().generateCreateTable(totoTable)).isEqualTo("create table `aKeyWord`(id bigint not null)");
        Assertions.assertThat((String)builtConfiguration.getDialect().getDmlGenerator().buildInsert((Iterable)Arrays.asSet((Object[])new Column[]{idColumn})).getSQL()).isEqualTo("insert into `aKeyWord`(id) values (?)");
        Assertions.assertThat((String)builtConfiguration.getDialect().getDmlGenerator().buildUpdate((Iterable)Arrays.asSet((Object[])new Column[]{idColumn}), (Iterable)Arrays.asSet((Object[])new Column[]{idColumn})).getSQL()).isEqualTo("update `aKeyWord` set id = ? where id = ?");
        Assertions.assertThat((String)builtConfiguration.getDialect().getDmlGenerator().buildDelete(totoTable, (Iterable)Arrays.asSet((Object[])new Column[]{idColumn})).getSQL()).isEqualTo("delete from `aKeyWord` where id = ?");
        Assertions.assertThat((String)builtConfiguration.getDialect().getDmlGenerator().buildSelect(totoTable, (Iterable)Arrays.asSet((Object[])new Column[]{idColumn}), (Iterable)Arrays.asSet((Object[])new Column[]{idColumn})).getSQL()).isEqualTo("select id from `aKeyWord` where id = ?");
        Query query = new Query((Fromable)totoTable);
        query.select((Selectable)idColumn, new Selectable[0]);
        query.where(idColumn, (ConditionalOperator)Operators.eq((Object)idColumn));
        query.groupBy(idColumn, new Column[0]);
        query.having(new Object[]{idColumn, Operators.eq((Object)idColumn)});
        Assertions.assertThat((String)builtConfiguration.getDialect().getQuerySQLBuilderFactory().queryBuilder(query).toSQL()).isEqualTo("select `aKeyWord`.id from `aKeyWord` where `aKeyWord`.id = `aKeyWord`.id group by `aKeyWord`.id having `aKeyWord`.id= `aKeyWord`.id");
    }

    @Test
    <T extends Table<T>> void quoteAllSQLIdentifiers() {
        final ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        DefaultTypeMapping javaTypeToSqlTypes = new DefaultTypeMapping();
        ParameterBinderRegistry parameterBinderRegistry = new ParameterBinderRegistry();
        PersistenceContextConfigurationBuilder testInstance = new PersistenceContextConfigurationBuilder(new DatabaseVendorSettings((Set)Arrays.asSet((Object[])new String[]{"aKeyWord"}), '`', (JavaTypeToSqlTypeMapping)javaTypeToSqlTypes, parameterBinderRegistry, (parameterBinders, dmlNameProviderFactory, sqlTypeRegistry) -> {
            DMLGenerator dmlGenerator = new DMLGenerator(parameterBinders, (Sorter)DMLGenerator.NoopSorter.INSTANCE, dmlNameProviderFactory);
            DDLTableGenerator ddlTableGenerator = new DDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
            DDLSequenceGenerator ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
            return new SQLOperationsFactories(new WriteOperationFactory(), new ReadOperationFactory(), dmlGenerator, ddlTableGenerator, ddlSequenceGenerator);
        }, new GeneratedKeysReaderFactory(){

            public <I> GeneratedKeysReader<I> build(String keyName, Class<I> columnType) {
                return new GeneratedKeysReader(keyName, (ResultSetReader)columnBinderRegistry.getBinder(columnType));
            }
        }, this.SEQUENCE_SELECT_BUILDER, 100, false), new ConnectionSettings((DataSource)Mockito.mock(DataSource.class), 10, 150, 3));
        testInstance.quoteAllSQLIdentifiers();
        PersistenceContextConfigurationBuilder.PersistenceContextConfiguration builtConfiguration = testInstance.build();
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", Long.TYPE);
        Assertions.assertThat((String)builtConfiguration.getDialect().getDdlTableGenerator().generateCreateTable(totoTable)).isEqualTo("create table `Toto`(`id` bigint not null)");
        Assertions.assertThat((String)builtConfiguration.getDialect().getDmlGenerator().buildInsert((Iterable)Arrays.asSet((Object[])new Column[]{idColumn})).getSQL()).isEqualTo("insert into `Toto`(`id`) values (?)");
        Assertions.assertThat((String)builtConfiguration.getDialect().getDmlGenerator().buildUpdate((Iterable)Arrays.asSet((Object[])new Column[]{idColumn}), (Iterable)Arrays.asSet((Object[])new Column[]{idColumn})).getSQL()).isEqualTo("update `Toto` set `id` = ? where `id` = ?");
        Assertions.assertThat((String)builtConfiguration.getDialect().getDmlGenerator().buildDelete(totoTable, (Iterable)Arrays.asSet((Object[])new Column[]{idColumn})).getSQL()).isEqualTo("delete from `Toto` where `id` = ?");
        Assertions.assertThat((String)builtConfiguration.getDialect().getDmlGenerator().buildSelect(totoTable, (Iterable)Arrays.asSet((Object[])new Column[]{idColumn}), (Iterable)Arrays.asSet((Object[])new Column[]{idColumn})).getSQL()).isEqualTo("select `id` from `Toto` where `id` = ?");
        Query query = new Query((Fromable)totoTable);
        query.select((Selectable)idColumn, new Selectable[0]);
        query.where(idColumn, (ConditionalOperator)Operators.eq((Object)idColumn));
        query.groupBy(idColumn, new Column[0]);
        query.having(new Object[]{idColumn, Operators.eq((Object)idColumn)});
        Assertions.assertThat((String)builtConfiguration.getDialect().getQuerySQLBuilderFactory().queryBuilder(query).toSQL()).isEqualTo("select `Toto`.`id` from `Toto` where `Toto`.`id` = `Toto`.`id` group by `Toto`.`id` having `Toto`.`id`= `Toto`.`id`");
    }
}

