/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.matchers.CapturingMatcher;
import org.mockito.internal.util.Primitives;

public class PersistenceContextTest {
    private static <T> T capture(Class<T> type, CapturingMatcher<Object> capturingMatcher) {
        Mockito.argThat(capturingMatcher);
        return (T)Primitives.defaultValue(type);
    }

    @Test
    void insert() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        testInstance.insert(totoTable).set(id, (Object)1L).set(name, (Object)"Hello world !").execute();
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("insert into toto(id, name) values (?, ?)");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).containsExactly(new Object[]{1L, "Hello world !"});
    }

    @Test
    void update() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        testInstance.update(totoTable).set(id, (Object)1L).execute();
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("update toto set id = ?");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).containsExactly(new Object[]{1L});
    }

    @Test
    void update_withWhere() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        testInstance.update(totoTable).set(id, (Object)42L).where(id, (ConditionalOperator)Operators.eq((Object)666L)).execute();
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("update toto set id = ? where id = ?");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).containsExactly(new Object[]{42L, 666L});
    }

    @Test
    void delete() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        ((PersistenceContext.ExecutableCriteria)testInstance.delete(totoTable).where(id, (ConditionalOperator)Operators.eq((Object)42L)).and(name, (ConditionalOperator)Operators.eq((Object)"Hello world !"))).execute();
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("delete from toto where id = ? and name = ?");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).containsExactly(new Object[]{42L, "Hello world !"});
    }

    @Test
    void newQuery_singleResult() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)42).add((Object)"name", (Object)"tata").add((Object)"count", (Object)666)})));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Integer count = (Integer)testInstance.newQuery((CharSequence)"select count(*) as count from Toto", Integer.class).mapKey("count", Integer.class).execute(Accumulators.getFirst());
        Assertions.assertThat((Integer)count).isEqualTo(666);
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("select count(*) as count from Toto");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).isEmpty();
    }
}

