/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.autoconfigure;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.ConnectionSettings;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PersistenceContextConfigurationBuilder;
import org.codefilarete.stalactite.spring.autoconfigure.DialectCustomizer;
import org.codefilarete.stalactite.spring.autoconfigure.StalactiteAutoConfiguration;
import org.codefilarete.stalactite.spring.autoconfigure.StalactiteRepositoriesRegistrar;
import org.codefilarete.stalactite.spring.repository.StalactiteRepository;
import org.codefilarete.stalactite.spring.repository.StalactiteRepositoryFactoryBean;
import org.codefilarete.stalactite.spring.repository.config.SpringDataPersistenceContextConfigurationBuilder;
import org.codefilarete.stalactite.spring.transaction.StalactitePlatformTransactionManager;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.DialectResolver;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.tool.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

@AutoConfiguration(after={StalactiteAutoConfiguration.class, TaskExecutionAutoConfiguration.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnClass(value={StalactiteRepository.class})
@ConditionalOnMissingBean(value={StalactiteRepositoryFactoryBean.class})
@ConditionalOnProperty(prefix="spring.data.stalactite.repositories", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={StalactiteRepositoriesImportSelector.class})
public class StalactiteRepositoriesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PersistenceContext persistenceContext(PersistenceContextConfigurationBuilder.PersistenceContextConfiguration persistenceContextConfiguration, Dialect dialect) {
        return new PersistenceContext(persistenceContextConfiguration.getConnectionConfiguration(), dialect);
    }

    @Bean
    @ConditionalOnMissingBean
    public PersistenceContextConfigurationBuilder.PersistenceContextConfiguration persistenceContextConfigurationBuilder(DatabaseVendorSettings databaseVendorSettings, ConnectionSettings connectionSettings) {
        SpringDataPersistenceContextConfigurationBuilder persistenceContextConfigurationBuilder = new SpringDataPersistenceContextConfigurationBuilder(databaseVendorSettings, connectionSettings);
        return persistenceContextConfigurationBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public StalactitePlatformTransactionManager platformTransactionManager(PersistenceContextConfigurationBuilder.PersistenceContextConfiguration persistenceContextConfiguration) {
        return (StalactitePlatformTransactionManager)persistenceContextConfiguration.getConnectionConfiguration().getConnectionProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public Dialect dialect(PersistenceContextConfigurationBuilder.PersistenceContextConfiguration persistenceContextConfiguration, ObjectProvider<DialectCustomizer> dialectCustomizer) {
        Dialect dialect = persistenceContextConfiguration.getDialect();
        Nullable.nullable((Object)dialectCustomizer.getIfAvailable()).invoke(customizer -> customizer.customize(dialect));
        return dialect;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionSettings connectionSettings(DataSource dataSource) {
        return new ConnectionSettings(dataSource, 10, 100, 3);
    }

    @Bean
    @ConditionalOnMissingBean
    public DatabaseVendorSettings databaseVendorSettings(DialectResolver dialectResolver, DataSource dataSource) throws SQLException {
        DatabaseVendorSettings databaseVendorSettings;
        try (Connection connection = dataSource.getConnection();){
            databaseVendorSettings = dialectResolver.determineVendorSettings(connection);
        }
        return databaseVendorSettings;
    }

    @Bean
    @ConditionalOnMissingBean
    public DialectResolver dialectResolver() {
        return new ServiceLoaderDialectResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    public StalactitePlatformTransactionManager stalactitePlatformTransactionManager(DataSource dataSource) {
        return new StalactitePlatformTransactionManager(dataSource);
    }

    static class StalactiteRepositoriesImportSelector
    implements ImportSelector {
        StalactiteRepositoriesImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return new String[]{StalactiteRepositoriesRegistrar.class.getName()};
        }
    }
}

