/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository;

import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.SimpleStalactiteRepository;
import org.codefilarete.stalactite.spring.repository.query.CreateQueryLookupStrategy;
import org.codefilarete.stalactite.spring.repository.query.DeclaredQueryLookupStrategy;
import org.codefilarete.stalactite.spring.repository.query.bean.BeanQueryLookupStrategy;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.exception.NotImplementedException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;

public class StalactiteRepositoryFactory
extends RepositoryFactorySupport {
    private final AdvancedEntityPersister<?, ?> entityPersister;
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;
    private BeanFactory beanFactory;

    public StalactiteRepositoryFactory(AdvancedEntityPersister<?, ?> entityPersister, Dialect dialect, ConnectionProvider connectionProvider) {
        this.entityPersister = entityPersister;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        throw new NotImplementedException("waiting for use case");
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return new SimpleStalactiteRepository((EntityPersister<?, ?>)this.entityPersister);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleStalactiteRepository.class;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        switch ((QueryLookupStrategy.Key)Objects.preventNull((Object)key, (Object)QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND)) {
            case CREATE: {
                return Optional.of(new CreateQueryLookupStrategy(this.entityPersister));
            }
            case USE_DECLARED_QUERY: {
                return Optional.of(new DeclaredQueryLookupStrategy(this.entityPersister, this.dialect, this.connectionProvider));
            }
            case CREATE_IF_NOT_FOUND: {
                return Optional.of(new CreateIfNotFoundQueryLookupStrategy(new BeanQueryLookupStrategy(this.entityPersister, this.dialect, this.connectionProvider, this.beanFactory), new DeclaredQueryLookupStrategy(this.entityPersister, this.dialect, this.connectionProvider), new CreateQueryLookupStrategy(this.entityPersister)));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", key));
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    implements QueryLookupStrategy {
        private final Iterable<QueryLookupStrategy> lookupStrategies;

        public CreateIfNotFoundQueryLookupStrategy(QueryLookupStrategy ... lookupStrategies) {
            this.lookupStrategies = Arrays.asSet((Object[])lookupStrategies);
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            return (RepositoryQuery)Iterables.find(this.lookupStrategies, lookupStrategy -> lookupStrategy.resolveQuery(method, metadata, factory, namedQueries), java.util.Objects::nonNull).getRight();
        }
    }
}

