/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphicEntitySelector;
import org.codefilarete.stalactite.engine.runtime.ColumnCloneAwareOrderBy;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.SingleTableRootJoinNode;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public class SingleTablePolymorphismEntitySelector<C, I, T extends Table<T>, DTYPE>
extends AbstractPolymorphicEntitySelector<C, I, T> {
    @VisibleForTesting
    static final String DISCRIMINATOR_ALIAS = "DISCRIMINATOR";
    private final IdentifierAssembler<I, T> identifierAssembler;
    private final Column<T, DTYPE> discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;
    private final EntityJoinTree<C, I> singleLoadEntityJoinTree;

    public SingleTablePolymorphismEntitySelector(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister.getEntityJoinTree(), persisterPerSubclass, connectionProvider, dialect);
        this.identifierAssembler = mainPersister.getMapping().getIdMapping().getIdentifierAssembler();
        this.discriminatorColumn = discriminatorColumn;
        this.polymorphismPolicy = polymorphismPolicy;
        this.singleLoadEntityJoinTree = this.buildSingleLoadEntityJoinTree(mainPersister, persisterPerSubclass);
    }

    private SingleLoadEntityJoinTree<C, I, DTYPE> buildSingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass) {
        SingleLoadEntityJoinTree<C, I, DTYPE> result = new SingleLoadEntityJoinTree<C, I, DTYPE>(mainPersister, new HashSet<ConfiguredRelationalPersister<C, I>>(persisterPerSubclass.values()), this.discriminatorColumn, this.polymorphismPolicy);
        mainPersister.getEntityJoinTree().projectTo(result, "ROOT");
        return result;
    }

    @Override
    Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        return super.selectWithSingleQuery(where, orderByClauseConsumer, limitAwareConsumer, this.singleLoadEntityJoinTree, this.dialect, this.connectionProvider);
    }

    @Override
    Set<C> selectIn2Phases(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery entityTreeQuery = new EntityTreeQueryBuilder(this.mainEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where.getCriteria(), entityTreeQuery.getColumnClones());
        query.getSelectSurrogate().clear();
        PrimaryKey pk = ((Table)this.mainEntityJoinTree.getRoot().getTable()).getPrimaryKey();
        pk.getColumns().forEach(column -> query.select((Selectable)column, column.getAlias()));
        query.select(this.discriminatorColumn, DISCRIMINATOR_ALIAS);
        HashMap<String, ResultSetReader> columnReaders = new HashMap<String, ResultSetReader>();
        Map aliases = query.getAliases();
        aliases.forEach((selectable, s) -> {
            ResultSetReader cfr_ignored_0 = (ResultSetReader)columnReaders.put((String)s, (ResultSetReader)this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)selectable)));
        });
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        orderByClauseConsumer.accept(new ColumnCloneAwareOrderBy(query.orderBy(), entityTreeQuery.getColumnClones()));
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        Map<Class, Set<I>> idsPerSubclass = this.readIds(sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap()), columnReaders, columnedRow);
        HashSet result = new HashSet();
        idsPerSubclass.forEach((subClass, subEntityIds) -> result.addAll(((ConfiguredRelationalPersister)this.persisterPerSubclass.get(subClass)).select((Iterable)subEntityIds)));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<String, ResultSetReader> columnReaders, ColumnedRow columnedRow) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            KeepOrderMap result = new KeepOrderMap();
            rowIterator.forEachRemaining(arg_0 -> this.lambda$readIds$4(columnedRow, (Map)result, arg_0));
            KeepOrderMap keepOrderMap = result;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$4(ColumnedRow columnedRow, Map result, Row row) {
        Object dtype = row.get(DISCRIMINATOR_ALIAS);
        Object id = this.identifierAssembler.assemble(row, columnedRow);
        result.computeIfAbsent(this.polymorphismPolicy.getClass(dtype), k -> new KeepOrderSet()).add(id);
    }

    private static class SingleLoadEntityJoinTree<C, I, DTYPE>
    extends EntityJoinTree<C, I> {
        public <T extends Table<T>> SingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
            super(self -> new SingleTableRootJoinNode(self, mainPersister, subPersisters, discriminatorColumn, polymorphismPolicy));
        }
    }
}

