/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSelectBuilder;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.QuerySQLBuilderFactoryBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;

public class DefaultDialect
implements Dialect {
    private final SqlTypeRegistry sqlTypeRegistry;
    private final ColumnBinderRegistry columnBinderRegistry;
    private int inOperatorMaxSize = 1000;
    private final DDLTableGenerator ddlTableGenerator;
    private final DDLSequenceGenerator ddlSequenceGenerator;
    private final DMLGenerator dmlGenerator;
    private final WriteOperationFactory writeOperationFactory;
    private final ReadOperationFactory readOperationFactory;
    private QuerySQLBuilderFactory querySQLBuilderFactory;
    private final DMLNameProviderFactory dmlNameProviderFactory;

    public DefaultDialect() {
        this((JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
    }

    public DefaultDialect(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
        this(javaTypeToSqlTypeMapping, new ParameterBinderRegistry());
    }

    public DefaultDialect(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping, ParameterBinderRegistry parameterBinderRegistry) {
        this.sqlTypeRegistry = new SqlTypeRegistry(javaTypeToSqlTypeMapping);
        this.columnBinderRegistry = new ColumnBinderRegistry(parameterBinderRegistry);
        this.dmlNameProviderFactory = this.newDMLNameProviderFactory();
        this.dmlGenerator = this.newDmlGenerator();
        this.ddlTableGenerator = this.newDdlTableGenerator();
        this.ddlSequenceGenerator = this.newDdlSequenceGenerator();
        this.writeOperationFactory = this.newWriteOperationFactory();
        this.readOperationFactory = this.newReadOperationFactory();
        this.querySQLBuilderFactory = new QuerySQLBuilderFactoryBuilder(this.dmlNameProviderFactory, this.columnBinderRegistry, javaTypeToSqlTypeMapping).build();
    }

    public DefaultDialect(SqlTypeRegistry sqlTypeRegistry, ColumnBinderRegistry columnBinderRegistry, DDLTableGenerator ddlTableGenerator, DDLSequenceGenerator ddlSequenceGenerator, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, ReadOperationFactory readOperationFactory, DMLNameProviderFactory dmlNameProviderFactory) {
        this.sqlTypeRegistry = sqlTypeRegistry;
        this.columnBinderRegistry = columnBinderRegistry;
        this.ddlTableGenerator = ddlTableGenerator;
        this.ddlSequenceGenerator = ddlSequenceGenerator;
        this.dmlGenerator = dmlGenerator;
        this.writeOperationFactory = writeOperationFactory;
        this.readOperationFactory = readOperationFactory;
        this.dmlNameProviderFactory = dmlNameProviderFactory;
    }

    protected DMLNameProviderFactory newDMLNameProviderFactory() {
        return DMLNameProvider::new;
    }

    protected DMLGenerator newDmlGenerator() {
        return new DMLGenerator(this.getColumnBinderRegistry(), DMLGenerator.NoopSorter.INSTANCE, this.dmlNameProviderFactory);
    }

    protected DDLTableGenerator newDdlTableGenerator() {
        return new DDLTableGenerator(this.getSqlTypeRegistry(), this.dmlNameProviderFactory);
    }

    protected DDLSequenceGenerator newDdlSequenceGenerator() {
        return new DDLSequenceGenerator(this.dmlNameProviderFactory);
    }

    @Override
    public DDLTableGenerator getDdlTableGenerator() {
        return this.ddlTableGenerator;
    }

    @Override
    public DDLSequenceGenerator getDdlSequenceGenerator() {
        return this.ddlSequenceGenerator;
    }

    @Override
    public DMLGenerator getDmlGenerator() {
        return this.dmlGenerator;
    }

    protected WriteOperationFactory newWriteOperationFactory() {
        return new WriteOperationFactory();
    }

    @Override
    public WriteOperationFactory getWriteOperationFactory() {
        return this.writeOperationFactory;
    }

    protected ReadOperationFactory newReadOperationFactory() {
        return new ReadOperationFactory();
    }

    @Override
    public ReadOperationFactory getReadOperationFactory() {
        return this.readOperationFactory;
    }

    @Override
    public QuerySQLBuilderFactory getQuerySQLBuilderFactory() {
        return this.querySQLBuilderFactory;
    }

    public void setQuerySQLBuilderFactory(QuerySQLBuilderFactory querySQLBuilderFactory) {
        this.querySQLBuilderFactory = querySQLBuilderFactory;
    }

    @Override
    public SqlTypeRegistry getSqlTypeRegistry() {
        return this.sqlTypeRegistry;
    }

    @Override
    public ColumnBinderRegistry getColumnBinderRegistry() {
        return this.columnBinderRegistry;
    }

    @Override
    public DMLNameProviderFactory getDmlNameProviderFactory() {
        return this.dmlNameProviderFactory;
    }

    @Override
    public int getInOperatorMaxSize() {
        return this.inOperatorMaxSize;
    }

    public void setInOperatorMaxSize(int inOperatorMaxSize) {
        if (inOperatorMaxSize <= 0) {
            throw new IllegalArgumentException("SQL operator 'in' must contain at least 1 element");
        }
        this.inOperatorMaxSize = inOperatorMaxSize;
    }

    @Override
    public <I> GeneratedKeysReader<I> buildGeneratedKeysReader(String keyName, Class<I> columnType) {
        return new GeneratedKeysReader(keyName, this.getColumnBinderRegistry().getBinder(columnType));
    }

    @Override
    public GeneratedKeysReaderFactory getGeneratedKeysReaderFactory() {
        return this::buildGeneratedKeysReader;
    }

    @Override
    public DatabaseSequenceSelectBuilder getDatabaseSequenceSelectBuilder() {
        return sequenceName -> "select next value for " + sequenceName;
    }

    @Override
    public boolean supportsTupleCondition() {
        return false;
    }
}

