/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.sequence;

import java.sql.Connection;
import java.util.Map;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.mapping.id.sequence.SequenceStorageOptions;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Database;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Maps;

public class SequencePersister
extends BeanPersister<Sequence, String, SequenceTable> {
    public SequencePersister(Dialect dialect, SeparateTransactionExecutor separateTransactionExecutor, int jdbcBatchSize) {
        this(SequenceStorageOptions.DEFAULT, dialect, separateTransactionExecutor, jdbcBatchSize);
    }

    public SequencePersister(SequenceStorageOptions storageOptions, Dialect dialect, SeparateTransactionExecutor separateTransactionExecutor, int jdbcBatchSize) {
        super(new SequencePersisterConfigurer().buildConfiguration(storageOptions), dialect, new ConnectionConfiguration.ConnectionConfigurationSupport(separateTransactionExecutor, jdbcBatchSize));
    }

    public long reservePool(String sequenceName, int poolSize) {
        SequenceBoundJdbcOperation jdbcOperation = new SequenceBoundJdbcOperation(sequenceName, poolSize);
        ((SeparateTransactionExecutor)this.getConnectionProvider()).executeInNewTransaction(jdbcOperation);
        return jdbcOperation.getUpperBound();
    }

    private static class SequencePersisterConfigurer {
        private SequencePersisterConfigurer() {
        }

        private ClassMapping<Sequence, String, SequenceTable> buildConfiguration(SequenceStorageOptions storageOptions) {
            SequenceTable sequenceTable = new SequenceTable(null, storageOptions.getTable(), storageOptions.getSequenceNameColumn(), storageOptions.getValueColumn());
            return new ClassMapping<Sequence, String, SequenceTable>(Sequence.class, sequenceTable, (Map<ReversibleAccessor<Sequence, Object>, Column<SequenceTable, Object>>)sequenceTable.getPooledSequenceFieldMapping(), (ReversibleAccessor<Sequence, String>)Sequence.SEQUENCE_NAME_FIELD, (IdentifierInsertionManager<Sequence, String>)new AlreadyAssignedIdentifierManager<Sequence, String>(String.class, c -> {}, c -> true));
        }
    }

    private class SequenceBoundJdbcOperation
    implements SeparateTransactionExecutor.JdbcOperation {
        private final String sequenceName;
        private final int stepSize;
        private Sequence sequence;

        private SequenceBoundJdbcOperation(String sequenceName, int nextStepSize) {
            this.sequenceName = sequenceName;
            this.stepSize = nextStepSize;
        }

        @Override
        public void execute(Connection currentSeparateConnection) {
            this.sequence = this.readStep(this.sequenceName);
            if (this.sequence != null) {
                this.sequence.setStep(this.sequence.getStep() + (long)this.stepSize);
                SequencePersister.this.updateById(this.sequence);
            } else {
                this.sequence = new Sequence(this.sequenceName);
                this.sequence.setStep(this.stepSize);
                SequencePersister.this.insert(this.sequence);
            }
        }

        private Sequence readStep(String sequenceName) {
            return (Sequence)SequencePersister.this.select(sequenceName);
        }

        public long getUpperBound() {
            return this.sequence.getStep();
        }
    }

    public static class Sequence {
        private static final PropertyAccessor<Sequence, String> SEQUENCE_NAME_FIELD = PropertyAccessor.fromMethodReference(Sequence::getSequenceName, Sequence::setSequenceName);
        private static final PropertyAccessor<Sequence, Long> VALUE_FIELD = PropertyAccessor.fromMethodReference(Sequence::getStep, Sequence::setStep);
        private String sequenceName;
        private long step;

        private Sequence() {
        }

        public Sequence(String sequenceName) {
            this.sequenceName = sequenceName;
        }

        public Sequence(String sequenceName, long step) {
            this.sequenceName = sequenceName;
            this.step = step;
        }

        public long getStep() {
            return this.step;
        }

        public void setStep(long step) {
            this.step = step;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }

        public void setSequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
        }
    }

    public static class SequenceTable
    extends Table<SequenceTable> {
        private final Column<SequenceTable, Long> nextValColumn;
        private final Column<SequenceTable, String> sequenceNameColumn;

        public SequenceTable(Database.Schema schema, String name, String sequenceNameColName, String nextValColName) {
            super(schema, name);
            this.sequenceNameColumn = this.addColumn(sequenceNameColName, String.class);
            this.sequenceNameColumn.setPrimaryKey(true);
            this.nextValColumn = this.addColumn(nextValColName, Long.TYPE);
        }

        public Map<PropertyAccessor<Sequence, Object>, Column<SequenceTable, Object>> getPooledSequenceFieldMapping() {
            return Maps.forHashMap(PropertyAccessor.class, Column.class).add((Object)Sequence.SEQUENCE_NAME_FIELD, this.sequenceNameColumn).add((Object)Sequence.VALUE_FIELD, this.nextValColumn);
        }
    }
}

