/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSelectBuilder;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.OracleGeneratedKeysReader;
import org.codefilarete.stalactite.sql.OracleSequenceSelectBuilder;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.OracleDDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.OracleParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.OracleTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class OracleDialect
extends DefaultDialect {
    private final OracleSequenceSelectBuilder oracleSequenceSelectBuilder = new OracleSequenceSelectBuilder();

    public OracleDialect() {
        super((JavaTypeToSqlTypeMapping)new OracleTypeMapping(), (ParameterBinderRegistry)new OracleParameterBinderRegistry());
    }

    protected OracleDDLTableGenerator newDdlTableGenerator() {
        return new OracleDDLTableGenerator(this.getSqlTypeRegistry(), OracleDMLNameProvider::new);
    }

    public boolean supportsTupleCondition() {
        return true;
    }

    protected WriteOperationFactory newWriteOperationFactory() {
        return new OracleWriteOperationFactory();
    }

    public <I> GeneratedKeysReader<I> buildGeneratedKeysReader(String keyName, Class<I> columnType) {
        return new OracleGeneratedKeysReader(keyName);
    }

    protected DMLNameProviderFactory newDMLNameProviderFactory() {
        return OracleDMLNameProvider::new;
    }

    public DatabaseSequenceSelectBuilder getDatabaseSequenceSelectBuilder() {
        return this.oracleSequenceSelectBuilder;
    }

    static class OracleWriteOperationFactory
    extends WriteOperationFactory {
        OracleWriteOperationFactory() {
        }

        public <T extends Table<T>> WriteOperation<Column<T, ?>> createInstanceForInsertion(ColumnParameterizedSQL<T> sqlGenerator, ConnectionProvider connectionProvider, LongSupplier expectedRowCount) {
            Set columns = sqlGenerator.getColumnIndexes().keySet();
            Column column = (Column)Iterables.find(columns, Column::isAutoGenerated);
            if (column != null) {
                return this.createInstance((SQLStatement)sqlGenerator, connectionProvider, (connection, sql) -> connection.prepareStatement((String)sql, new String[]{column.getName()}), expectedRowCount);
            }
            return super.createInstanceForInsertion(sqlGenerator, connectionProvider, expectedRowCount);
        }
    }

    public static class OracleDMLNameProvider
    extends DMLNameProvider {
        public static final Set<String> KEYWORDS = Collections.unmodifiableSet(Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[0]));

        public OracleDMLNameProvider(Map<? extends Fromable, String> tableAliases) {
            super(tableAliases);
        }

        public OracleDMLNameProvider(Function<Fromable, String> tableAliaser) {
            super(tableAliaser);
        }

        public String getSimpleName(Selectable<?> column) {
            if (KEYWORDS.contains(column.getExpression())) {
                return "`" + column.getExpression() + "`";
            }
            return super.getSimpleName(column);
        }

        public String getName(Fromable table) {
            if (KEYWORDS.contains(table.getName())) {
                return "`" + super.getName(table) + "`";
            }
            return super.getName(table);
        }
    }
}

