/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.idprovider;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.engine.idprovider.PooledIdentifierProvider;
import org.codefilarete.stalactite.mapping.id.sequence.PooledHiLoSequence;
import org.codefilarete.stalactite.mapping.id.sequence.PooledHiLoSequenceOptions;
import org.codefilarete.stalactite.sql.Dialect;

public class PooledSequenceIdentifierProvider
extends PooledIdentifierProvider<Long> {
    private final PooledHiLoSequence sequenceIdentifierGenerator;

    public PooledSequenceIdentifierProvider(Collection<Long> initialValues, int threshold, Executor executor, Duration timeOut, PooledHiLoSequence sequenceIdentifierGenerator) {
        super(initialValues, threshold, executor, timeOut);
        this.sequenceIdentifierGenerator = sequenceIdentifierGenerator;
    }

    public PooledSequenceIdentifierProvider(Collection<Long> initialValues, int threshold, Executor executor, Duration timeOut, PooledHiLoSequenceOptions options, Dialect dialect, SeparateTransactionExecutor separateTransactionExecutor, int jdbcBatchSize) {
        this(initialValues, threshold, executor, timeOut, new PooledHiLoSequence(options, dialect, separateTransactionExecutor, jdbcBatchSize));
    }

    @Override
    protected Collection<Long> retrieveSomeValues() {
        int poolSize = this.sequenceIdentifierGenerator.getOptions().getPoolSize();
        ArrayList<Long> result = new ArrayList<Long>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            result.add(this.sequenceIdentifierGenerator.next());
        }
        return result;
    }
}

