/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.FluentEntityMappingConfigurationSupportPolymorphismTest;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.exception.NotImplementedException;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportPolymorphismCompositionTest {
    private static final HSQLDBDialect DIALECT = new HSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private final ConnectionProvider connectionProvider = new CurrentThreadConnectionProvider(this.dataSource);
    private PersistenceContext persistenceContext;

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
        DIALECT.getColumnBinderRegistry().register(Color.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER, Color::new, Color::getRgb)));
        DIALECT.getSqlTypeRegistry().put(Color.class, "int");
    }

    @BeforeEach
    public void beforeTest() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, (Dialect)DIALECT);
    }

    @Test
    void joinedTables_joinedTables() {
        EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar.class).map(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar::getPlug))))).build(this.persistenceContext);
        HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext), Table::getName, HashSet::new);
        Assertions.assertThat((Collection)tables).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"AbstractVehicle", "Car", "ElectricCar"}));
        Assertions.assertThat((Collection)this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar dummyCar = new FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar(1L);
        dummyCar.setModel("Renault");
        dummyCar.setColor(new Color(666));
        dummyCar.setPlug(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricPlug.CCS);
        abstractVehiclePersister.insert((Object)dummyCar);
        PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = this.persistenceContext.newQuery((CharSequence)"select * from abstractVehicle left outer join car on abstractVehicle.id = car.id", String.class).mapKey("model", String.class);
        Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
        dummyCar.setModel("Peugeot");
        abstractVehiclePersister.persist((Object)dummyCar);
        Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
        AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        abstractVehiclePersister.delete((Object)dummyCar);
        existingModels = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)existingModels).isEmpty();
    }

    @Test
    void joinedTables_singleTable() {
        EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar.class).map(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar::getPlug), (Object)"CAR")))).build(this.persistenceContext);
        HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext), Table::getName, HashSet::new);
        Assertions.assertThat((Collection)tables).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"Car", "AbstractVehicle"}));
        Assertions.assertThat((Collection)this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar dummyCar = new FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar(1L);
        dummyCar.setModel("Renault");
        dummyCar.setColor(new Color(666));
        dummyCar.setPlug(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricPlug.CCS);
        abstractVehiclePersister.insert((Object)dummyCar);
        PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = this.persistenceContext.newQuery((CharSequence)"select * from car", String.class).mapKey("model", String.class);
        Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
        dummyCar.setModel("Peugeot");
        abstractVehiclePersister.persist((Object)dummyCar);
        Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
        AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        abstractVehiclePersister.delete((Object)dummyCar);
        existingModels = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)existingModels).isEmpty();
    }

    @Test
    void joinedTables_tablePerClass_isNotSupported() {
        FluentEntityMappingBuilder builder = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar.class).map(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar::getPlug)))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.build(this.persistenceContext)).extracting(t -> (NotImplementedException)Exceptions.findExceptionInCauses((Throwable)t, NotImplementedException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Combining joined-tables polymorphism policy with o.c.s.e.PolymorphismPolicy$TablePerClassPolymorphism");
    }

    @Test
    void singleTable_joinedTables() {
        EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar.class).map(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar::getPlug))), (Object)"CAR")).build(this.persistenceContext);
        HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext), Table::getName, HashSet::new);
        Assertions.assertThat((Collection)tables).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"ElectricCar", "AbstractVehicle"}));
        Assertions.assertThat((Collection)this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar dummyCar = new FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar(1L);
        dummyCar.setModel("Renault");
        dummyCar.setColor(new Color(666));
        dummyCar.setPlug(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricPlug.CCS);
        abstractVehiclePersister.insert((Object)dummyCar);
        PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = this.persistenceContext.newQuery((CharSequence)"select * from abstractVehicle", String.class).mapKey("model", String.class);
        Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
        dummyCar.setModel("Peugeot");
        abstractVehiclePersister.persist((Object)dummyCar);
        Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
        AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        abstractVehiclePersister.delete((Object)dummyCar);
        existingModels = (Set)modelQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)existingModels).isEmpty();
    }

    @Test
    void singleTable_singleTable_isNotSupported() {
        FluentEntityMappingBuilder builder = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar.class).map(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar::getPlug), (Object)"ELECTRIC_CAR")), (Object)"CAR"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.build(this.persistenceContext)).extracting(t -> (NotImplementedException)Exceptions.findExceptionInCauses((Throwable)t, NotImplementedException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Combining single-table polymorphism policy with o.c.s.e.PolymorphismPolicy$SingleTablePolymorphism");
    }

    @Test
    void singleTable_tablePerClass_isNotSupported() {
        FluentEntityMappingBuilder builder = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar.class).map(FluentEntityMappingConfigurationSupportPolymorphismTest.ElectricCar::getPlug))), (Object)"CAR"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.build(this.persistenceContext)).extracting(t -> (NotImplementedException)Exceptions.findExceptionInCauses((Throwable)t, NotImplementedException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Combining single-table polymorphism policy with o.c.s.e.PolymorphismPolicy$TablePerClassPolymorphism");
    }
}

