/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.stream.LongStream;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.DerbyGeneratedKeysReader;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.DerbyDDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.statement.DerbyReadOperation;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.DerbyParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.DerbyTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class DerbyDialect
extends DefaultDialect {
    public DerbyDialect() {
        super((JavaTypeToSqlTypeMapping)new DerbyTypeMapping(), (ParameterBinderRegistry)new DerbyParameterBinderRegistry());
    }

    public <I> GeneratedKeysReader<I> buildGeneratedKeysReader(String keyName, Class<I> columnType) {
        return new DerbyGeneratedKeysReader();
    }

    protected DDLTableGenerator newDdlTableGenerator() {
        return new DerbyDDLTableGenerator(this.getSqlTypeRegistry(), this.getDmlNameProviderFactory());
    }

    protected ReadOperationFactory newReadOperationFactory() {
        return new DerbyReadOperationFactory();
    }

    protected WriteOperationFactory newWriteOperationFactory() {
        return new DerbyWriteOperationFactory();
    }

    static class DerbyWriteOperation<ParamType>
    extends WriteOperation<ParamType> {
        private long updatedRowCount = 0L;

        public DerbyWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener) {
            super(sqlGenerator, connectionProvider, rowCountListener);
        }

        public long getUpdatedRowCount() {
            return this.updatedRowCount;
        }

        protected long[] doExecuteBatch() throws SQLException {
            long[] rowCounts = super.doExecuteBatch();
            this.updatedRowCount = LongStream.of(rowCounts).sum();
            return rowCounts;
        }

        public void cancel() throws SQLException {
            EmbedConnection conn = this.preparedStatement.getConnection().unwrap(EmbedConnection.class);
            conn.cancelRunningStatement();
        }
    }

    public static class DerbyWriteOperationFactory
    extends WriteOperationFactory {
        protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, WriteOperation.RowCountListener rowCountListener) {
            return new DerbyWriteOperation<ParamType>(sqlGenerator, connectionProvider, rowCountListener){

                protected void prepareStatement(Connection connection) throws SQLException {
                    this.preparedStatement = (PreparedStatement)statementProvider.apply((Object)connection, (Object)this.getSQL());
                }
            };
        }
    }

    public static class DerbyReadOperationFactory
    extends ReadOperationFactory {
        public <ParamType> ReadOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider) {
            return new DerbyReadOperation(sqlGenerator, connectionProvider);
        }
    }
}

