/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.PostgreSQLParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.PostgreSQLTypeMapping;
import org.codefilarete.tool.collection.Arrays;

public class PostgreSQLDialect
extends DefaultDialect {
    public PostgreSQLDialect() {
        super((JavaTypeToSqlTypeMapping)new PostgreSQLTypeMapping(), (ParameterBinderRegistry)new PostgreSQLParameterBinderRegistry());
    }

    protected DMLNameProviderFactory newDMLNameProviderFactory() {
        return PostgreSQLDMLNameProvider::new;
    }

    public DDLTableGenerator newDdlTableGenerator() {
        return new PostgreSQLDDLTableGenerator(this.getSqlTypeRegistry(), PostgreSQLDMLNameProvider::new);
    }

    public boolean supportsTupleCondition() {
        return true;
    }

    public static class PostgreSQLDDLTableGenerator
    extends DDLTableGenerator {
        public PostgreSQLDDLTableGenerator(SqlTypeRegistry typeMapping, DMLNameProviderFactory dmlNameProviderFactory) {
            super(typeMapping, dmlNameProviderFactory);
        }

        protected String getSqlType(Column column) {
            String sqlType = column.isAutoGenerated() ? " SERIAL" : super.getSqlType(column);
            return sqlType;
        }
    }

    public static class PostgreSQLDMLNameProvider
    extends DMLNameProvider {
        public static final Set<String> KEYWORDS = Collections.unmodifiableSet(Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[0]));

        public PostgreSQLDMLNameProvider(Map<? extends Fromable, String> tableAliases) {
            super(tableAliases);
        }

        public PostgreSQLDMLNameProvider(Function<Fromable, String> tableAliaser) {
            super(tableAliaser);
        }

        public String getSimpleName(Selectable<?> column) {
            if (KEYWORDS.contains(column.getExpression())) {
                return "`" + column.getExpression() + "`";
            }
            return super.getSimpleName(column);
        }

        public String getName(Fromable table) {
            if (KEYWORDS.contains(table.getName())) {
                return "`" + super.getName(table) + "`";
            }
            return super.getName(table);
        }
    }
}

