/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.runtime.DMLExecutorTest;
import org.codefilarete.stalactite.engine.runtime.InsertExecutor;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.PersistentFieldHarvester;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.mapping.id.manager.JDBCGeneratedKeysIdentifierManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.test.DatabaseIntegrationTest;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class InsertExecutorAutoGeneratedKeysITTest
extends DatabaseIntegrationTest {
    protected DataSource dataSource;
    protected Dialect dialect;

    InsertExecutorAutoGeneratedKeysITTest() {
    }

    @BeforeEach
    abstract void createDialect();

    protected <T extends Table<T>> ClassMapping<DMLExecutorTest.Toto, Integer, T> buildAutoGeneratedKeysPersistenceConfiguration() {
        Table targetTable = new Table("Toto");
        PersistentFieldHarvester persistentFieldHarvester = new PersistentFieldHarvester();
        Map mappedFields = persistentFieldHarvester.mapFields(DMLExecutorTest.Toto.class, targetTable);
        PropertyAccessor primaryKeyAccessor = Accessors.propertyAccessor((Field)persistentFieldHarvester.getField("a"));
        Column primaryKeyColumn = persistentFieldHarvester.getColumn(primaryKeyAccessor);
        primaryKeyColumn.primaryKey();
        primaryKeyColumn.setAutoGenerated(true);
        JDBCGeneratedKeysIdentifierManager identifierGenerator = new JDBCGeneratedKeysIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor((ReversibleAccessor)primaryKeyAccessor), this.dialect.getGeneratedKeysReaderFactory().build(primaryKeyColumn.getName(), primaryKeyColumn.getJavaType()), Integer.class);
        DDLDeployer ddlDeployer = new DDLDeployer(this.dialect.getDdlTableGenerator(), this.connectionProvider);
        ddlDeployer.getDdlGenerator().setDdlTableGenerator(this.dialect.getDdlTableGenerator());
        ddlDeployer.getDdlGenerator().setTables((Set)Arrays.asSet((Object[])new Table[]{targetTable}));
        ddlDeployer.deployDDL();
        return new ClassMapping(DMLExecutorTest.Toto.class, targetTable, mappedFields, (ReversibleAccessor)primaryKeyAccessor, (IdentifierInsertionManager)identifierGenerator);
    }

    @Test
    void insert_generated_pk_real_life() {
        ClassMapping persistenceConfiguration = this.buildAutoGeneratedKeysPersistenceConfiguration();
        InsertExecutor testInstance = new InsertExecutor(persistenceConfiguration, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(this.connectionProvider, 3), this.dialect.getDmlGenerator(), this.dialect.getWriteOperationFactory(), 3);
        List totoList = Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(17, 23), new DMLExecutorTest.Toto(29, 31), new DMLExecutorTest.Toto(37, 41), new DMLExecutorTest.Toto(43, 53)});
        testInstance.insert((Iterable)totoList);
        Assertions.assertThat((List)Iterables.collectToList((Iterable)totoList, toto -> toto.a)).isEqualTo((Object)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4}));
    }
}

