/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.lang.reflect.Method;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.Query;
import org.codefilarete.stalactite.spring.repository.query.nativ.NativeQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.nativ.SqlNativeRepositoryQuery;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.tool.Nullable;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class DeclaredQueryLookupStrategy<C>
implements QueryLookupStrategy {
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;
    private final AdvancedEntityPersister<C, ?> entityPersister;

    public DeclaredQueryLookupStrategy(AdvancedEntityPersister<C, ?> entityPersister, Dialect dialect, ConnectionProvider connectionProvider) {
        this.entityPersister = entityPersister;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        Nullable sql = Nullable.nullable((Object)method.getAnnotation(Query.class)).map(Query::value);
        if (sql.isPresent()) {
            NativeQueryMethod queryMethod = new NativeQueryMethod(method, metadata, factory);
            Accumulator accumulator = queryMethod.isCollectionQuery() ? Accumulators.toKeepingOrderSet() : Accumulators.getFirstUnique();
            return new SqlNativeRepositoryQuery<C>(queryMethod, (String)sql.get(), this.entityPersister, accumulator, this.dialect, this.connectionProvider);
        }
        return null;
    }
}

