/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.OperatorSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnitaryOperator;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.QuerySQLBuilderFactoryBuilder;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

class DefaultDialectTest {
    DefaultDialectTest() {
    }

    @Test
    void operatorPrintIsOverridden_itIsTakenIntoAccountInDeleteAndQuery() throws SQLException {
        DefaultDialect testInstance = new DefaultDialect();
        QuerySQLBuilderFactoryBuilder querySQLBuilderFactoryBuilder = new QuerySQLBuilderFactoryBuilder(testInstance.getDmlNameProviderFactory(), testInstance.getColumnBinderRegistry(), testInstance.getSqlTypeRegistry().getJavaTypeToSqlTypeMapping());
        querySQLBuilderFactoryBuilder.withOperatorSQLBuilderFactory(new OperatorSQLBuilderFactory(){

            public OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSQLBuilder(FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
                return new OperatorSQLBuilderFactory.OperatorSQLBuilder(functionSQLBuilder){

                    public <V> void cat(Selectable<V> column, ConditionalOperator<?, V> operator, SQLAppender sql) {
                        if (operator instanceof Like) {
                            sql.cat("LIKE ", new String[0]).catValue((Object)((Like)operator).getValue());
                        } else {
                            super.cat(column, operator, sql);
                        }
                    }
                };
            }
        });
        testInstance.setQuerySQLBuilderFactory(querySQLBuilderFactoryBuilder.build());
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet(Collections.emptySet()));
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlCaptor.capture())).thenReturn((Object)preparedStatementMock);
        PersistenceContext persistenceContext = new PersistenceContext(() -> connectionMock, (Dialect)testInstance);
        Table dummyTable = new Table("dummyTable");
        Column dummyColumn = dummyTable.addColumn("dummyColumn", String.class);
        persistenceContext.newQuery((QueryProvider)QueryEase.select((Selectable)dummyColumn, (Selectable[])new Selectable[0]).from((Fromable)dummyTable).where(dummyColumn, (ConditionalOperator)Operators.like((CharSequence)"x")), String.class).execute(Accumulators.getFirst());
        Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("select dummyTable.dummyColumn from dummyTable where dummyTable.dummyColumn LIKE 'x'");
        persistenceContext.delete(dummyTable).where(dummyColumn, (ConditionalOperator)Operators.like((CharSequence)"x")).execute();
        Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("delete from dummyTable where dummyColumn LIKE ?");
    }

    @Test
    void userDefinedOperatorCanBeTakenIntoAccountByOperatorSQLBuilderOverride() throws SQLException {
        DefaultDialect testInstance = new DefaultDialect();
        QuerySQLBuilderFactoryBuilder querySQLBuilderFactoryBuilder = new QuerySQLBuilderFactoryBuilder(testInstance.getDmlNameProviderFactory(), testInstance.getColumnBinderRegistry(), testInstance.getSqlTypeRegistry().getJavaTypeToSqlTypeMapping());
        querySQLBuilderFactoryBuilder.withOperatorSQLBuilderFactory(new OperatorSQLBuilderFactory(){

            public OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSQLBuilder(FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
                return new OperatorSQLBuilderFactory.OperatorSQLBuilder(functionSQLBuilder){

                    public <V> void cat(Selectable<V> column, ConditionalOperator<?, V> operator, SQLAppender sql) {
                        class MyOperator
                        extends UnitaryOperator<String> {
                            public MyOperator(String value) {
                                super((Object)value);
                            }
                        }
                        if (operator instanceof MyOperator) {
                            sql.cat("myOperator ", new String[0]).catValue((Object)((MyOperator)operator).getValue());
                        } else {
                            super.cat(column, operator, sql);
                        }
                    }
                };
            }
        });
        testInstance.setQuerySQLBuilderFactory(querySQLBuilderFactoryBuilder.build());
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet(Collections.emptySet()));
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlCaptor.capture())).thenReturn((Object)preparedStatementMock);
        PersistenceContext persistenceContext = new PersistenceContext(() -> connectionMock, (Dialect)testInstance);
        Table dummyTable = new Table("dummyTable");
        Column dummyColumn = dummyTable.addColumn("dummyColumn", String.class);
        persistenceContext.newQuery((QueryProvider)QueryEase.select((Selectable)dummyColumn, (Selectable[])new Selectable[0]).from((Fromable)dummyTable).where(dummyColumn, (ConditionalOperator)new MyOperator("42")), String.class).execute(Accumulators.getFirst());
        Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("select dummyTable.dummyColumn from dummyTable where dummyTable.dummyColumn myOperator '42'");
        persistenceContext.delete(dummyTable).where(dummyColumn, (ConditionalOperator)new MyOperator("42")).execute();
        Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("delete from dummyTable where dummyColumn myOperator ?");
    }
}

