/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.Savepoint;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.engine.VersioningStrategy;
import org.codefilarete.stalactite.engine.runtime.AbstractRevertOnRollbackMVCC;
import org.codefilarete.stalactite.engine.runtime.WriteExecutor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.RollbackObserver;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class InsertExecutor<C, I, T extends Table<T>>
extends WriteExecutor<C, I, T>
implements org.codefilarete.stalactite.engine.InsertExecutor<C> {
    private OptimisticLockManager optimisticLockManager = OptimisticLockManager.NOOP_OPTIMISTIC_LOCK_MANAGER;
    private final IdentifierInsertionManager<C, I> identifierInsertionManager;
    private SQLOperation.SQLOperationListener<Column<T, ?>> operationListener;

    public InsertExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        super(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
        this.identifierInsertionManager = mappingStrategy.getIdMapping().getIdentifierInsertionManager();
    }

    public void setVersioningStrategy(VersioningStrategy versioningStrategy) {
        Column versionColumn = this.getMapping().getPropertyToColumn().get(versioningStrategy.getVersionAccessor());
        this.setOptimisticLockManager(new RevertOnRollbackMVCC(this, versioningStrategy, versionColumn, this.getConnectionProvider()));
    }

    public void setOptimisticLockManager(OptimisticLockManager optimisticLockManager) {
        this.optimisticLockManager = optimisticLockManager;
    }

    public void setOperationListener(SQLOperation.SQLOperationListener<Column<T, ?>> listener) {
        this.operationListener = listener;
    }

    @Override
    public void insert(Iterable<? extends C> entities) {
        Set columns = this.getMapping().getInsertableColumns();
        ColumnParameterizedSQL insertStatement = this.getDmlGenerator().buildInsert(columns);
        List entitiesCopy = Iterables.copy(entities);
        WriteOperationFactory.ExpectedBatchedRowCountsSupplier expectedBatchedRowCountsSupplier = new WriteOperationFactory.ExpectedBatchedRowCountsSupplier(entitiesCopy.size(), this.getBatchSize());
        WriteOperation writeOperation = this.getWriteOperationFactory().createInstanceForInsertion(insertStatement, this.getConnectionProvider(), expectedBatchedRowCountsSupplier);
        writeOperation.setListener(this.operationListener);
        WriteExecutor.JDBCBatchingIterator<C> jdbcBatchingIterator = this.identifierInsertionManager.buildJDBCBatchingIterator(entitiesCopy, writeOperation, this.getBatchSize());
        jdbcBatchingIterator.forEachRemaining(entity -> {
            try {
                this.addToBatch(entity, writeOperation);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error while inserting values for " + entity + " in statement \"" + writeOperation.getSqlStatement().getSQL() + "\"", e);
            }
        });
    }

    private void addToBatch(C entity, WriteOperation<Column<T, ?>> writeOperation) {
        Map<Column, Object> insertValues = this.getMapping().getInsertValues(entity);
        this.assertMandatoryColumnsHaveNonNullValues(insertValues);
        this.optimisticLockManager.manageLock(entity, insertValues);
        writeOperation.addBatch(insertValues);
    }

    private void assertMandatoryColumnsHaveNonNullValues(Map<Column<T, ?>, Object> insertValues) {
        Set nonNullColumnsWithNullValues = (Set)Iterables.collect(insertValues.entrySet(), e -> !((Column)e.getKey()).isNullable() && e.getValue() == null, Map.Entry::getKey, HashSet::new);
        if (!nonNullColumnsWithNullValues.isEmpty()) {
            throw new SQLStatement.BindingException("Expected non null value for : " + new StringAppender().ccat((Iterable)Arrays.asTreeSet(Comparator.comparing(Column::getAbsoluteName), (Collection)nonNullColumnsWithNullValues), (Object)", "));
        }
    }

    static class VersioningStrategyRollbackListener<C>
    implements RollbackListener {
        private final VersioningStrategy<C, Object> versioningStrategy;
        private final C instance;
        private final Object previousVersion;

        public VersioningStrategyRollbackListener(VersioningStrategy<C, Object> versioningStrategy, C instance, Object previousVersion) {
            this.versioningStrategy = versioningStrategy;
            this.instance = instance;
            this.previousVersion = previousVersion;
        }

        public void beforeRollback() {
        }

        public void afterRollback() {
            this.versioningStrategy.revert(this.instance, this.previousVersion);
        }

        public void beforeRollback(Savepoint savepoint) {
        }

        public void afterRollback(Savepoint savepoint) {
        }

        public boolean isTemporary() {
            return true;
        }
    }

    private static class RevertOnRollbackMVCC
    extends AbstractRevertOnRollbackMVCC
    implements OptimisticLockManager<C> {
        final /* synthetic */ InsertExecutor this$0;

        private <C extends RollbackObserver & ConnectionProvider> RevertOnRollbackMVCC(VersioningStrategy versioningStrategy, Column versionColumn, C rollbackObserver) {
            this.this$0 = var1_1;
            super(versioningStrategy, versionColumn, rollbackObserver);
        }

        private RevertOnRollbackMVCC(InsertExecutor insertExecutor, VersioningStrategy versioningStrategy, Column versionColumn, ConnectionProvider rollbackObserver) {
            this.this$0 = insertExecutor;
            super(versioningStrategy, versionColumn, rollbackObserver);
        }

        @Override
        public void manageLock(C instance, Map<Column, Object> updateValues) {
            Object previousVersion = this.versioningStrategy.getVersion(instance);
            this.versioningStrategy.upgrade(instance);
            Object newVersion = this.versioningStrategy.getVersion(instance);
            updateValues.put(this.versionColumn, newVersion);
            this.rollbackObserver.addRollbackListener(new VersioningStrategyRollbackListener(this.versioningStrategy, instance, previousVersion));
        }
    }

    static interface OptimisticLockManager<T> {
        public static final OptimisticLockManager NOOP_OPTIMISTIC_LOCK_MANAGER = (o, m) -> {};

        public void manageLock(T var1, Map<Column, Object> var2);
    }
}

