/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.ConnectionSettings;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.QuotingDMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.QuerySQLBuilderFactoryBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;

public class PersistenceContextConfigurationBuilder {
    private final DatabaseVendorSettings vendorSettings;
    private final ConnectionSettings connectionSettings;
    private boolean quoteAllSQLIdentifiers = false;

    public PersistenceContextConfigurationBuilder(DatabaseVendorSettings vendorSettings, ConnectionSettings connectionSettings) {
        this.vendorSettings = vendorSettings;
        this.connectionSettings = connectionSettings;
    }

    public void quoteAllSQLIdentifiers() {
        this.setQuoteAllSQLIdentifiers(true);
    }

    public void setQuoteAllSQLIdentifiers(boolean quoteAllSQLIdentifiers) {
        this.quoteAllSQLIdentifiers = quoteAllSQLIdentifiers;
    }

    public PersistenceContext.PersistenceContextConfiguration build() {
        ConnectionConfiguration.ConnectionConfigurationSupport connectionConfiguration = new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new CurrentThreadConnectionProvider(this.connectionSettings.getDataSource(), this.connectionSettings.getConnectionOpeningRetryMaxCount()), this.connectionSettings.getBatchSize());
        SqlTypeRegistry sqlTypeRegistry = new SqlTypeRegistry(this.vendorSettings.getJavaTypeToSqlTypes());
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry(this.vendorSettings.getParameterBinderRegistry());
        DMLNameProviderFactory dmlNameProviderFactory = this.quoteAllSQLIdentifiers ? tableAliaser -> new QuotingDMLNameProvider(tableAliaser, this.vendorSettings.getQuotingCharacter()) : new DMLNameProviderFactory(){

            @Override
            public DMLNameProvider build(Function<Fromable, String> tableAliaser) {
                return new DMLNameProvider(tableAliaser){
                    private final char quotingCharacter;
                    private final Set<String> keyWords;
                    {
                        this.quotingCharacter = PersistenceContextConfigurationBuilder.this.vendorSettings.getQuotingCharacter();
                        this.keyWords = Collections.unmodifiableSet(Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, PersistenceContextConfigurationBuilder.this.vendorSettings.getKeyWords()));
                    }

                    @Override
                    public String getSimpleName(Selectable<?> column) {
                        String name = super.getSimpleName(column);
                        if (this.keyWords.contains(name)) {
                            return this.quotingCharacter + name + this.quotingCharacter;
                        }
                        return name;
                    }

                    @Override
                    public String getName(Fromable table) {
                        String name = super.getName(table);
                        if (this.keyWords.contains(name)) {
                            return this.quotingCharacter + name + this.quotingCharacter;
                        }
                        return name;
                    }
                };
            }
        };
        SQLOperationsFactories sqlOperationsFactories = this.vendorSettings.getSqlOperationsFactoriesBuilder().build(columnBinderRegistry, dmlNameProviderFactory, sqlTypeRegistry);
        DDLTableGenerator ddlTableGenerator = sqlOperationsFactories.getDdlTableGenerator();
        DMLGenerator dmlGenerator = sqlOperationsFactories.getDmlGenerator();
        WriteOperationFactory writeOperationFactory = sqlOperationsFactories.getWriteOperationFactory();
        ReadOperationFactory readOperationFactory = sqlOperationsFactories.getReadOperationFactory();
        QuerySQLBuilderFactory querySQLBuilderFactory = new QuerySQLBuilderFactoryBuilder(dmlNameProviderFactory, columnBinderRegistry, this.vendorSettings.getJavaTypeToSqlTypes()).build();
        int inOperatorMaxSize = (Integer)Objects.preventNull((Object)this.connectionSettings.getInOperatorMaxSize(), (Object)this.vendorSettings.getInOperatorMaxSize());
        GeneratedKeysReaderFactory generatedKeysReaderFactory = this.vendorSettings.getGeneratedKeysReaderFactory();
        boolean supportsTupleCondition = this.vendorSettings.supportsTupleCondition();
        Dialect.DialectSupport dialect = new Dialect.DialectSupport(ddlTableGenerator, dmlGenerator, writeOperationFactory, readOperationFactory, querySQLBuilderFactory, sqlTypeRegistry, columnBinderRegistry, dmlNameProviderFactory, inOperatorMaxSize, generatedKeysReaderFactory, supportsTupleCondition);
        return new PersistenceContext.PersistenceContextConfiguration(connectionConfiguration, dialect);
    }
}

