/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.Collections;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.sql.MariaDBDMLNameProvider;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Index;
import org.codefilarete.tool.StringAppender;

public class MariaDBDDLTableGenerator
extends DDLTableGenerator {
    public MariaDBDDLTableGenerator(SqlTypeRegistry typeMapping) {
        super(typeMapping, function -> new MariaDBDMLNameProvider(Collections.emptyMap()));
    }

    public String generateDropForeignKey(ForeignKey foreignKey) {
        StringAppender sqlCreateTable = new StringAppender(new Object[]{"alter table ", this.dmlNameProvider.getName((Fromable)foreignKey.getTable()), " drop foreign key ", foreignKey.getName()});
        return sqlCreateTable.toString();
    }

    public String generateDropIndex(Index index) {
        StringAppender sqlDropColumn = new StringAppender(new Object[]{"alter table ", this.dmlNameProvider.getName((Fromable)index.getTable()), " drop index ", index.getName()});
        return sqlDropColumn.toString();
    }

    protected String getSqlType(Column column) {
        String sqlType = super.getSqlType(column);
        if (column.isAutoGenerated()) {
            sqlType = sqlType + " auto_increment";
        }
        return sqlType;
    }
}

