/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.nativ;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.EntityGraphSelector;
import org.codefilarete.stalactite.spring.repository.query.nativ.NativeQueryMethod;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.tool.collection.Arrays;
import org.springframework.core.ResolvableType;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;

public class SqlNativeRepositoryQuery<C>
implements RepositoryQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final NativeQueryMethod queryMethod;
    private final String sql;
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final Accumulator<C, ?, ?> accumulator;
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;

    public SqlNativeRepositoryQuery(NativeQueryMethod queryMethod, String sql, AdvancedEntityPersister<C, ?> entityPersister, Accumulator<C, ?, ?> accumulator, Dialect dialect, ConnectionProvider connectionProvider) {
        this.queryMethod = queryMethod;
        this.sql = sql;
        this.entityPersister = entityPersister;
        this.accumulator = accumulator;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
        if (queryMethod.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries. Offending method: " + (Object)((Object)queryMethod));
        }
        if (queryMethod.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries. Offending method: " + (Object)((Object)queryMethod));
        }
    }

    public NativeQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public Object execute(Object[] parameters) {
        EntityGraphSelector entityGraphSelector = new EntityGraphSelector(this.entityPersister.getEntityJoinTree(), this.connectionProvider, this.dialect);
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.queryMethod.getParameters(), parameters);
        return this.accumulator.collect((Iterable)entityGraphSelector.selectFromQueryBean(this.sql, this.getValues(accessor), this.bindParameters(accessor)));
    }

    private Map<String, PreparedStatementWriter<?>> bindParameters(ParametersParameterAccessor accessor) {
        HashMap result = new HashMap();
        RelationalParameters bindableParameters = (RelationalParameters)this.queryMethod.getParameters().getBindableParameters();
        for (RelationalParameters.RelationalParameter bindableParameter : bindableParameters) {
            Class<Object> valueType;
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            Object value = accessor.getBindableValue(bindableParameter.getIndex());
            if (value instanceof Iterable) {
                ResolvableType resolvableType = bindableParameter.getResolvableType();
                valueType = resolvableType.getGeneric(new int[]{0}).resolve();
            } else {
                valueType = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
            }
            PreparedStatementWriter writer = this.dialect.getColumnBinderRegistry().getWriter(valueType);
            result.put(parameterName, writer);
        }
        return result;
    }

    private Map<String, Object> getValues(ParametersParameterAccessor accessor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (RelationalParameters.RelationalParameter bindableParameter : (RelationalParameters)this.queryMethod.getParameters().getBindableParameters()) {
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            Object value = accessor.getBindableValue(bindableParameter.getIndex());
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                value = values.length == 1 ? values[0] : Arrays.asList((Object[])values);
            }
            result.put(parameterName, value);
        }
        return result;
    }
}

