/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.CompositeKeyMappingConfiguration;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PersisterBuilder;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.VersioningStrategy;
import org.codefilarete.stalactite.engine.cascade.AfterDeleteByIdSupport;
import org.codefilarete.stalactite.engine.cascade.AfterDeleteSupport;
import org.codefilarete.stalactite.engine.cascade.AfterUpdateSupport;
import org.codefilarete.stalactite.engine.cascade.BeforeInsertSupport;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.BeanMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.ExtraTableConfigurer;
import org.codefilarete.stalactite.engine.configurer.FluentEntityMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.NamingConfigurationCollector;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.RelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.polymorphism.PolymorphismPersisterBuilder;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.runtime.CompositeKeyedBeanPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityIsManagedByPersisterAsserter;
import org.codefilarete.stalactite.engine.runtime.OptimizedUpdatePersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.ComposedIdMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.ComposedIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.SimpleIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.BeforeInsertIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.CompositeKeyAlreadyAssignedIdentifierInsertionManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.mapping.id.manager.JDBCGeneratedKeysIdentifierManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.ReadOnlyIterator;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.function.Sequence;
import org.codefilarete.tool.function.SerializableTriFunction;

public class PersisterBuilderImpl<C, I>
implements PersisterBuilder<C, I> {
    private final EntityMappingConfiguration<C, I> entityMappingConfiguration;
    private final MethodReferenceCapturer methodSpy;
    private ColumnBinderRegistry columnBinderRegistry;
    private Table table;
    private final Map<EntityMappingConfiguration, Table> tableMap = new HashMap<EntityMappingConfiguration, Table>();
    private final NamingConfiguration namingConfiguration;

    public PersisterBuilderImpl(EntityMappingConfigurationProvider<C, I> entityMappingConfigurationProvider) {
        this(entityMappingConfigurationProvider.getConfiguration());
    }

    public PersisterBuilderImpl(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
        this.entityMappingConfiguration = entityMappingConfiguration;
        this.methodSpy = new MethodReferenceCapturer();
        NamingConfigurationCollector namingConfigurationCollector = new NamingConfigurationCollector(entityMappingConfiguration);
        this.namingConfiguration = namingConfigurationCollector.collect();
    }

    PersisterBuilderImpl<C, I> setColumnBinderRegistry(ColumnBinderRegistry columnBinderRegistry) {
        this.columnBinderRegistry = columnBinderRegistry;
        return this;
    }

    PersisterBuilderImpl<C, I> setTable(Table table) {
        this.table = table;
        return this;
    }

    @Override
    public ConfiguredRelationalPersister<C, I> build(PersistenceContext persistenceContext) {
        ConfiguredRelationalPersister<C, I> builtPersister = this.build(persistenceContext.getDialect(), OptimizedUpdatePersister.wrapWithQueryCache(persistenceContext.getConnectionConfiguration()), this.table);
        persistenceContext.addPersister(builtPersister);
        return builtPersister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfiguredRelationalPersister<C, I> build(Dialect dialect, ConnectionConfiguration connectionConfiguration, @javax.annotation.Nullable Table table) {
        boolean isInitiator;
        boolean bl = isInitiator = PersisterBuilderContext.CURRENT.get() == null;
        if (isInitiator) {
            PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry()));
        }
        try {
            EntityPersister existingPersister = PersisterBuilderContext.CURRENT.get().getPersisterRegistry().getPersister(this.entityMappingConfiguration.getEntityType());
            if (existingPersister != null) {
                ConfiguredRelationalPersister configuredRelationalPersister = (ConfiguredRelationalPersister)existingPersister;
                return configuredRelationalPersister;
            }
            ConfiguredRelationalPersister<C, I> result = this.doBuild(table, dialect, connectionConfiguration, PersisterBuilderContext.CURRENT.get().getPersisterRegistry());
            if (isInitiator) {
                PersisterBuilderContext.CURRENT.get().getBuildLifeCycleListeners().forEach(BuildLifeCycleListener::afterBuild);
                PersisterBuilderContext.CURRENT.get().getBuildLifeCycleListeners().forEach(BuildLifeCycleListener::afterAllBuild);
            }
            ConfiguredRelationalPersister<C, I> configuredRelationalPersister = result;
            return configuredRelationalPersister;
        }
        finally {
            if (isInitiator) {
                PersisterBuilderContext.CURRENT.remove();
            }
        }
    }

    @VisibleForTesting
    <T extends Table<T>> ConfiguredRelationalPersister<C, I> doBuild(@javax.annotation.Nullable T table, Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry) {
        this.init(dialect.getColumnBinderRegistry(), table);
        this.mapEntityConfigurationToTable();
        AbstractIdentification<C, I> identification = this.determineIdentification();
        MappingPerTable inheritanceMappingPerTable = this.collectPropertiesMappingFromInheritance();
        PrimaryKey<T, I> primaryKey = this.addIdentifyingPrimarykey(identification);
        KeepOrderSet<Table> inheritanceTables = inheritanceMappingPerTable.giveTables();
        inheritanceTables.remove(primaryKey.getTable());
        PersisterBuilderImpl.propagatePrimaryKey(primaryKey, inheritanceTables);
        ArrayList<Table> tables = new ArrayList<Table>((Collection<Table>)inheritanceTables);
        Collections.reverse(tables);
        this.applyForeignKeys(primaryKey, (Set<Table>)new KeepOrderSet(tables));
        PersisterBuilderImpl.addIdentificationToMapping(identification, inheritanceMappingPerTable.getMappings());
        this.determineIdentifierManager(identification, inheritanceMappingPerTable, identification.getIdAccessor(), dialect, connectionConfiguration);
        MappingPerTable.Mapping mainMapping = (MappingPerTable.Mapping)Iterables.first(inheritanceMappingPerTable.getMappings());
        SimpleRelationalEntityPersister<C, I, T> mainPersister = this.buildMainPersister(identification, mainMapping, dialect, connectionConfiguration);
        this.applyExtraTableConfigurations(identification, mainPersister, dialect, connectionConfiguration);
        RelationConfigurer relationConfigurer = new RelationConfigurer(dialect, connectionConfiguration, mainPersister, this.namingConfiguration);
        PersisterBuilderContext.CURRENT.get().runInContext(this.entityMappingConfiguration, () -> inheritanceMappingPerTable.getMappings().stream().map(MappingPerTable.Mapping::getMappingConfiguration).filter(EntityMappingConfiguration.class::isInstance).map(EntityMappingConfiguration.class::cast).forEach(relationConfigurer::configureRelations));
        ConfiguredRelationalPersister result = mainPersister;
        PolymorphismPolicy<C> polymorphismPolicy = this.entityMappingConfiguration.getPolymorphismPolicy();
        if (polymorphismPolicy != null) {
            PolymorphismPersisterBuilder polymorphismPersisterBuilder = new PolymorphismPersisterBuilder(polymorphismPolicy, identification, mainPersister, this.columnBinderRegistry, mainMapping.getMapping(), mainMapping.getReadonlyMapping(), mainMapping.getReadConverters(), mainMapping.getWriteConverters(), this.namingConfiguration);
            result = polymorphismPersisterBuilder.build(dialect, connectionConfiguration);
        }
        if (identification instanceof AbstractIdentification.Identification && ((AbstractIdentification.Identification)identification).getIdentifierPolicy() instanceof ColumnOptions.AlreadyAssignedIdentifierPolicy) {
            final Consumer asPersistedMarker = ((ColumnOptions.AlreadyAssignedIdentifierPolicy)((AbstractIdentification.Identification)identification).getIdentifierPolicy()).getMarkAsPersistedFunction();
            result.addSelectListener(new SelectListener<C, I>(){

                public void afterSelect(Set<? extends C> result) {
                    Iterables.filter(result, java.util.Objects::nonNull).forEach(asPersistedMarker);
                }
            });
        }
        ReadOnlyIterator inheritedMappingIterator = Iterables.reverseIterator((AbstractCollection)inheritanceMappingPerTable.getMappings().getSurrogate());
        Iterator mappings = Iterables.filter((Iterator)inheritedMappingIterator, m -> !mainMapping.equals(m) && !m.isMappedSuperClass());
        KeepOrderSet<SimpleRelationalEntityPersister<C, I, ?>> parentPersisters = this.buildParentPersisters(() -> mappings, identification, mainPersister, dialect, connectionConfiguration);
        this.addCascadesBetweenChildAndParentTable(mainPersister, parentPersisters);
        this.handleVersioningStrategy(mainPersister);
        OptimizedUpdatePersister optimizedPersister = new OptimizedUpdatePersister(new EntityIsManagedByPersisterAsserter(result));
        persisterRegistry.addPersister(optimizedPersister);
        parentPersisters.forEach(arg_0 -> ((PersisterRegistry)persisterRegistry).addPersister(arg_0));
        return optimizedPersister;
    }

    private <T extends Table<T>> void applyExtraTableConfigurations(AbstractIdentification<C, I> identification, SimpleRelationalEntityPersister<C, I, T> mainPersister, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        HashMap<String, Set<EmbeddableMappingConfiguration.Linkage>> extraTableLinkages = new HashMap<String, Set<EmbeddableMappingConfiguration.Linkage>>();
        this.visitInheritedEntityMappingConfigurations(entityMappingConfiguration1 -> {
            EntityMappingConfiguration mappingConfiguration = entityMappingConfiguration1;
            List<EmbeddableMappingConfiguration.Linkage> propertiesMapping = mappingConfiguration.getPropertiesMapping().getPropertiesMapping();
            for (EmbeddableMappingConfiguration.Linkage linkage : propertiesMapping) {
                if (linkage.getExtraTableName() == null) continue;
                extraTableLinkages.computeIfAbsent(linkage.getExtraTableName(), extraTableName -> new HashSet()).add(linkage);
            }
        });
        if (!extraTableLinkages.isEmpty()) {
            ExtraTableConfigurer extraTableConfigurer = new ExtraTableConfigurer(identification, mainPersister, extraTableLinkages, this.columnBinderRegistry, this.namingConfiguration);
            extraTableConfigurer.configure(dialect, connectionConfiguration);
        }
    }

    private <T extends Table<T>> void handleVersioningStrategy(SimpleRelationalEntityPersister<C, I, T> result) {
        VersioningStrategy versioningStrategy = this.entityMappingConfiguration.getOptimisticLockOption();
        if (versioningStrategy != null) {
            Column column = (Column)result.getMapping().getPropertyToColumn().get(versioningStrategy.getVersionAccessor());
            ((ClassMapping)result.getMapping()).addVersionedColumn(versioningStrategy.getVersionAccessor(), column);
            result.getUpdateExecutor().setVersioningStrategy(versioningStrategy);
            result.getInsertExecutor().setVersioningStrategy(versioningStrategy);
        }
    }

    private <T extends Table<T>, TT extends Table<TT>> KeepOrderSet<SimpleRelationalEntityPersister<C, I, ?>> buildParentPersisters(Iterable<MappingPerTable.Mapping<C, ?>> mappings, AbstractIdentification<C, I> identification, SimpleRelationalEntityPersister<C, I, T> mainPersister, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        KeepOrderSet result = new KeepOrderSet();
        PrimaryKey superclassPK = mainPersister.getMainTable().getPrimaryKey();
        Hanger.Holder currentTable = new Hanger.Holder(mainPersister.getMainTable());
        mappings.forEach(mapping -> {
            if (mapping.getMappingConfiguration() instanceof EmbeddableMappingConfiguration) {
                Class entityType = ((EmbeddableMappingConfiguration)mapping.getMappingConfiguration()).getBeanType();
                if (PersisterBuilderContext.CURRENT.get().getPersisterRegistry().getPersister(entityType) != null) {
                    return;
                }
            }
            MappingPerTable.Mapping castedMapping = mapping;
            PrimaryKey subclassPK = castedMapping.targetTable.getPrimaryKey();
            ClassMapping currentMappingStrategy = PersisterBuilderImpl.createClassMappingStrategy(identification.getIdentificationDefiner().getPropertiesMapping() == mapping.giveEmbeddableConfiguration(), castedMapping.targetTable, castedMapping.getMapping(), castedMapping.getReadonlyMapping(), castedMapping.getReadConverters(), castedMapping.getWriteConverters(), castedMapping.propertiesSetByConstructor, identification, mapping.giveEmbeddableConfiguration().getBeanType(), null);
            SimpleRelationalEntityPersister currentPersister = new SimpleRelationalEntityPersister(currentMappingStrategy, dialect, connectionConfiguration);
            result.add(currentPersister);
            if (!currentPersister.getMainTable().equals(currentTable.get())) {
                mainPersister.getEntityMappingTreeSelectExecutor().addMergeJoin("ROOT", currentMappingStrategy, superclassPK, subclassPK);
                currentTable.set((Object)currentPersister.getMainTable());
            }
        });
        return result;
    }

    private <T extends Table<T>> SimpleRelationalEntityPersister<C, I, T> buildMainPersister(AbstractIdentification<C, I> identification, MappingPerTable.Mapping<C, T> mapping, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        EntityMappingConfiguration mappingConfiguration = (EntityMappingConfiguration)((MappingPerTable.Mapping)mapping).mappingConfiguration;
        ClassMapping<C, I, Table> mappingStrategy = PersisterBuilderImpl.createClassMappingStrategy(identification.getIdentificationDefiner().getPropertiesMapping() == mappingConfiguration.getPropertiesMapping(), ((MappingPerTable.Mapping)mapping).targetTable, ((MappingPerTable.Mapping)mapping).mapping, ((MappingPerTable.Mapping)mapping).readonlyMapping, ((MappingPerTable.Mapping)mapping).readConverters, ((MappingPerTable.Mapping)mapping).writeConverters, ((MappingPerTable.Mapping)mapping).propertiesSetByConstructor, identification, mappingConfiguration.getEntityType(), mappingConfiguration.getEntityFactoryProvider());
        if (identification instanceof AbstractIdentification.CompositeKeyIdentification) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager insertionManager = (CompositeKeyAlreadyAssignedIdentifierInsertionManager)identification.getInsertionManager();
            CompositeKeyedBeanPersister compositeKeyPersister = new CompositeKeyedBeanPersister(mappingStrategy, insertionManager, dialect, connectionConfiguration);
            return new SimpleRelationalEntityPersister(compositeKeyPersister, dialect, connectionConfiguration);
        }
        return new SimpleRelationalEntityPersister<C, I, Table>(mappingStrategy, dialect, connectionConfiguration);
    }

    private <T extends Table<T>> void addCascadesBetweenChildAndParentTable(SimpleRelationalEntityPersister<C, I, T> mainPersister, KeepOrderSet<SimpleRelationalEntityPersister<C, I, ?>> superPersisters) {
        KeepOrderSet superPersistersWithChangingTable = new KeepOrderSet();
        Hanger.Holder lastTable = new Hanger.Holder(mainPersister.getMainTable());
        superPersisters.forEach(p -> {
            if (!p.getMainTable().equals(lastTable.get())) {
                superPersistersWithChangingTable.add(p);
            }
            lastTable.set(p.getMainTable());
        });
        PersisterListenerCollection persisterListener = mainPersister.getPersisterListener();
        superPersistersWithChangingTable.forEach(superPersister -> {
            persisterListener.addInsertListener(new BeforeInsertSupport(superPersister::insert, Function.identity()));
            persisterListener.addUpdateListener(new AfterUpdateSupport(superPersister::update, Function.identity()));
            persisterListener.addUpdateByIdListener(new UpdateByIdListener<C>((SimpleRelationalEntityPersister)superPersister){
                final /* synthetic */ SimpleRelationalEntityPersister val$superPersister;
                {
                    this.val$superPersister = simpleRelationalEntityPersister;
                }

                public void afterUpdateById(Iterable<? extends C> entities) {
                    this.val$superPersister.updateById(entities);
                }
            });
        });
        List copy = Iterables.copy((Iterable)superPersistersWithChangingTable);
        Collections.reverse(copy);
        copy.forEach(superPersister -> {
            persisterListener.addDeleteListener(new AfterDeleteSupport(superPersister::delete, Function.identity()));
            persisterListener.addDeleteByIdListener(new AfterDeleteByIdSupport(superPersister::deleteById, Function.identity()));
        });
    }

    void mapEntityConfigurationToTable() {
        this.visitInheritedEntityMappingConfigurations(new Consumer<EntityMappingConfiguration>(){
            private Table currentTable;
            {
                this.currentTable = PersisterBuilderImpl.this.table;
            }

            @Override
            public void accept(EntityMappingConfiguration entityMappingConfiguration) {
                EntityMappingConfiguration.InheritanceConfiguration inheritanceConfiguration = entityMappingConfiguration.getInheritanceConfiguration();
                boolean changeTable = (Boolean)Nullable.nullable(inheritanceConfiguration).map(EntityMappingConfiguration.InheritanceConfiguration::isJoinTable).getOr((Object)false);
                PersisterBuilderImpl.this.tableMap.put(entityMappingConfiguration, this.currentTable);
                if (changeTable) {
                    this.currentTable = (Table)Nullable.nullable((Object)inheritanceConfiguration.getTable()).getOr(() -> new Table(PersisterBuilderImpl.this.namingConfiguration.getTableNamingStrategy().giveName(inheritanceConfiguration.getConfiguration().getEntityType())));
                }
            }
        });
    }

    @VisibleForTesting
    <T extends Table> void init(ColumnBinderRegistry columnBinderRegistry, @javax.annotation.Nullable T table) {
        this.columnBinderRegistry = columnBinderRegistry;
        this.table = (Table)Nullable.nullable(table).elseSet((Object)this.entityMappingConfiguration.getTable()).getOr(() -> new Table(this.namingConfiguration.getTableNamingStrategy().giveName(this.entityMappingConfiguration.getEntityType())));
    }

    public static <C, I> void addIdentificationToMapping(AbstractIdentification<C, I> identification, Iterable<MappingPerTable.Mapping<C, ?>> mappings) {
        mappings.forEach(mapping -> mapping.registerIdentifier(identification.getIdAccessor()));
    }

    public static void propagatePrimaryKey(PrimaryKey<?, ?> primaryKey, Set<Table> tables) {
        Hanger.Holder previousPk = new Hanger.Holder(primaryKey);
        tables.forEach(t -> {
            ((PrimaryKey)previousPk.get()).getColumns().forEach(pkColumn -> {
                Column newColumn = t.addColumn(pkColumn.getName(), pkColumn.getJavaType());
                newColumn.setNullable(false);
                newColumn.primaryKey();
            });
            previousPk.set((Object)t.getPrimaryKey());
        });
    }

    public static void applyForeignKeys(PrimaryKey primaryKey, ForeignKeyNamingStrategy foreignKeyNamingStrategy, Set<Table> tables) {
        Hanger.Holder previousPk = new Hanger.Holder((Object)primaryKey);
        tables.forEach(t -> {
            PrimaryKey currentPrimaryKey = t.getPrimaryKey();
            t.addForeignKey(foreignKeyNamingStrategy.giveName(currentPrimaryKey, (Key)previousPk.get()), (Key)currentPrimaryKey, (Key)previousPk.get());
            previousPk.set((Object)currentPrimaryKey);
        });
    }

    @VisibleForTesting
    <T extends Table<T>> PrimaryKey<T, I> addIdentifyingPrimarykey(AbstractIdentification<C, I> identification) {
        Table pkTable = this.tableMap.get(identification.getIdentificationDefiner());
        EntityMappingConfiguration.KeyMapping<C, I> keyLinkage = identification.getKeyLinkage();
        AccessorDefinition identifierDefinition = AccessorDefinition.giveDefinition(identification.getIdAccessor());
        if (identification instanceof AbstractIdentification.CompositeKeyIdentification) {
            CompositeKeyMappingConfiguration configuration = ((FluentEntityMappingConfigurationSupport.CompositeKeyLinkageSupport)keyLinkage).getCompositeKeyMappingBuilder().getConfiguration();
            BeanMappingBuilder compositeKeyBuilder = new BeanMappingBuilder(configuration, pkTable, this.columnBinderRegistry, this.namingConfiguration.getColumnNamingStrategy());
            BeanMappingBuilder.BeanMapping build = compositeKeyBuilder.build();
            Map compositeKeyMapping = build.getMapping();
            compositeKeyMapping.values().forEach(Column::primaryKey);
            ((AbstractIdentification.CompositeKeyIdentification)identification).setCompositeKeyMapping(compositeKeyMapping);
        } else {
            String columnName = (String)Nullable.nullable((Object)((EntityMappingConfiguration.SingleKeyMapping)keyLinkage).getColumnOptions()).map(EntityMappingConfiguration.ColumnLinkageOptions::getColumnName).get();
            if (columnName == null) {
                columnName = this.namingConfiguration.getColumnNamingStrategy().giveName(identifierDefinition);
            }
            Column primaryKey = pkTable.addColumn(columnName, identifierDefinition.getMemberType());
            primaryKey.setNullable(false);
            primaryKey.primaryKey();
            if (((AbstractIdentification.Identification)identification).getIdentifierPolicy() instanceof ColumnOptions.AfterInsertIdentifierPolicy) {
                primaryKey.autoGenerated();
            }
        }
        return pkTable.getPrimaryKey();
    }

    @VisibleForTesting
    void applyForeignKeys(PrimaryKey primaryKey, Set<Table> tables) {
        PersisterBuilderImpl.applyForeignKeys(primaryKey, this.namingConfiguration.getForeignKeyNamingStrategy(), tables);
    }

    @VisibleForTesting
    MappingPerTable<C> collectPropertiesMappingFromInheritance() {
        final MappingPerTable result = new MappingPerTable();
        class MappingCollector<T extends Table<T>>
        implements Consumer<EmbeddableMappingConfiguration<C>> {
            private T currentTable;
            private Map<ReversibleAccessor<C, Object>, Column<T, Object>> currentColumnMap = new HashMap();
            private Map<ReversibleAccessor<C, Object>, Column<T, Object>> currentReadonlyColumnMap = new HashMap();
            private final ValueAccessPointMap<C, Converter<Object, Object>> readConverters = new ValueAccessPointMap();
            private final ValueAccessPointMap<C, Converter<Object, Object>> writeConverters = new ValueAccessPointMap();
            private MappingPerTable.Mapping<C, T> currentMapping;
            private Object currentKey;
            private boolean mappedSuperClass = false;

            MappingCollector() {
            }

            @Override
            public void accept(EmbeddableMappingConfiguration<C> embeddableMappingConfiguration) {
                BeanMappingBuilder beanMappingBuilder = new BeanMappingBuilder(embeddableMappingConfiguration, this.currentTable, PersisterBuilderImpl.this.columnBinderRegistry, PersisterBuilderImpl.this.namingConfiguration.getColumnNamingStrategy());
                BeanMappingBuilder.BeanMapping propertiesMapping = beanMappingBuilder.build();
                ValueAccessPointSet localMapping = new ValueAccessPointSet(this.currentColumnMap.keySet());
                propertiesMapping.getMapping().keySet().forEach(propertyAccessor -> {
                    if (localMapping.contains(propertyAccessor)) {
                        throw new MappingConfigurationException(AccessorDefinition.toString((ValueAccessPoint)propertyAccessor) + " is mapped twice");
                    }
                });
                propertiesMapping.getReadonlyMapping().keySet().forEach(propertyAccessor -> {
                    if (localMapping.contains(propertyAccessor)) {
                        throw new MappingConfigurationException(AccessorDefinition.toString((ValueAccessPoint)propertyAccessor) + " is mapped twice");
                    }
                });
                this.currentColumnMap.putAll(propertiesMapping.getMapping());
                this.currentReadonlyColumnMap.putAll(propertiesMapping.getReadonlyMapping());
                this.readConverters.putAll(propertiesMapping.getReadConverters());
                this.writeConverters.putAll(propertiesMapping.getWriteConverters());
                if (this.currentMapping == null) {
                    this.currentMapping = result.add(Objects.preventNull((Object)this.currentKey, embeddableMappingConfiguration), this.currentTable, this.currentColumnMap, this.currentReadonlyColumnMap, new ValueAccessPointMap(this.readConverters), new ValueAccessPointMap(this.writeConverters), this.mappedSuperClass);
                } else {
                    this.currentMapping = result.add(embeddableMappingConfiguration, this.currentTable, this.currentColumnMap, this.currentReadonlyColumnMap, new ValueAccessPointMap(this.readConverters), new ValueAccessPointMap(this.writeConverters), this.mappedSuperClass);
                    this.currentMapping.getMapping().putAll(this.currentColumnMap);
                }
                embeddableMappingConfiguration.getPropertiesMapping().stream().filter(EmbeddableMappingConfiguration.Linkage::isSetByConstructor).map(EmbeddableMappingConfiguration.Linkage::getAccessor).forEach(arg_0 -> this.currentMapping.propertiesSetByConstructor.add(arg_0));
            }

            @Override
            public void accept(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
                this.accept(entityMappingConfiguration.getPropertiesMapping());
            }
        }
        final MappingCollector mappingCollector = new MappingCollector();
        this.visitInheritedEmbeddableMappingConfigurations(new Consumer<EntityMappingConfiguration>(){
            private boolean initMapping = false;
            {
            }

            @Override
            public void accept(EntityMappingConfiguration entityMappingConfiguration) {
                mappingCollector.currentKey = entityMappingConfiguration;
                if (this.initMapping) {
                    mappingCollector.currentColumnMap = new HashMap();
                    mappingCollector.currentReadonlyColumnMap = new HashMap();
                    mappingCollector.readConverters.clear();
                    mappingCollector.writeConverters.clear();
                    mappingCollector.currentMapping = null;
                }
                mappingCollector.currentTable = (Table)PersisterBuilderImpl.this.tableMap.get(entityMappingConfiguration);
                mappingCollector.accept(entityMappingConfiguration);
                this.initMapping = (Boolean)Nullable.nullable(entityMappingConfiguration.getInheritanceConfiguration()).map(EntityMappingConfiguration.InheritanceConfiguration::isJoinTable).getOr((Object)false);
            }
        }, embeddableMappingConfiguration -> {
            mappingCollector.mappedSuperClass = true;
            mappingCollector.accept(embeddableMappingConfiguration);
        });
        return result;
    }

    void visitInheritedEmbeddableMappingConfigurations(Consumer<EntityMappingConfiguration> entityConfigurationConsumer, Consumer<EmbeddableMappingConfiguration> mappedSuperClassConfigurationConsumer) {
        Hanger.Holder lastMapping = new Hanger.Holder();
        this.visitInheritedEntityMappingConfigurations(entityMappingConfiguration -> {
            entityConfigurationConsumer.accept((EntityMappingConfiguration)entityMappingConfiguration);
            lastMapping.set(entityMappingConfiguration);
        });
        if (((EntityMappingConfiguration)lastMapping.get()).getPropertiesMapping().getMappedSuperClassConfiguration() != null) {
            ((EntityMappingConfiguration)lastMapping.get()).getPropertiesMapping().getMappedSuperClassConfiguration().inheritanceIterable().forEach(mappedSuperClassConfigurationConsumer);
        }
    }

    void visitInheritedEntityMappingConfigurations(Consumer<EntityMappingConfiguration> configurationConsumer) {
        this.entityMappingConfiguration.inheritanceIterable().forEach(configurationConsumer);
    }

    private AbstractIdentification<C, I> determineIdentification() {
        if (this.entityMappingConfiguration.getInheritanceConfiguration() != null && this.entityMappingConfiguration.getPropertiesMapping().getMappedSuperClassConfiguration() != null) {
            throw new MappingConfigurationException("Combination of mapped super class and inheritance is not supported, please remove one of them");
        }
        if (this.entityMappingConfiguration.getKeyMapping() != null && this.entityMappingConfiguration.getInheritanceConfiguration() != null) {
            throw new MappingConfigurationException("Defining an identifier in conjunction with entity inheritance is not supported : " + Reflections.toString(this.entityMappingConfiguration.getEntityType()) + " defines identifier " + AccessorDefinition.toString(this.entityMappingConfiguration.getKeyMapping().getAccessor()) + " while it inherits from " + Reflections.toString(this.entityMappingConfiguration.getInheritanceConfiguration().getConfiguration().getEntityType()));
        }
        Hanger.Holder configurationDefiningIdentification = new Hanger.Holder();
        this.visitInheritedEntityMappingConfigurations(entityConfiguration -> {
            EntityMappingConfiguration.KeyMapping keyMapping = entityConfiguration.getKeyMapping();
            if (keyMapping != null && keyMapping instanceof EntityMappingConfiguration.SingleKeyMapping && ((EntityMappingConfiguration.SingleKeyMapping)keyMapping).getIdentifierPolicy() != null || keyMapping instanceof EntityMappingConfiguration.CompositeKeyMapping) {
                if (configurationDefiningIdentification.get() != null) {
                    throw new UnsupportedOperationException("Identifier policy is defined twice in hierarchy : first by " + Reflections.toString(((EntityMappingConfiguration)configurationDefiningIdentification.get()).getEntityType()) + ", then by " + Reflections.toString(entityConfiguration.getEntityType()));
                }
                configurationDefiningIdentification.set(entityConfiguration);
            }
        });
        EntityMappingConfiguration foundConfiguration = (EntityMappingConfiguration)configurationDefiningIdentification.get();
        if (foundConfiguration == null) {
            throw this.newMissingIdentificationException();
        }
        EntityMappingConfiguration.KeyMapping foundKeyMapping = foundConfiguration.getKeyMapping();
        if (foundKeyMapping instanceof EntityMappingConfiguration.SingleKeyMapping) {
            return AbstractIdentification.forSingleKey(foundConfiguration);
        }
        if (foundKeyMapping instanceof EntityMappingConfiguration.CompositeKeyMapping) {
            PersisterBuilderImpl.assertCompositeKeyIdentifierOverridesEqualsHashcode((EntityMappingConfiguration.CompositeKeyMapping)foundKeyMapping);
            return AbstractIdentification.forCompositeKey(foundConfiguration);
        }
        throw new MappingConfigurationException("Unknown key mapping : " + foundKeyMapping);
    }

    @VisibleForTesting
    static void assertCompositeKeyIdentifierOverridesEqualsHashcode(EntityMappingConfiguration.CompositeKeyMapping<?, ?> compositeKeyIdentification) {
        Class compositeKeyType = AccessorDefinition.giveDefinition(compositeKeyIdentification.getAccessor()).getMemberType();
        try {
            compositeKeyType.getDeclaredMethod("equals", Object.class);
            compositeKeyType.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MappingConfigurationException("Composite key identifier class " + Reflections.toString((Class)compositeKeyType) + " seems to have default implementation of equals() and hashcode() methods, which is not supported (identifiers must be distinguishable), please make it implement them");
        }
    }

    private <E> void determineIdentifierManager(AbstractIdentification<E, I> identification, MappingPerTable<E> mappingPerTable, ReversibleAccessor<E, I> idAccessor, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        AccessorDefinition idDefinition = AccessorDefinition.giveDefinition(idAccessor);
        Class identifierType = idDefinition.getMemberType();
        if (identification instanceof AbstractIdentification.CompositeKeyIdentification) {
            CompositeKeyAlreadyAssignedIdentifierInsertionManager compositeKeyInsertionManager = new CompositeKeyAlreadyAssignedIdentifierInsertionManager(identifierType);
            identification.setInsertionManager((IdentifierInsertionManager<E, I>)compositeKeyInsertionManager).setFallbackInsertionManager(new AlreadyAssignedIdentifierManager(identifierType, compositeKeyInsertionManager.getMarkAsPersistedFunction(), compositeKeyInsertionManager.getIsPersistedFunction()));
        } else {
            AlreadyAssignedIdentifierManager fallbackMappingIdentifierManager;
            AlreadyAssignedIdentifierManager identifierInsertionManager = null;
            ColumnOptions.IdentifierPolicy identifierPolicy = ((AbstractIdentification.Identification)identification).getIdentifierPolicy();
            if (identifierPolicy instanceof ColumnOptions.AfterInsertIdentifierPolicy) {
                Table targetTable = ((MappingPerTable.Mapping)Iterables.first(mappingPerTable.getMappings())).targetTable;
                if (targetTable.getPrimaryKey().isComposed()) {
                    throw new UnsupportedOperationException("Composite primary key is not compatible with database-generated column");
                }
                Column primaryKey = (Column)Iterables.first((Iterable)targetTable.getPrimaryKey().getColumns());
                identifierInsertionManager = new JDBCGeneratedKeysIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor(idAccessor), dialect.buildGeneratedKeysReader(primaryKey.getName(), primaryKey.getJavaType()), primaryKey.getJavaType());
            } else if (identifierPolicy instanceof ColumnOptions.BeforeInsertIdentifierPolicy) {
                Sequence sequence = ((ColumnOptions.BeforeInsertIdentifierPolicy)identifierPolicy).getIdentifierProvider(identification.getIdentificationDefiner().getEntityType(), connectionConfiguration, dialect);
                identifierInsertionManager = new BeforeInsertIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor(idAccessor), sequence, identifierType);
            } else if (identifierPolicy instanceof ColumnOptions.AlreadyAssignedIdentifierPolicy) {
                ColumnOptions.AlreadyAssignedIdentifierPolicy alreadyAssignedPolicy = (ColumnOptions.AlreadyAssignedIdentifierPolicy)identifierPolicy;
                identifierInsertionManager = new AlreadyAssignedIdentifierManager(identifierType, alreadyAssignedPolicy.getMarkAsPersistedFunction(), alreadyAssignedPolicy.getIsPersistedFunction());
            }
            if (identifierPolicy instanceof ColumnOptions.AlreadyAssignedIdentifierPolicy) {
                fallbackMappingIdentifierManager = new AlreadyAssignedIdentifierManager(identifierType, ((ColumnOptions.AlreadyAssignedIdentifierPolicy)identifierPolicy).getMarkAsPersistedFunction(), ((ColumnOptions.AlreadyAssignedIdentifierPolicy)identifierPolicy).getIsPersistedFunction());
            } else {
                Function<Object, Boolean> isPersistedFunction = !identifierType.isPrimitive() ? c -> idAccessor.get(c) != null : c -> Reflections.PRIMITIVE_DEFAULT_VALUES.get(identifierType) == idAccessor.get(c);
                fallbackMappingIdentifierManager = new AlreadyAssignedIdentifierManager(identifierType, c -> {}, isPersistedFunction);
            }
            identification.setInsertionManager((IdentifierInsertionManager<E, I>)identifierInsertionManager).setFallbackInsertionManager(fallbackMappingIdentifierManager);
        }
    }

    private UnsupportedOperationException newMissingIdentificationException() {
        SerializableTriFunction & Serializable identifierMethodReference = FluentEntityMappingBuilder::mapKey;
        Method identifierSetter = this.methodSpy.findMethod((SerializableTriFunction)identifierMethodReference);
        return new UnsupportedOperationException("Identifier is not defined for " + Reflections.toString(this.entityMappingConfiguration.getEntityType()) + ", please add one through " + Reflections.toString((Method)identifierSetter));
    }

    public static <E, I, T extends Table<T>> ClassMapping<E, I, T> createClassMappingStrategy(boolean isIdentifyingConfiguration, final T targetTable, Map<? extends ReversibleAccessor<E, Object>, ? extends Column<T, Object>> mapping, Map<? extends ReversibleAccessor<E, Object>, ? extends Column<T, Object>> readOnlyMapping, ValueAccessPointMap<E, ? extends Converter<Object, Object>> readConverters, ValueAccessPointMap<E, ? extends Converter<Object, Object>> writeConverters, ValueAccessPointSet<E> propertiesSetByConstructor, final AbstractIdentification<E, I> identification, Class<E> beanType, @javax.annotation.Nullable EntityMappingConfiguration.EntityFactoryProvider<E, T> entityFactoryProvider) {
        Function<Function<Object, Object>, Object> beanFactory;
        SimpleIdMapping idMappingStrategy;
        IdentifierInsertionManager<E, I> identifierInsertionManager;
        PrimaryKey primaryKey = targetTable.getPrimaryKey();
        ReversibleAccessor<E, I> idAccessor = identification.getIdAccessor();
        final AccessorDefinition idDefinition = AccessorDefinition.giveDefinition(idAccessor);
        Object object = identifierInsertionManager = isIdentifyingConfiguration ? identification.getInsertionManager() : identification.getFallbackInsertionManager();
        if (identification instanceof AbstractIdentification.CompositeKeyIdentification) {
            final Map composedKeyMapping = ((AbstractIdentification.CompositeKeyIdentification)identification).getCompositeKeyMapping();
            final Class keyType = idDefinition.getMemberType();
            final Constructor defaultConstructor = Reflections.findConstructor((Class)keyType, (Class[])new Class[0]);
            ComposedIdentifierAssembler composedIdentifierAssembler = new ComposedIdentifierAssembler<I, T>(targetTable){

                public Map<Column<T, Object>, Object> getColumnValues(I id) {
                    HashMap result = new HashMap();
                    composedKeyMapping.forEach((propertyAccessor, column) -> {
                        column = targetTable.getColumn(column.getName());
                        result.put((Column)column, id == null ? null : propertyAccessor.get(id));
                    });
                    return result;
                }

                @javax.annotation.Nullable
                public I assemble(Function<Column<?, ?>, Object> columnValueProvider) {
                    Function<Function, Object> keyFactory = defaultConstructor == null ? keyValueProvider -> {
                        throw new MappingConfigurationException("Key class " + Reflections.toString((Class)keyType) + " doesn't have a compatible accessible constructor, please implement a no-arg constructor or " + Reflections.toString((Class)idDefinition.getMemberType()) + "-arg constructor");
                    } : keyValueProvider -> Reflections.newInstance((Constructor)defaultConstructor, (Object[])new Object[0]);
                    Object result = keyFactory.apply(columnValueProvider::apply);
                    ((AbstractIdentification.CompositeKeyIdentification)identification).getCompositeKeyMapping().forEach((setter, col) -> setter.toMutator().set(result, columnValueProvider.apply((Column<?, ?>)col)));
                    return result;
                }
            };
            idMappingStrategy = new ComposedIdMapping(idAccessor, identifierInsertionManager, composedIdentifierAssembler);
        } else {
            idMappingStrategy = new SimpleIdMapping(idAccessor, identifierInsertionManager, new SimpleIdentifierAssembler((Column)Iterables.first((Iterable)primaryKey.getColumns())));
        }
        boolean identifierSetByBeanFactory = true;
        if (entityFactoryProvider == null) {
            Constructor constructorById = Reflections.findConstructor(beanType, (Class[])new Class[]{idDefinition.getMemberType()});
            if (constructorById == null) {
                Constructor defaultConstructor = Reflections.findConstructor(beanType, (Class[])new Class[0]);
                if (defaultConstructor == null) {
                    beanFactory = columnValueProvider -> {
                        throw new MappingConfigurationException("Entity class " + Reflections.toString((Class)beanType) + " doesn't have a compatible accessible constructor, please implement a no-arg constructor or " + Reflections.toString((Class)idDefinition.getMemberType()) + "-arg constructor");
                    };
                } else {
                    beanFactory = columnValueProvider -> Reflections.newInstance((Constructor)defaultConstructor, (Object[])new Object[0]);
                    identifierSetByBeanFactory = false;
                }
            } else {
                IdentifierAssembler identifierAssembler = idMappingStrategy.getIdentifierAssembler();
                beanFactory = columnValueProvider -> Reflections.newInstance((Constructor)constructorById, (Object[])new Object[]{identifierAssembler.assemble(columnValueProvider)});
            }
        } else {
            beanFactory = entityFactoryProvider.giveEntityFactory(targetTable);
            identifierSetByBeanFactory = entityFactoryProvider.isIdentifierSetByFactory();
        }
        ClassMapping result = new ClassMapping(beanType, targetTable, mapping, readOnlyMapping, (IdMapping)idMappingStrategy, beanFactory, identifierSetByBeanFactory);
        result.getMainMapping().setReadConverters(readConverters);
        result.getMainMapping().setWriteConverters(writeConverters);
        propertiesSetByConstructor.forEach(arg_0 -> ((ClassMapping)result).addPropertySetByConstructor(arg_0));
        return result;
    }

    public static class MappingPerTable<C> {
        private final KeepOrderSet<Mapping<C, ?>> mappings = new KeepOrderSet();

        <T extends Table<T>> Mapping<C, T> add(Object mappingConfiguration, T table, Map<ReversibleAccessor<C, Object>, Column<T, Object>> mapping, Map<ReversibleAccessor<C, Object>, Column<T, Object>> readonlyMapping, ValueAccessPointMap<C, ? extends Converter<Object, Object>> readConverters, ValueAccessPointMap<C, ? extends Converter<Object, Object>> writeConverters, boolean mappedSuperClass) {
            Mapping<C, T> newMapping = new Mapping<C, T>(mappingConfiguration, table, mapping, readonlyMapping, readConverters, writeConverters, mappedSuperClass);
            this.mappings.add(newMapping);
            return newMapping;
        }

        <T extends Table<T>> Map<ReversibleAccessor<C, Object>, Column<T, Object>> giveMapping(T table) {
            Mapping foundMapping = (Mapping)Iterables.find(this.mappings, m -> ((Mapping)m).getTargetTable().equals((Object)table));
            if (foundMapping == null) {
                throw new IllegalArgumentException("Can't find table '" + table.getAbsoluteName() + "' in " + Iterables.collectToList(this.mappings, (Function)Functions.chain(rec$ -> ((Mapping)rec$).getTargetTable(), Table::getAbsoluteName)).toString());
            }
            return foundMapping.mapping;
        }

        KeepOrderSet<Table> giveTables() {
            return (KeepOrderSet)Iterables.collect(this.mappings, rec$ -> ((Mapping)rec$).getTargetTable(), KeepOrderSet::new);
        }

        public KeepOrderSet<Mapping<C, ?>> getMappings() {
            return this.mappings;
        }

        public static class Mapping<C, T extends Table<T>> {
            private final Object mappingConfiguration;
            private final T targetTable;
            private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mapping;
            private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> readonlyMapping;
            private final ValueAccessPointSet<C> propertiesSetByConstructor = new ValueAccessPointSet();
            private final boolean mappedSuperClass;
            private Duo<ReversibleAccessor<C, ?>, PrimaryKey<T, ?>> identifier;
            private final ValueAccessPointMap<C, Converter<Object, Object>> readConverters;
            private final ValueAccessPointMap<C, Converter<Object, Object>> writeConverters;

            public Mapping(Object mappingConfiguration, T targetTable, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> mapping, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> readonlyMapping, ValueAccessPointMap<C, ? extends Converter<Object, Object>> readConverters, ValueAccessPointMap<C, ? extends Converter<Object, Object>> writeConverters, boolean mappedSuperClass) {
                this.mappingConfiguration = mappingConfiguration;
                this.targetTable = targetTable;
                this.mapping = mapping;
                this.readonlyMapping = readonlyMapping;
                this.readConverters = readConverters;
                this.writeConverters = writeConverters;
                this.mappedSuperClass = mappedSuperClass;
            }

            public Object getMappingConfiguration() {
                return this.mappingConfiguration;
            }

            public boolean isMappedSuperClass() {
                return this.mappedSuperClass;
            }

            public EmbeddableMappingConfiguration<C> giveEmbeddableConfiguration() {
                return this.mappingConfiguration instanceof EmbeddableMappingConfiguration ? this.mappingConfiguration : (this.mappingConfiguration instanceof EntityMappingConfiguration ? ((EntityMappingConfiguration)this.mappingConfiguration).getPropertiesMapping() : null);
            }

            private T getTargetTable() {
                return this.targetTable;
            }

            public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getMapping() {
                return this.mapping;
            }

            public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getReadonlyMapping() {
                return this.readonlyMapping;
            }

            public ValueAccessPointMap<C, Converter<Object, Object>> getReadConverters() {
                return this.readConverters;
            }

            public ValueAccessPointMap<C, Converter<Object, Object>> getWriteConverters() {
                return this.writeConverters;
            }

            void registerIdentifier(ReversibleAccessor<C, ?> identifierAccessor) {
                this.identifier = new Duo(identifierAccessor, (Object)this.getTargetTable().getPrimaryKey());
            }

            public Duo<ReversibleAccessor<C, ?>, PrimaryKey<T, ?>> getIdentifier() {
                return this.identifier;
            }
        }
    }

    public static abstract class PostInitializer<P>
    implements BuildLifeCycleListener {
        private final Class<P> entityType;

        protected PostInitializer(Class<P> entityType) {
            this.entityType = entityType;
        }

        public Class<P> getEntityType() {
            return this.entityType;
        }

        @Override
        public final void afterBuild() {
            try {
                this.consume((ConfiguredRelationalPersister)PersisterBuilderContext.CURRENT.get().getPersisterRegistry().getPersister(this.entityType));
            }
            catch (RuntimeException e) {
                throw new MappingConfigurationException("Error while post processing persister of type " + Reflections.toString(this.entityType), e);
            }
        }

        @Override
        public final void afterAllBuild() {
        }

        public abstract void consume(ConfiguredRelationalPersister<P, ?> var1);
    }

    public static interface BuildLifeCycleListener {
        public void afterBuild();

        public void afterAllBuild();
    }
}

