/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.JoinableSelectExecutor;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;

public class SingleTablePolymorphismSelectExecutor<C, I, T extends Table<T>, DTYPE>
implements SelectExecutor<C, I>,
JoinableSelectExecutor {
    private final ConfiguredRelationalPersister<C, I> mainPersister;
    private final Map<Class<C>, ConfiguredRelationalPersister<C, I>> subEntitiesPersisters;
    private final Column discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism polymorphismPolicy;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;

    public SingleTablePolymorphismSelectExecutor(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism polymorphismPolicy, ConnectionProvider connectionProvider, Dialect dialect) {
        this.mainPersister = mainPersister;
        this.polymorphismPolicy = polymorphismPolicy;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.discriminatorColumn = discriminatorColumn;
        this.subEntitiesPersisters = subEntitiesPersisters;
    }

    public Set<C> select(Iterable<I> ids) {
        PrimaryKey primaryKey = this.mainPersister.getMainTable().getPrimaryKey();
        if (primaryKey.isComposed() && !this.dialect.supportsTupleCondition()) {
            throw new UnsupportedOperationException("Database doesn't support tuple-in so selection can't be done trivially, not yet supported");
        }
        Query.FluentFromClause from = ((Query.FluentSelectClause)QueryEase.select((Map)Iterables.map((Iterable)primaryKey.getColumns(), Function.identity(), Column::getAlias)).add((Selectable)this.discriminatorColumn, this.discriminatorColumn.getAlias())).from((Fromable)this.mainPersister.getMainTable());
        if (!primaryKey.isComposed()) {
            from.where((Column)Iterables.first((Iterable)primaryKey.getColumns()), (ConditionalOperator)Operators.in(ids));
        } else {
            List idsAsList = Collections.asList(ids);
            Map columnValues = this.mainPersister.getMapping().getIdMapping().getIdentifierAssembler().getColumnValues(idsAsList);
            from.where(new Object[]{this.transformCompositeIdentifierColumnValuesToTupleInValues(idsAsList.size(), columnValues)});
        }
        Query query = (Query)from.getQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query);
        ColumnBinderRegistry columnBinderRegistry = this.dialect.getColumnBinderRegistry();
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        Map aliases = query.getSelectSurrogate().getAliases();
        KeepOrderMap idsPerSubclass = new KeepOrderMap(this.polymorphismPolicy.getSubClasses().size());
        try (ReadOperation readOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            HashMap readers = new HashMap();
            aliases.forEach((c, as) -> {
                ParameterBinder reader = c instanceof Column ? columnBinderRegistry.getBinder((Object)((Column)c)) : columnBinderRegistry.getBinder(c.getJavaType());
                readers.put(as, reader);
            });
            RowIterator resultSetIterator = new RowIterator(resultSet, readers);
            ColumnedRow columnedRow = new ColumnedRow(aliases::get);
            resultSetIterator.forEachRemaining(arg_0 -> this.lambda$select$2(columnedRow, (Map)idsPerSubclass, arg_0));
        }
        HashSet result = new HashSet();
        idsPerSubclass.forEach((subclass, subclassIds) -> result.addAll(this.subEntitiesPersisters.get(subclass).select((Iterable)subclassIds)));
        return result;
    }

    @Override
    public <U, T1 extends Table<T1>, T2 extends Table<T2>, ID> String addRelation(String leftStrategyName, EntityMapping<U, ID, T2> strategy, BeanRelationFixer beanRelationFixer, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn, boolean isOuterJoin) {
        HashSet joinNames = new HashSet();
        this.subEntitiesPersisters.forEach((entityClass, persister) -> {
            String joinName = persister.getEntityJoinTree().addRelationJoin(leftStrategyName, new EntityInflater.EntityMappingAdapter(strategy), leftJoinColumn, rightJoinColumn, null, isOuterJoin ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, beanRelationFixer, java.util.Collections.emptySet());
            joinNames.add(joinName);
        });
        if (joinNames.size() == 1) {
            return (String)Iterables.first(joinNames);
        }
        throw new IllegalStateException("Different names for same join is not expected");
    }

    @Override
    public <U, T1 extends Table<T1>, T2 extends Table<T2>, ID> String addMergeJoin(String leftStrategyName, EntityMapping<U, ID, T2> strategy, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn) {
        HashSet joinNames = new HashSet();
        this.subEntitiesPersisters.forEach((entityClass, persister) -> {
            String joinName = persister.getEntityJoinTree().addMergeJoin(leftStrategyName, new EntityMerger.EntityMergerAdapter(strategy), leftJoinColumn, rightJoinColumn);
            joinNames.add(joinName);
        });
        if (joinNames.size() == 1) {
            return (String)Iterables.first(joinNames);
        }
        throw new IllegalStateException("Different names for same join is not expected");
    }

    @VisibleForTesting
    TupleIn transformCompositeIdentifierColumnValuesToTupleInValues(int idsCount, Map<? extends Column<T, Object>, Object> values) {
        ArrayList<Object[]> resultValues = new ArrayList<Object[]>(idsCount);
        Column[] columns = new ArrayList<Column<Column, Object>>(values.keySet()).toArray(new Column[0]);
        for (int i = 0; i < idsCount; ++i) {
            ArrayList<Object> beanValues = new ArrayList<Object>(columns.length);
            for (Column column : columns) {
                Object value = values.get(column);
                if (value instanceof List) {
                    beanValues.add(((List)value).get(i));
                    continue;
                }
                beanValues.add(value);
            }
            resultValues.add(beanValues.toArray());
        }
        return new TupleIn(columns, resultValues);
    }

    private /* synthetic */ void lambda$select$2(ColumnedRow columnedRow, Map idsPerSubclass, Row row) {
        Object dtype = columnedRow.getValue((Selectable)this.discriminatorColumn, row);
        Class entitySubclass = this.polymorphismPolicy.getClass(dtype);
        Object id = this.subEntitiesPersisters.get(entitySubclass).getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
        if (id != null) {
            idsPerSubclass.computeIfAbsent(entitySubclass, k -> new HashSet()).add(id);
        }
    }
}

