/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.PreparedSQLAppender;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Insert;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.trace.ModifiableInt;

public class InsertCommandBuilder<T extends Table<T>>
implements SQLBuilder {
    private final Insert<T> insert;

    public InsertCommandBuilder(Insert<T> insert) {
        this.insert = insert;
    }

    @Override
    public String toSQL() {
        return this.toSQL(new StringSQLAppender(new StringAppender(), new DMLNameProvider(new HashMap())){

            @Override
            public <V> StringSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
                if (value == Update.UpdateColumn.PLACEHOLDER) {
                    return this.cat("?", new String[0]);
                }
                return super.catValue((Selectable)column, value);
            }

            @Override
            public StringSQLAppender catValue(Object value) {
                if (value == Update.UpdateColumn.PLACEHOLDER) {
                    return this.cat("?", new String[0]);
                }
                return super.catValue(value);
            }
        });
    }

    private String toSQL(SQLAppender result) {
        result.cat("insert into ", new String[0]).cat(((Table)this.insert.getTargetTable()).getAbsoluteName(), new String[0]).cat("(", new String[0]);
        Iterator<Update.UpdateColumn<T>> columnIterator = this.insert.getColumns().iterator();
        while (columnIterator.hasNext()) {
            Update.UpdateColumn<T> c = columnIterator.next();
            result.cat(c.getColumn().getName(), new String[0]);
            if (!columnIterator.hasNext()) continue;
            result.catIf(columnIterator.hasNext(), ", ");
        }
        result.cat(") values (", new String[0]);
        Iterator<Update.UpdateColumn<T>> columnIterator2 = this.insert.getColumns().iterator();
        while (columnIterator2.hasNext()) {
            Update.UpdateColumn<T> c = columnIterator2.next();
            this.catUpdateObject(c, result);
            if (!columnIterator2.hasNext()) continue;
            result.catIf(columnIterator2.hasNext(), ", ");
        }
        result.cat(")", new String[0]);
        return result.getSQL();
    }

    protected void catUpdateObject(Update.UpdateColumn value, SQLAppender result) {
        result.catValue(value.getColumn(), value.getValue());
    }

    public InsertStatement<T> toStatement(ColumnBinderRegistry columnBinderRegistry) {
        DMLNameProvider dmlNameProvider = new DMLNameProvider(new HashMap());
        PreparedSQLAppender preparedSQLAppender = new PreparedSQLAppender(new StringSQLAppender(new StringAppender(), dmlNameProvider), columnBinderRegistry, dmlNameProvider);
        String sql = this.toSQL(preparedSQLAppender);
        HashMap<Integer, Object> values = new HashMap<Integer, Object>(preparedSQLAppender.getValues());
        HashMap<Integer, ParameterBinder> parameterBinders = new HashMap<Integer, ParameterBinder>(preparedSQLAppender.getParameterBinders());
        HashMap columnIndexes = new HashMap();
        ModifiableInt placeholderColumnCount = new ModifiableInt();
        this.insert.getColumns().forEach(c -> {
            if (!(c.getValue() instanceof Column)) {
                int index = placeholderColumnCount.increment();
                if (values.get(index).equals(Update.UpdateColumn.PLACEHOLDER)) {
                    values.remove(index);
                }
                columnIndexes.put(c.getColumn(), index);
            }
        });
        InsertStatement result = new InsertStatement(sql, parameterBinders, columnIndexes);
        result.setValues(values);
        return result;
    }

    public static class InsertStatement<T extends Table<T>>
    extends PreparedSQL {
        private final Map<? extends Column<T, Object>, Integer> columnIndexes;

        private InsertStatement(String sql, Map<Integer, ParameterBinder> parameterBinders, Map<? extends Column<T, Object>, Integer> columnIndexes) {
            super(sql, parameterBinders);
            this.columnIndexes = columnIndexes;
        }

        public <C> void setValue(Column<T, C> column, C value) {
            if (this.columnIndexes.get(column) == null) {
                throw new IllegalArgumentException("Column " + column.getAbsoluteName() + " is not insertable with fixed value in the insert clause");
            }
            this.setValue(this.columnIndexes.get(column), value);
        }
    }
}

