/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.stalactite.engine.DeleteExecutor;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.listener.PersisterListener;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Experimental;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.PairIterator;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public interface EntityPersister<C, I>
extends PersistExecutor<C>,
InsertExecutor<C>,
UpdateExecutor<C>,
SelectExecutor<C, I>,
DeleteExecutor<C, I>,
PersisterListener<C, I> {
    default public void persist(C entity) {
        this.persist((Iterable<? extends C>)Collections.singleton(entity));
    }

    @Override
    default public void persist(Iterable<? extends C> entities) {
        PersistExecutor.persist(entities, this::isNew, this, this, this, this::getId);
    }

    default public void insert(C entity) {
        this.insert((C)Collections.singletonList(entity));
    }

    default public void update(C modified, C unmodified, boolean allColumnsStatement) {
        this.update((C)Collections.singletonList(new Duo(modified, unmodified)), allColumnsStatement);
    }

    default public void update(C entity) {
        this.update(entity, true);
    }

    default public void update(C entity, boolean allColumnsStatement) {
        this.update(entity, this.select(this.getId(entity)), allColumnsStatement);
    }

    default public void update(Iterable<C> entities) {
        Set ids = (Set)Iterables.collect(entities, this::getId, KeepOrderSet::new);
        C entitiesFromDb = this.select((I)ids);
        Map idPerEntity = Iterables.map(entities, Function.identity(), this::getId, KeepOrderMap::new);
        Map entityFromDbPerId = Iterables.map(entitiesFromDb, this::getId, Function.identity());
        Map modifiedVsUnmodifiedEntities = Maps.innerJoinOnValuesAndKeys((Map)idPerEntity, (Map)entityFromDbPerId, KeepOrderMap::new);
        this.update((C)((Iterable)() -> new PairIterator(modifiedVsUnmodifiedEntities.keySet(), modifiedVsUnmodifiedEntities.values())), true);
    }

    @Experimental
    default public void update(I id, Consumer<C> entityConsumer) {
        this.update((Iterable<I>)Collections.singleton(id), entityConsumer);
    }

    @Experimental
    default public void update(Iterable<I> ids, Consumer<C> entityConsumer) {
        Object unmodified = this.select((I)ids);
        Object modified = this.select((I)ids);
        modified.forEach(entityConsumer);
        this.update((C)((Iterable)() -> new PairIterator((Iterable)modified, (Iterable)unmodified)), true);
    }

    default public void delete(C entity) {
        this.delete((C)Collections.singletonList(entity));
    }

    default public void deleteById(C entity) {
        this.deleteById((C)Collections.singletonList(entity));
    }

    default public C select(I id) {
        return (C)Iterables.first(this.select((I)Collections.singleton(id)));
    }

    default public <O> ExecutableEntityQuery<C, ?> selectWhere(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return (ExecutableEntityQuery)this.selectWhere().and(getter, operator);
    }

    default public <O> ExecutableEntityQuery<C, ?> selectWhere(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return (ExecutableEntityQuery)this.selectWhere().and(setter, operator);
    }

    default public <O, A> ExecutableEntityQuery<C, ?> selectWhere(SerializableFunction<C, A> getter1, SerializableFunction<A, O> getter2, ConditionalOperator<O, ?> operator) {
        return this.selectWhere(AccessorChain.chain(getter1, getter2), operator);
    }

    default public <O> ExecutableEntityQuery<C, ?> selectWhere(AccessorChain<C, O> accessorChain, ConditionalOperator<O, ?> operator) {
        return (ExecutableEntityQuery)this.selectWhere().and(accessorChain, operator);
    }

    public ExecutableEntityQuery<C, ?> selectWhere();

    default public <O> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter, SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return (ExecutableProjectionQuery)this.selectProjectionWhere(selectAdapter).and(getter, operator);
    }

    default public <O> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter, SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return (ExecutableProjectionQuery)this.selectProjectionWhere(selectAdapter).and(setter, operator);
    }

    default public <O, A> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter, SerializableFunction<C, A> getter1, SerializableFunction<A, O> getter2, ConditionalOperator<O, ?> operator) {
        return this.selectProjectionWhere(selectAdapter, AccessorChain.chain(getter1, getter2), operator);
    }

    default public <O> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter, AccessorChain<C, O> accessorChain, ConditionalOperator<O, ?> operator) {
        return (ExecutableProjectionQuery)this.selectProjectionWhere(selectAdapter).and(accessorChain, operator);
    }

    public ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> var1);

    public Set<C> selectAll();

    public boolean isNew(C var1);

    public I getId(C var1);

    public Class<C> getClassToPersist();

    public static interface FluentOrderByClause<C, SELF extends FluentOrderByClause<C, SELF>>
    extends OrderByChain<C, SELF>,
    LimitAware<SELF> {
    }

    public static interface LimitAware<R> {
        public R limit(int var1);

        public R limit(int var1, Integer var2);
    }

    public static interface OrderByChain<C, SELF extends OrderByChain<C, SELF>> {
        default public SELF orderBy(SerializableFunction<C, ?> getter) {
            return this.orderBy(getter, Order.ASC);
        }

        default public SELF orderBy(SerializableBiConsumer<C, ?> setter) {
            return this.orderBy(setter, Order.ASC);
        }

        default public SELF orderBy(AccessorChain<C, ?> getter) {
            return this.orderBy(getter, Order.ASC);
        }

        public SELF orderBy(SerializableFunction<C, ?> var1, Order var2);

        public SELF orderBy(SerializableBiConsumer<C, ?> var1, Order var2);

        public SELF orderBy(AccessorChain<C, ?> var1, Order var2);

        public static enum Order {
            ASC,
            DESC;

        }
    }

    public static interface EntityCriteria<C, SELF extends EntityCriteria<C, SELF>> {
        public <O> SELF and(SerializableFunction<C, O> var1, ConditionalOperator<O, ?> var2);

        public <O> SELF and(SerializableBiConsumer<C, O> var1, ConditionalOperator<O, ?> var2);

        public <O> SELF or(SerializableFunction<C, O> var1, ConditionalOperator<O, ?> var2);

        public <O> SELF or(SerializableBiConsumer<C, O> var1, ConditionalOperator<O, ?> var2);

        public EntityCriteria<C, SELF> beginNested();

        public EntityCriteria<C, SELF> endNested();

        public <A, B> SELF and(SerializableFunction<C, A> var1, SerializableFunction<A, B> var2, ConditionalOperator<B, ?> var3);

        public <O> SELF and(AccessorChain<C, O> var1, ConditionalOperator<O, ?> var2);

        public <O> SELF or(AccessorChain<C, O> var1, ConditionalOperator<O, ?> var2);
    }

    public static interface ExecutableProjectionQuery<C, SELF extends ExecutableProjectionQuery<C, SELF>>
    extends EntityCriteria<C, SELF>,
    ExecutableProjection,
    FluentOrderByClause<C, SELF> {
    }

    public static interface ExecutableEntityQuery<C, SELF extends ExecutableEntityQuery<C, SELF>>
    extends EntityCriteria<C, SELF>,
    ExecutableQuery<C>,
    FluentOrderByClause<C, SELF> {
        public SELF set(String var1, Object var2);
    }
}

