/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.InMemoryCounterIdentifierGenerator;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EmptySubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.runtime.JoinTablePolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.BeforeInsertIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Sequence;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.types.Type;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class JoinTablePolymorphismPersisterTest {
    private JoinTablePolymorphismPersister<AbstractToto, Identifier<Integer>> testInstance;
    private PreparedStatement preparedStatement;
    private ArgumentCaptor<Integer> valueCaptor;
    private ArgumentCaptor<Integer> indexCaptor;
    private ArgumentCaptor<String> statementArgCaptor;
    private InMemoryCounterIdentifierGenerator identifierGenerator;
    private ClassMapping<AbstractToto, Identifier<Integer>, ?> totoClassMapping;
    private Dialect dialect;
    private final EffectiveBatchedRowCount effectiveBatchedRowCount = new EffectiveBatchedRowCount();
    private final EffectiveUpdatedRowCount expectedRowCountForUpdate = new EffectiveUpdatedRowCount();
    private Connection connection;

    JoinTablePolymorphismPersisterTest() {
    }

    protected ConfiguredRelationalPersister<TotoA, Identifier<Integer>> initMappingTotoA(Table table) {
        KeepOrderMap mappedFields = new KeepOrderMap();
        mappedFields.put(Accessors.propertyAccessor(TotoA.class, (String)"a"), table.addColumn("a", Integer.class));
        PropertyAccessor primaryKeyAccessor = Accessors.propertyAccessor(TotoA.class, (String)"id");
        mappedFields.put(primaryKeyAccessor, table.addColumn("id", Identifier.class).primaryKey());
        AlreadyAssignedIdentifierManager identifierManager = new AlreadyAssignedIdentifierManager(Identifier.class, totoA -> totoA.getId().setPersisted(), totoA -> totoA.getId().isPersisted());
        return new SimpleRelationalEntityPersister(new ClassMapping(TotoA.class, table, (Map)mappedFields, (ReversibleAccessor)primaryKeyAccessor, (IdentifierInsertionManager)identifierManager), this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(() -> this.connection, 3));
    }

    protected ConfiguredRelationalPersister<TotoB, Identifier<Integer>> initMappingTotoB(Table table) {
        KeepOrderMap mappedFields = new KeepOrderMap();
        mappedFields.put(Accessors.propertyAccessor(TotoB.class, (String)"b"), table.addColumn("b", Integer.class));
        PropertyAccessor primaryKeyAccessor = Accessors.propertyAccessor(TotoB.class, (String)"id");
        mappedFields.put(primaryKeyAccessor, table.addColumn("id", Identifier.class).primaryKey());
        AlreadyAssignedIdentifierManager identifierManager = new AlreadyAssignedIdentifierManager(Identifier.class, totoB -> totoB.getId().setPersisted(), totoB -> totoB.getId().isPersisted());
        return new SimpleRelationalEntityPersister(new ClassMapping(TotoB.class, table, (Map)mappedFields, (ReversibleAccessor)primaryKeyAccessor, (IdentifierInsertionManager)identifierManager), this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(() -> this.connection, 3));
    }

    protected void initMapping() {
        Field fieldId = Reflections.getField(AbstractToto.class, (String)"id");
        Field fieldA = Reflections.getField(AbstractToto.class, (String)"x");
        Field fieldQ = Reflections.getField(AbstractToto.class, (String)"q");
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", fieldId.getType()).primaryKey();
        Column xColumn = totoTable.addColumn("x", fieldA.getType());
        Column qColumn = totoTable.addColumn("q", fieldQ.getType());
        PropertyAccessor identifierAccessor = Accessors.propertyAccessor((Field)fieldId);
        Maps.ChainingHashMap totoPropertyMapping = Maps.forHashMap(PropertyAccessor.class, Column.class).add((Object)identifierAccessor, (Object)idColumn).add((Object)Accessors.propertyAccessor((Field)fieldA), (Object)xColumn).add((Object)Accessors.propertyAccessor((Field)fieldQ), (Object)qColumn);
        this.identifierGenerator = new InMemoryCounterIdentifierGenerator();
        BeforeInsertIdentifierManager beforeInsertIdentifierManager = new BeforeInsertIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor((ReversibleAccessor)identifierAccessor), () -> new PersistableIdentifier<Integer>(this.identifierGenerator.next()), Identifier.class);
        this.totoClassMapping = new ClassMapping(AbstractToto.class, totoTable, (Map)totoPropertyMapping, (ReversibleAccessor)identifierAccessor, (IdentifierInsertionManager)beforeInsertIdentifierManager);
        JavaTypeToSqlTypeMapping simpleTypeMapping = new JavaTypeToSqlTypeMapping();
        simpleTypeMapping.put(Identifier.class, "int");
        this.dialect = new Dialect(simpleTypeMapping);
        this.dialect.setInOperatorMaxSize(3);
        this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new ParameterBinder<Identifier>(){

            public Class<Identifier> getType() {
                return Identifier.class;
            }

            public Identifier doGet(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getObject(columnName) == null ? null : new PersistedIdentifier<Object>(resultSet.getObject(columnName));
            }

            public void set(PreparedStatement statement, int valueIndex, Identifier value) throws SQLException {
                statement.setInt(valueIndex, (Integer)value.getSurrogate());
            }
        });
        this.dialect.getColumnBinderRegistry().register(Set.class, (ParameterBinder)new ParameterBinder<Set<Integer>>(){

            public void set(PreparedStatement preparedStatement, int valueIndex, Set<Integer> value) throws SQLException {
                if (value != null) {
                    preparedStatement.setArray(valueIndex, (Array)new JDBCArrayBasic((Object[])value.toArray(new Integer[0]), (Type)Type.SQL_INTEGER));
                } else {
                    preparedStatement.setArray(valueIndex, null);
                }
            }

            public Set<Integer> doGet(ResultSet resultSet, String columnName) throws SQLException {
                Array array = resultSet.getArray(columnName);
                return array == null ? null : new KeepOrderSet((Object[])((Integer[])array.getArray()));
            }

            public Class<Set<Integer>> getType() {
                return Set.class;
            }
        });
    }

    protected <T extends Table<T>> void initTest() throws SQLException {
        this.identifierGenerator.reset();
        this.preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)this.preparedStatement.executeLargeBatch()).thenAnswer(invocation -> this.effectiveBatchedRowCount.next());
        Mockito.when((Object)this.preparedStatement.executeLargeUpdate()).thenAnswer(invocation -> this.expectedRowCountForUpdate.next());
        this.connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.preparedStatement.getConnection()).thenReturn((Object)this.connection);
        this.statementArgCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)this.connection.prepareStatement((String)this.statementArgCaptor.capture())).thenReturn((Object)this.preparedStatement);
        Mockito.when((Object)this.connection.prepareStatement((String)this.statementArgCaptor.capture(), ArgumentMatchers.anyInt())).thenReturn((Object)this.preparedStatement);
        this.valueCaptor = ArgumentCaptor.forClass(Integer.class);
        this.indexCaptor = ArgumentCaptor.forClass(Integer.class);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)this.connection);
        SimpleRelationalEntityPersister mainPersister = new SimpleRelationalEntityPersister(this.totoClassMapping, this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(() -> this.connection, 3));
        Table totoATable = new Table("TotoA");
        Table totoBTable = new Table("TotoB");
        ConfiguredRelationalPersister<TotoA, Identifier<Integer>> totoAIdentifierConfiguredPersister = this.initMappingTotoA(totoATable);
        ConfiguredRelationalPersister<TotoB, Identifier<Integer>> totoBIdentifierConfiguredPersister = this.initMappingTotoB(totoBTable);
        KeepOrderMap subclasses = new KeepOrderMap();
        subclasses.put(TotoA.class, totoAIdentifierConfiguredPersister);
        subclasses.put(TotoB.class, totoBIdentifierConfiguredPersister);
        PolymorphismPolicy.JoinTablePolymorphism polymorphismPolicy = new PolymorphismPolicy.JoinTablePolymorphism();
        polymorphismPolicy.addSubClass(new EmptySubEntityMappingConfiguration<TotoA>(TotoA.class), totoATable);
        polymorphismPolicy.addSubClass(new EmptySubEntityMappingConfiguration<TotoB>(TotoB.class), totoBTable);
        subclasses.values().forEach(arg_0 -> JoinTablePolymorphismPersisterTest.lambda$initTest$10((ConfiguredRelationalPersister)mainPersister, arg_0));
        this.testInstance = new JoinTablePolymorphismPersister((ConfiguredRelationalPersister)mainPersister, (Map)subclasses, new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new CurrentThreadConnectionProvider(dataSource), 3).getConnectionProvider(), this.dialect);
    }

    void assertCapturedPairsEqual(PairSetList<Integer, Integer> expectedPairs) {
        List obtainedPairs = PairSetList.toPairs((Iterable)this.indexCaptor.getAllValues(), (Iterable)this.valueCaptor.getAllValues());
        ArrayList obtained = new ArrayList();
        int startIndex = 0;
        for (Set expectedPair : expectedPairs.asList()) {
            obtained.add(new HashSet(obtainedPairs.subList(startIndex, startIndex += expectedPair.size())));
        }
        Assertions.assertThat(obtained).isEqualTo((Object)expectedPairs.asList());
    }

    private static /* synthetic */ void lambda$initTest$10(ConfiguredRelationalPersister mainPersister, ConfiguredRelationalPersister subclassPersister) {
        subclassPersister.getEntityJoinTree().addMergeJoin("ROOT", (EntityMerger)new EntityMerger.EntityMergerAdapter(mainPersister.getMapping()), (Key)subclassPersister.getMapping().getTargetTable().getPrimaryKey(), (Key)mainPersister.getMainTable().getPrimaryKey());
    }

    static class TotoB
    extends AbstractToto {
        private Integer b;

        public TotoB() {
        }

        TotoB(int id, Integer x, Integer b) {
            super(id, x);
            this.b = b;
        }

        TotoB(Integer x, Integer b) {
            super(x);
            this.b = b;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", (Object)(this.id == null ? "null" : (Serializable)this.id.getSurrogate())).add((Object)"x", (Object)this.x).add((Object)"b", (Object)this.b) + "]";
        }
    }

    static class TotoA
    extends AbstractToto {
        private Integer a;

        TotoA() {
        }

        TotoA(int id, Integer x, Integer a) {
            super(id, x);
            this.a = a;
        }

        TotoA(Integer x, Integer a) {
            super(x);
            this.a = a;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", (Object)(this.id == null ? "null" : (Serializable)this.id.getSurrogate())).add((Object)"x", (Object)this.x).add((Object)"a", (Object)this.a) + "]";
        }
    }

    private static abstract class AbstractToto
    implements Identified<Integer> {
        protected Identifier<Integer> id;
        protected Integer x;
        private Set<Integer> q;

        public AbstractToto() {
        }

        public AbstractToto(int id, Integer x) {
            this.id = new PersistableIdentifier<Integer>(id);
            this.x = x;
        }

        public AbstractToto(Integer x) {
            this.x = x;
        }

        @Override
        public Identifier<Integer> getId() {
            return this.id;
        }

        public Integer getX() {
            return this.x;
        }

        public Set<Integer> getQ() {
            return this.q;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", (Object)(this.id == null ? "null" : (Serializable)this.id.getSurrogate())).add((Object)"x", (Object)this.x) + "]";
        }
    }

    @Nested
    class CRUD {
        CRUD() {
        }

        @BeforeEach
        void setUp() throws SQLException {
            PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
            JoinTablePolymorphismPersisterTest.this.initMapping();
            JoinTablePolymorphismPersisterTest.this.initTest();
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(PersisterBuilderImpl.BuildLifeCycleListener::afterBuild);
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(PersisterBuilderImpl.BuildLifeCycleListener::afterAllBuild);
        }

        @AfterEach
        void removeEntityCandidates() {
            PersisterBuilderContext.CURRENT.remove();
        }

        @Test
        void insert() throws SQLException {
            JoinTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{1L, 1L, 1L}, {1L}, {2L}, {2L}}));
            JoinTablePolymorphismPersisterTest.this.testInstance.insert((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA((Integer)17, (Integer)23), new TotoA((Integer)29, (Integer)31), new TotoB((Integer)37, (Integer)41), new TotoB((Integer)43, (Integer)53)}));
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)16))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"insert into Toto(x, q, id) values (?, ?, ?)", "insert into TotoA(a, id) values (?, ?)", "insert into TotoB(b, id) values (?, ?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)17).add((Object)3, (Object)1).newRow((Object)1, (Object)29).add((Object)3, (Object)2).newRow((Object)1, (Object)37).add((Object)3, (Object)3).newRow((Object)1, (Object)43).add((Object)3, (Object)4).newRow((Object)1, (Object)23).add((Object)2, (Object)1).newRow((Object)1, (Object)31).add((Object)2, (Object)2).newRow((Object)1, (Object)41).add((Object)2, (Object)3).newRow((Object)1, (Object)53).add((Object)2, (Object)4);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void update() throws SQLException {
            String idAlias = "Toto_id";
            String totoAIdAlias = "TotoA_id";
            String totoBIdAlias = "TotoB_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "TotoA_a";
            String totoBAlias = "TotoB_b";
            Mockito.when((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)1).add((Object)totoAIdAlias, (Object)1).add((Object)totoBIdAlias, null), Maps.asMap((Object)idAlias, (Object)2).add((Object)totoAIdAlias, (Object)2).add((Object)totoBIdAlias, null), Maps.asMap((Object)idAlias, (Object)3).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)3), Maps.asMap((Object)idAlias, (Object)4).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)4)})), (Object[])new ResultSet[]{new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)1).add((Object)totoAIdAlias, (Object)1).add((Object)totoXAlias, (Object)17).add((Object)totoAAlias, (Object)23), Maps.asMap((Object)idAlias, (Object)2).add((Object)totoAIdAlias, (Object)2).add((Object)totoXAlias, (Object)29).add((Object)totoAAlias, (Object)31)})), new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)3).add((Object)totoBIdAlias, (Object)3).add((Object)totoXAlias, (Object)37).add((Object)totoBAlias, (Object)41), Maps.asMap((Object)idAlias, (Object)4).add((Object)totoBIdAlias, (Object)4).add((Object)totoXAlias, (Object)43).add((Object)totoBAlias, (Object)53)}))});
            JoinTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{2L}, {2L}, {3L}, {1L}}));
            JoinTablePolymorphismPersisterTest.this.testInstance.update((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA(1, 17, 123), new TotoA(2, 29, 131), new TotoB(3, 37, 141), new TotoB(4, 43, 153)}));
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)3))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)16))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + idAlias + ", TotoA.id as " + totoAIdAlias + ", TotoB.id as " + totoBIdAlias + " from Toto left outer join TotoA on Toto.id = TotoA.id left outer join TotoB on Toto.id = TotoB.id where Toto.id in (?, ?, ?, ?)", "select TotoA.a as " + totoAAlias + ", TotoA.id as " + totoAIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + " from TotoA inner join Toto as Toto on TotoA.id = Toto.id where TotoA.id in (?, ?)", "select TotoB.b as " + totoBAlias + ", TotoB.id as " + totoBIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + " from TotoB inner join Toto as Toto on TotoB.id = Toto.id where TotoB.id in (?, ?)", "update TotoA set a = ? where id = ?", "update TotoB set b = ? where id = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)2).add((Object)3, (Object)3).add((Object)4, (Object)4).newRow((Object)1, (Object)1).add((Object)2, (Object)2).newRow((Object)1, (Object)3).add((Object)2, (Object)4).newRow((Object)1, (Object)123).add((Object)2, (Object)1).newRow((Object)1, (Object)131).add((Object)2, (Object)2).newRow((Object)1, (Object)141).add((Object)2, (Object)3).newRow((Object)1, (Object)153).add((Object)2, (Object)4);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void updateById() throws SQLException {
            JoinTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {1L}, {2L}, {2L}}));
            JoinTablePolymorphismPersisterTest.this.testInstance.updateById((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA(1, 17, 123), new TotoA(2, 29, 131), new TotoB(3, 37, 141), new TotoB(4, 43, 153)}));
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)16))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"update Toto set x = ?, q = ? where id = ?", "update TotoA set a = ? where id = ?", "update TotoB set b = ? where id = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)17).add((Object)3, (Object)1).newRow((Object)1, (Object)29).add((Object)3, (Object)2).newRow((Object)1, (Object)37).add((Object)3, (Object)3).newRow((Object)1, (Object)43).add((Object)3, (Object)4).newRow((Object)1, (Object)123).add((Object)2, (Object)1).newRow((Object)1, (Object)131).add((Object)2, (Object)2).newRow((Object)1, (Object)141).add((Object)2, (Object)3).newRow((Object)1, (Object)153).add((Object)2, (Object)4);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void delete() throws SQLException {
            JoinTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{1L}, {1L}}));
            JoinTablePolymorphismPersisterTest.this.testInstance.delete((Iterable)Arrays.asList((Object[])new TotoA[]{new TotoA(7, 17, 23)}));
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from TotoA where id = ?", "delete from Toto where id = ?"}));
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7).newRow((Object)1, (Object)7);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void delete_multiple() throws SQLException {
            JoinTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{2L}, {2L}, {3L}, {1L}}));
            JoinTablePolymorphismPersisterTest.this.testInstance.delete((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)}));
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from TotoA where id = ?", "delete from TotoB where id = ?", "delete from Toto where id = ?"}));
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)1, (Object)2).add((Object)1, (Object)3).newRow((Object)1, (Object)4).newRow((Object)1, (Object)1).add((Object)1, (Object)2).newRow((Object)1, (Object)3).add((Object)1, (Object)4);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void deleteById() throws SQLException {
            JoinTablePolymorphismPersisterTest.this.expectedRowCountForUpdate.setRowCounts(Arrays.asList((Object[])new Long[]{1L, 1L}));
            JoinTablePolymorphismPersisterTest.this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new TotoA[]{new TotoA(7, 17, 23)}));
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from TotoA where id in (?)", "delete from Toto where id in (?)"}));
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeUpdate();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7).newRow((Object)1, (Object)7);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void deleteById_multiple() throws SQLException {
            JoinTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}}));
            JoinTablePolymorphismPersisterTest.this.expectedRowCountForUpdate.setRowCounts(Arrays.asList((Object[])new Long[]{2L, 2L, 1L}));
            JoinTablePolymorphismPersisterTest.this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)}));
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from TotoA where id in (?, ?)", "delete from TotoB where id in (?, ?)", "delete from Toto where id in (?, ?, ?)", "delete from Toto where id in (?)"}));
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)3))).executeLargeUpdate();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)2).newRow((Object)1, (Object)3).add((Object)2, (Object)4).newRow((Object)1, (Object)1).add((Object)2, (Object)2).add((Object)3, (Object)3).newRow((Object)1, (Object)4);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void select() throws SQLException {
            String idAlias = "Toto_id";
            String totoAIdAlias = "TotoA_id";
            String totoBIdAlias = "TotoB_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "TotoA_a";
            String totoBAlias = "TotoB_b";
            Mockito.when((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)1).add((Object)totoAIdAlias, (Object)1).add((Object)totoBIdAlias, null), Maps.asMap((Object)idAlias, (Object)2).add((Object)totoAIdAlias, (Object)2).add((Object)totoBIdAlias, null), Maps.asMap((Object)idAlias, (Object)3).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)3), Maps.asMap((Object)idAlias, (Object)4).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)4)})), (Object[])new ResultSet[]{new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)1).add((Object)totoAIdAlias, (Object)1).add((Object)totoXAlias, (Object)17).add((Object)totoAAlias, (Object)23), Maps.asMap((Object)idAlias, (Object)2).add((Object)totoAIdAlias, (Object)2).add((Object)totoXAlias, (Object)29).add((Object)totoAAlias, (Object)31)})), new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)3).add((Object)totoBIdAlias, (Object)3).add((Object)totoXAlias, (Object)37).add((Object)totoBAlias, (Object)41), Maps.asMap((Object)idAlias, (Object)4).add((Object)totoBIdAlias, (Object)4).add((Object)totoXAlias, (Object)43).add((Object)totoBAlias, (Object)53)}))});
            Set select = JoinTablePolymorphismPersisterTest.this.testInstance.select((Iterable)Arrays.asList((Object[])new Identifier[]{new PersistedIdentifier<Integer>(1), new PersistedIdentifier<Integer>(2), new PersistedIdentifier<Integer>(3), new PersistedIdentifier<Integer>(4)}));
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)3))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + idAlias + ", TotoA.id as " + totoAIdAlias + ", TotoB.id as " + totoBIdAlias + " from Toto left outer join TotoA on Toto.id = TotoA.id left outer join TotoB on Toto.id = TotoB.id where Toto.id in (?, ?, ?, ?)", "select TotoA.a as " + totoAAlias + ", TotoA.id as " + totoAIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + " from TotoA inner join Toto as Toto on TotoA.id = Toto.id where TotoA.id in (?, ?)", "select TotoB.b as " + totoBAlias + ", TotoB.id as " + totoBIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + " from TotoB inner join Toto as Toto on TotoB.id = Toto.id where TotoB.id in (?, ?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)2).add((Object)3, (Object)3).add((Object)4, (Object)4).newRow((Object)1, (Object)1).add((Object)2, (Object)2).newRow((Object)1, (Object)3).add((Object)2, (Object)4);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)select).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)});
        }

        @Test
        void selectWhere() throws SQLException {
            String idAlias = "Toto_id";
            String totoAIdAlias = "TotoA_id";
            String totoBIdAlias = "TotoB_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "TotoA_a";
            String totoBAlias = "TotoB_b";
            Mockito.when((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)1).add((Object)totoXAlias, (Object)17).add((Object)totoAIdAlias, (Object)1).add((Object)totoBIdAlias, null).add((Object)totoAAlias, (Object)23).add((Object)totoBAlias, null), Maps.asMap((Object)idAlias, (Object)2).add((Object)totoXAlias, (Object)29).add((Object)totoAIdAlias, (Object)2).add((Object)totoBIdAlias, null).add((Object)totoAAlias, (Object)31).add((Object)totoBAlias, null), Maps.asMap((Object)idAlias, (Object)3).add((Object)totoXAlias, (Object)37).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)3).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)41), Maps.asMap((Object)idAlias, (Object)4).add((Object)totoXAlias, (Object)43).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)4).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)53)})));
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = JoinTablePolymorphismPersisterTest.this.testInstance.selectWhere(AbstractToto::getX, (ConditionalOperator)Operators.eq((Object)42));
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + ", TotoA.a as " + totoAAlias + ", TotoA.id as " + totoAIdAlias + ", TotoB.b as " + totoBAlias + ", TotoB.id as " + totoBIdAlias + " from Toto left outer join TotoA as TotoA on Toto.id = TotoA.id left outer join TotoB as TotoB on Toto.id = TotoB.id where Toto.x = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)42);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)select).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)});
        }

        @Test
        void selectWhere_orderByOnNonCollectionProperty_orderByIsAddedToSQL() throws SQLException {
            String idAlias = "Toto_id";
            String totoAIdAlias = "TotoA_id";
            String totoBIdAlias = "TotoB_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "TotoA_a";
            String totoBAlias = "TotoB_b";
            Mockito.when((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)1).add((Object)totoXAlias, (Object)17).add((Object)totoAIdAlias, (Object)1).add((Object)totoBIdAlias, null).add((Object)totoAAlias, (Object)23).add((Object)totoBAlias, null), Maps.asMap((Object)idAlias, (Object)2).add((Object)totoXAlias, (Object)29).add((Object)totoAIdAlias, (Object)2).add((Object)totoBIdAlias, null).add((Object)totoAAlias, (Object)31).add((Object)totoBAlias, null), Maps.asMap((Object)idAlias, (Object)3).add((Object)totoXAlias, (Object)37).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)3).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)41), Maps.asMap((Object)idAlias, (Object)4).add((Object)totoXAlias, (Object)43).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)4).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)53)})));
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = (RelationalEntityPersister.ExecutableEntityQueryCriteria)JoinTablePolymorphismPersisterTest.this.testInstance.selectWhere(AbstractToto::getX, (ConditionalOperator)Operators.eq((Object)42)).orderBy(AbstractToto::getX);
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + ", TotoA.a as " + totoAAlias + ", TotoA.id as " + totoAIdAlias + ", TotoB.b as " + totoBAlias + ", TotoB.id as " + totoBIdAlias + " from Toto left outer join TotoA as TotoA on Toto.id = TotoA.id left outer join TotoB as TotoB on Toto.id = TotoB.id where Toto.x = ? order by Toto.x asc"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)42);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)select).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)});
        }

        @Test
        void selectWhere_orderByOnCollectionProperty_throwsException() {
            Assertions.assertThatCode(() -> {
                RelationalEntityPersister.ExecutableEntityQueryCriteria cfr_ignored_0 = (RelationalEntityPersister.ExecutableEntityQueryCriteria)JoinTablePolymorphismPersisterTest.this.testInstance.selectWhere(AbstractToto::getX, (ConditionalOperator)Operators.eq((Object)42)).orderBy(AbstractToto::getQ);
            }).hasMessage("OrderBy clause on a Collection property is unsupported due to eventual inconsistency with Collection nature : o.c.s.e.r.JoinTablePolymorphismPersisterTest$AbstractToto::getQ");
        }

        @Test
        void selectWhere_collectionCriteria() throws SQLException {
            String idAlias = "Toto_id";
            String totoAIdAlias = "TotoA_id";
            String totoBIdAlias = "TotoB_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "TotoA_a";
            String totoBAlias = "TotoB_b";
            Mockito.when((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)1).add((Object)totoAIdAlias, (Object)1).add((Object)totoBIdAlias, null).add((Object)totoXAlias, (Object)17), Maps.asMap((Object)idAlias, (Object)2).add((Object)totoAIdAlias, (Object)2).add((Object)totoBIdAlias, null).add((Object)totoXAlias, (Object)29), Maps.asMap((Object)idAlias, (Object)3).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)3).add((Object)totoXAlias, (Object)37), Maps.asMap((Object)idAlias, (Object)4).add((Object)totoAIdAlias, null).add((Object)totoBIdAlias, (Object)4).add((Object)totoXAlias, (Object)43)})), (Object[])new ResultSet[]{new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)1).add((Object)totoAIdAlias, (Object)1).add((Object)totoXAlias, (Object)17).add((Object)totoAAlias, (Object)23), Maps.asMap((Object)idAlias, (Object)2).add((Object)totoAIdAlias, (Object)2).add((Object)totoXAlias, (Object)29).add((Object)totoAAlias, (Object)31)})), new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)idAlias, (Object)3).add((Object)totoBIdAlias, (Object)3).add((Object)totoXAlias, (Object)37).add((Object)totoBAlias, (Object)41), Maps.asMap((Object)idAlias, (Object)4).add((Object)totoBIdAlias, (Object)4).add((Object)totoXAlias, (Object)43).add((Object)totoBAlias, (Object)53)}))});
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = JoinTablePolymorphismPersisterTest.this.testInstance.selectWhere(AbstractToto::getQ, (ConditionalOperator)Operators.eq((Object)Arrays.asHashSet((Object[])new Integer[]{42})));
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)3))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)JoinTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)JoinTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)JoinTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)JoinTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + ", TotoA.id as " + totoAIdAlias + ", TotoB.id as " + totoBIdAlias + " from Toto left outer join TotoA on Toto.id = TotoA.id left outer join TotoB on Toto.id = TotoB.id where Toto.q = ?", "select TotoA.a as " + totoAAlias + ", TotoA.id as " + totoAIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + " from TotoA inner join Toto as Toto on TotoA.id = Toto.id where TotoA.id in (?, ?)", "select TotoB.b as " + totoBAlias + ", TotoB.id as " + totoBIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.id as " + idAlias + " from TotoB inner join Toto as Toto on TotoB.id = Toto.id where TotoB.id in (?, ?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1);
            JoinTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)select).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)});
        }
    }

    private static class EffectiveUpdatedRowCount
    implements Sequence<Long> {
        private Iterator<Long> rowCounts;

        private EffectiveUpdatedRowCount() {
        }

        public void setRowCounts(List<Long> rowCounts) {
            this.rowCounts = rowCounts.iterator();
        }

        public Long next() {
            return this.rowCounts.next();
        }
    }

    private static class EffectiveBatchedRowCount
    implements Sequence<long[]> {
        private Iterator<long[]> rowCounts;

        private EffectiveBatchedRowCount() {
        }

        public void setRowCounts(List<long[]> rowCounts) {
            this.rowCounts = rowCounts.iterator();
        }

        public long[] next() {
            return this.rowCounts.next();
        }
    }
}

