/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetomany;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.cascade.AfterInsertCollectionCascader;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.SelectListenerCollection;
import org.codefilarete.stalactite.engine.runtime.AssociationRecord;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.engine.runtime.AssociationTable;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.onetomany.AbstractOneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.ManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.order.Delete;
import org.codefilarete.stalactite.sql.order.DeleteCommandBuilder;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;

public abstract class AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, R extends AssociationRecord, T extends AssociationTable<T, ?, ?, SRCID, TRGTID>> {
    public static final int INDEXED_COLLECTION_FIRST_INDEX_VALUE = 1;
    protected final AssociationRecordPersister<R, T> associationPersister;
    protected final PersisterListenerCollection<SRC, SRCID> persisterListener;
    protected final ConfiguredRelationalPersister<SRC, SRCID> sourcePersister;
    protected final ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister;
    protected final ManyRelationDescriptor<SRC, TRGT, C> manyRelationDescriptor;
    private final WriteOperationFactory writeOperationFactory;

    public AbstractOneToManyWithAssociationTableEngine(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, ManyRelationDescriptor<SRC, TRGT, C> manyRelationDescriptor, AssociationRecordPersister<R, T> associationPersister, WriteOperationFactory writeOperationFactory) {
        this.sourcePersister = sourcePersister;
        this.persisterListener = sourcePersister.getPersisterListener();
        this.targetPersister = targetPersister;
        this.manyRelationDescriptor = manyRelationDescriptor;
        this.associationPersister = associationPersister;
        this.writeOperationFactory = writeOperationFactory;
    }

    public ManyRelationDescriptor<SRC, TRGT, C> getManyRelationDescriptor() {
        return this.manyRelationDescriptor;
    }

    public void addSelectCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, boolean loadSeparately) {
        String associationTableJoinNodeName = sourcePersister.getEntityJoinTree().addPassiveJoin("ROOT", ((AssociationTable)this.associationPersister.getMainTable()).getOneSideKey(), ((AssociationTable)this.associationPersister.getMainTable()).getOneSideForeignKey(), EntityJoinTree.JoinType.OUTER, Collections.emptySet());
        this.targetPersister.joinAsMany(sourcePersister, ((AssociationTable)this.associationPersister.getMainTable()).getManySideForeignKey(), ((AssociationTable)this.associationPersister.getMainTable()).getManySideKey(), this.manyRelationDescriptor.getRelationFixer(), null, associationTableJoinNodeName, true, loadSeparately);
        SelectListenerCollection targetSelectListener = this.targetPersister.getPersisterListener().getSelectListener();
        sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>((SelectListener)targetSelectListener){
            final /* synthetic */ SelectListener val$targetSelectListener;
            {
                this.val$targetSelectListener = selectListener;
            }

            public void beforeSelect(Iterable<SRCID> ids) {
                this.val$targetSelectListener.beforeSelect(Collections.emptyList());
            }

            public void afterSelect(Set<? extends SRC> result) {
                Set collect = Iterables.stream(result).flatMap(src -> (Stream)Nullable.nullable(AbstractOneToManyWithAssociationTableEngine.this.manyRelationDescriptor.getCollectionGetter().apply(src)).map(Collection::stream).getOr(Stream.empty())).collect(Collectors.toSet());
                this.val$targetSelectListener.afterSelect(collect);
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.val$targetSelectListener.onSelectError(Collections.emptyList(), exception);
            }
        });
    }

    public void addInsertCascade(boolean maintainAssociationOnly) {
        if (!maintainAssociationOnly) {
            this.persisterListener.addInsertListener(new TargetInstancesInsertCascader<SRC, TRGT, TRGTID>(this.targetPersister, this.manyRelationDescriptor.getCollectionGetter()));
        }
        this.persisterListener.addInsertListener(this.newRecordInsertionCascader(this.manyRelationDescriptor.getCollectionGetter(), this.associationPersister, this.sourcePersister.getMapping(), this.targetPersister.getMapping()));
    }

    public void addUpdateCascade(boolean shouldDeleteRemoved, boolean maintainAssociationOnly) {
        CollectionUpdater collectionUpdater = new CollectionUpdater<SRC, TRGT, C>(this.manyRelationDescriptor.getCollectionGetter(), this.targetPersister, null, shouldDeleteRemoved){

            protected AssociationTableUpdateContext newUpdateContext(Duo<SRC, SRC> updatePayload) {
                return new AssociationTableUpdateContext(updatePayload);
            }

            @Override
            protected void onAddedElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
                super.onAddedElements(updateContext, diff);
                Object associationRecord = AbstractOneToManyWithAssociationTableEngine.this.newRecord(updateContext.getPayload().getLeft(), diff.getReplacingInstance(), 0);
                ((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeInserted().add(associationRecord);
            }

            @Override
            protected void onRemovedElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
                super.onRemovedElements(updateContext, diff);
                Object associationRecord = AbstractOneToManyWithAssociationTableEngine.this.newRecord(updateContext.getPayload().getLeft(), diff.getSourceInstance(), 0);
                ((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeDeleted().add(associationRecord);
            }

            @Override
            protected void insertTargets(CollectionUpdater.UpdateContext updateContext) {
                super.insertTargets(updateContext);
                AbstractOneToManyWithAssociationTableEngine.this.associationPersister.insert(((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeInserted());
            }

            @Override
            protected void deleteTargets(CollectionUpdater.UpdateContext updateContext) {
                AbstractOneToManyWithAssociationTableEngine.this.associationPersister.delete(((AssociationTableUpdateContext)updateContext).getAssociationRecordsToBeDeleted());
                super.deleteTargets(updateContext);
            }

            class AssociationTableUpdateContext
            extends CollectionUpdater.UpdateContext {
                private final List<R> associationRecordsToBeInserted;
                private final List<R> associationRecordsToBeDeleted;

                public AssociationTableUpdateContext(Duo<SRC, SRC> updatePayload) {
                    super(this, updatePayload);
                    this.associationRecordsToBeInserted = new ArrayList();
                    this.associationRecordsToBeDeleted = new ArrayList();
                }

                public List<R> getAssociationRecordsToBeInserted() {
                    return this.associationRecordsToBeInserted;
                }

                public List<R> getAssociationRecordsToBeDeleted() {
                    return this.associationRecordsToBeDeleted;
                }
            }
        };
        if (!maintainAssociationOnly) {
            this.persisterListener.addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(collectionUpdater));
        }
    }

    public void addDeleteCascade(boolean deleteTargetEntities, final Dialect dialect) {
        this.persisterListener.addDeleteListener(new DeleteListener<SRC>(){

            public void beforeDelete(Iterable<? extends SRC> entities) {
                ArrayList associationRecords = new ArrayList();
                entities.forEach(src -> {
                    Collection targets = (Collection)Nullable.nullable(AbstractOneToManyWithAssociationTableEngine.this.manyRelationDescriptor.getCollectionGetter().apply(src)).getOr(AbstractOneToManyWithAssociationTableEngine.this.manyRelationDescriptor.getCollectionFactory());
                    int i = 1;
                    for (Object target : targets) {
                        associationRecords.add(AbstractOneToManyWithAssociationTableEngine.this.newRecord(src, target, i++));
                    }
                });
                AbstractOneToManyWithAssociationTableEngine.this.associationPersister.delete(associationRecords);
            }
        });
        this.persisterListener.addDeleteByIdListener(new DeleteByIdListener<SRC>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void beforeDeleteById(Iterable<? extends SRC> entities) {
                KeepOrderSet columns;
                Delete associationTableDelete = new Delete(AbstractOneToManyWithAssociationTableEngine.this.associationPersister.getMainTable());
                EntityMapping idMapping = AbstractOneToManyWithAssociationTableEngine.this.sourcePersister.getMapping();
                Set identifiers = (Set)Iterables.collect(entities, arg_0 -> ((EntityMapping)idMapping).getId(arg_0), HashSet::new);
                if (((AssociationTable)AbstractOneToManyWithAssociationTableEngine.this.associationPersister.getMainTable()).getOneSideForeignKey().isComposed()) {
                    if (!dialect.supportsTupleCondition()) throw new UnsupportedOperationException("Can't use tupled-in because database doesn't support it");
                    columns = new HashSet();
                    ArrayList values = new ArrayList(identifiers.size());
                    identifiers.forEach(arg_0 -> 4.lambda$beforeDeleteById$0(idMapping, (Set)columns, values, arg_0));
                    associationTableDelete.getCriteria().and(new Object[]{new TupleIn(columns.toArray(new Column[0]), values)});
                } else {
                    columns = ((AssociationTable)AbstractOneToManyWithAssociationTableEngine.this.associationPersister.getMainTable()).getOneSideForeignKey().getColumns();
                    associationTableDelete.where((Column)Iterables.first((Iterable)columns), (ConditionalOperator)Operators.in((Iterable)identifiers));
                }
                PreparedSQL deleteStatement = new DeleteCommandBuilder(associationTableDelete, dialect).toPreparedSQL().toPreparedSQL(new HashMap());
                try (WriteOperation writeOperation = AbstractOneToManyWithAssociationTableEngine.this.writeOperationFactory.createInstance((SQLStatement)deleteStatement, AbstractOneToManyWithAssociationTableEngine.this.associationPersister.getConnectionProvider());){
                    writeOperation.setValues(deleteStatement.getValues());
                    writeOperation.execute();
                    return;
                }
            }

            private static /* synthetic */ void lambda$beforeDeleteById$0(EntityMapping idMapping, Set columns, List values, Object srcid) {
                Map idValues = idMapping.getIdMapping().getIdentifierAssembler().getColumnValues(srcid);
                if (columns.isEmpty()) {
                    columns.addAll(idValues.keySet());
                }
                values.add(idValues.values().toArray(new Object[0]));
            }
        });
        if (deleteTargetEntities) {
            this.persisterListener.addDeleteListener(new OneToManyWithMappedAssociationEngine.DeleteTargetEntitiesBeforeDeleteCascader<SRC, TRGT>(this.targetPersister, this.manyRelationDescriptor.getCollectionGetter()));
            this.persisterListener.addDeleteByIdListener(new OneToManyWithMappedAssociationEngine.DeleteByIdTargetEntitiesBeforeDeleteByIdCascader<SRC, TRGT>(this.targetPersister, this.manyRelationDescriptor.getCollectionGetter()));
        }
    }

    protected abstract AfterInsertCollectionCascader<SRC, R> newRecordInsertionCascader(Function<SRC, C> var1, AssociationRecordPersister<R, T> var2, EntityMapping<SRC, SRCID, ?> var3, EntityMapping<TRGT, TRGTID, ?> var4);

    protected abstract R newRecord(SRC var1, TRGT var2, int var3);

    public void addSelectCascadeIn2Phases(OneToManyRelationConfigurer.FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        IdentifierAssembler targetIdentifierAssembler = this.targetPersister.getMapping().getIdMapping().getIdentifierAssembler();
        this.sourcePersister.getEntityJoinTree().addPassiveJoin("ROOT", ((AssociationTable)this.associationPersister.getMainTable()).getOneSideKey(), ((AssociationTable)this.associationPersister.getMainTable()).getOneSideForeignKey(), EntityJoinTree.JoinType.OUTER, ((AssociationTable)this.associationPersister.getMainTable()).getManySideForeignKey().getColumns(), (src, columnValueProvider) -> {
            Function<Column, Object> manySideColumnValueProvider = columnFromRightTablePK -> {
                Column columnFromAssociationTableFK = ((AssociationTable)this.associationPersister.getMainTable()).getRightIdentifierColumnMapping().get(columnFromRightTablePK);
                if (columnFromAssociationTableFK == null) {
                    throw new IllegalStateException("No matching column in foreign key of association table " + this.associationPersister.getMainTable() + " found for primary key " + columnFromRightTablePK);
                }
                return columnValueProvider.apply(columnFromAssociationTableFK);
            };
            firstPhaseCycleLoadListener.onFirstPhaseRowRead(src, targetIdentifierAssembler.assemble(manySideColumnValueProvider));
        });
    }

    public static class TargetInstancesInsertCascader<I, O, J>
    extends AfterInsertCollectionCascader<I, O> {
        private final Function<I, ? extends Collection<O>> collectionGetter;

        public TargetInstancesInsertCascader(EntityPersister<O, J> targetPersister, Function<I, ? extends Collection<O>> collectionGetter) {
            super(targetPersister);
            this.collectionGetter = collectionGetter;
        }

        @Override
        protected void postTargetInsert(Iterable<? extends O> entities) {
        }

        @Override
        protected Collection<O> getTargets(I source) {
            return this.collectionGetter.apply(source);
        }
    }
}

