/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnionAware;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.KeepOrderSet;

public class Union
implements QueryStatement,
UnionAware,
QueryProvider<Union> {
    private final KeepOrderSet<Query> queries;
    private final Map<Selectable<?>, String> aliases = new HashMap();
    private final KeepOrderSet<QueryStatement.PseudoColumn<Object>> columns = new KeepOrderSet();

    public Union(Collection<Query> queries) {
        this.queries = new KeepOrderSet(queries);
    }

    public Union(Query ... queries) {
        this.queries = new KeepOrderSet((Object[])queries);
    }

    public KeepOrderSet<Query> getQueries() {
        return this.queries;
    }

    @Override
    public Union getQuery() {
        return this;
    }

    public <O> QueryStatement.PseudoColumn<O> addColumn(String expression, Class<O> javaType) {
        return this.addColumn(expression, javaType, null);
    }

    public <O> QueryStatement.PseudoColumn<O> addColumn(String expression, Class<O> javaType, @Nullable String alias) {
        return this.addertColumn(new QueryStatement.PseudoColumn<O>(this, expression, javaType), alias);
    }

    private <O> QueryStatement.PseudoColumn<O> addertColumn(QueryStatement.PseudoColumn<O> column, @Nullable String alias) {
        QueryStatement.PseudoColumn existingColumn = (QueryStatement.PseudoColumn)this.findColumn(column.getExpression(), alias);
        if (existingColumn != null && Objects.equals(alias, this.aliases.get(existingColumn)) && !existingColumn.getJavaType().equals(column.getJavaType())) {
            throw new IllegalArgumentException("Trying to add a column '" + existingColumn.getExpression() + "' that already exists with a different type : " + Reflections.toString(existingColumn.getJavaType()) + " vs " + Reflections.toString(column.getJavaType()));
        }
        if (existingColumn == null) {
            this.columns.add(column);
            return column;
        }
        return existingColumn;
    }

    private <C extends Selectable<?>> C findColumn(String columnName, @Nullable String alias) {
        if (alias != null) {
            for (Map.Entry<Selectable<?>, String> entry : this.getAliases().entrySet()) {
                if (!entry.getValue().equals(alias)) continue;
                return (C)entry.getKey();
            }
        } else {
            for (Selectable selectable : this.getColumns()) {
                if (!(selectable instanceof JoinLink) || !selectable.getExpression().equals(columnName)) continue;
                return (C)selectable;
            }
        }
        return null;
    }

    public <O> QueryStatement.PseudoColumn<O> registerColumn(String expression, Class<O> javaType) {
        return this.addColumn(expression, javaType);
    }

    public <O> QueryStatement.PseudoColumn<O> registerColumn(String expression, Class<O> javaType, String alias) {
        return this.addColumn(expression, javaType, alias);
    }

    public Set<QueryStatement.PseudoColumn<?>> getColumns() {
        return this.columns;
    }

    @Override
    public Map<Selectable<?>, String> getAliases() {
        return this.aliases;
    }

    @Override
    public Union unionAll(QueryProvider<Query> query) {
        this.queries.add((Object)query.getQuery());
        return this;
    }

    public Map<String, Selectable<?>> mapColumnsOnName() {
        HashMap result = new HashMap();
        for (QueryStatement.PseudoColumn<?> pseudoColumn : this.getColumns()) {
            result.put(pseudoColumn.getExpression(), pseudoColumn);
        }
        for (Map.Entry entry : this.getAliases().entrySet()) {
            result.put((String)entry.getValue(), (Selectable<?>)entry.getKey());
        }
        return result;
    }
}

