/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnvaluedVariable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.ExpandableSQL;
import org.codefilarete.stalactite.sql.statement.ExpandableStatement;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.SQLParameterParser;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.trace.ModifiableInt;

public class ExpandableSQLAppender
implements SQLAppender {
    private final SQLParameterParser.ParsedSQL parsedSQL;
    private StringAppender currentSQLSnippet = new StringAppender();
    private final ColumnBinderRegistry parameterBinderRegistry;
    private final Map<String, ParameterBinder> parameterBinders;
    private final Map<String, Object> values;
    private final ModifiableInt paramCounter = new ModifiableInt();
    private final DMLNameProvider dmlNameProvider;

    public ExpandableSQLAppender(ColumnBinderRegistry parameterBinderRegistry, DMLNameProvider dmlNameProvider) {
        this.parsedSQL = new SQLParameterParser.ParsedSQL();
        this.parsedSQL.addSqlSnippet((CharSequence)this.currentSQLSnippet);
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.dmlNameProvider = dmlNameProvider;
        this.parameterBinders = new HashMap<String, ParameterBinder>();
        this.values = new HashMap<String, Object>();
    }

    public SQLParameterParser.ParsedSQL getParsedSQL() {
        return this.parsedSQL;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Map<String, ParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    @Override
    public SQLAppender cat(String s, String ... ss) {
        this.currentSQLSnippet.cat((Object)s).cat((Object[])ss);
        return this;
    }

    @Override
    public <V> SQLAppender catValue(@Nullable Selectable<V> column, Object value) {
        ParameterBinder parameterBinder = column == null ? this.getParameterBinderFromRegistry(value) : (column instanceof Column ? this.parameterBinderRegistry.getBinder((Column)column) : this.parameterBinderRegistry.getBinder(column.getJavaType()));
        return this.catValue(value, parameterBinder);
    }

    @Override
    public SQLAppender catValue(Object variable) {
        if (variable instanceof ValuedVariable) {
            Object value = ((ValuedVariable)variable).getValue();
            if (value instanceof Selectable) {
                this.currentSQLSnippet.cat((Object)this.dmlNameProvider.getName((Selectable)value));
            } else {
                this.handleValuePlaceholder(value, this.getParameterBinderFromRegistry(value));
            }
        } else if (variable instanceof UnvaluedVariable) {
            this.handleVariablePlaceholder((UnvaluedVariable)variable);
        } else {
            this.handleValuePlaceholder(variable, this.getParameterBinderFromRegistry(variable));
        }
        return this;
    }

    private ParameterBinder<?> getParameterBinderFromRegistry(Object value) {
        ParameterBinder parameterBinder;
        if (value instanceof ValuedVariable) {
            parameterBinder = this.getParameterBinderFromRegistry(((ValuedVariable)value).getValue());
        } else if (value instanceof UnvaluedVariable) {
            parameterBinder = this.parameterBinderRegistry.getBinder(((UnvaluedVariable)value).getValueType());
        } else {
            Class<?> binderType = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
            parameterBinder = this.parameterBinderRegistry.getBinder(binderType);
        }
        return parameterBinder;
    }

    private SQLAppender catValue(Object value, ParameterBinder<?> binderSupplier) {
        if (value instanceof ValuedVariable) {
            Object innerValue = ((ValuedVariable)value).getValue();
            if (innerValue instanceof Selectable) {
                this.currentSQLSnippet.cat((Object)this.dmlNameProvider.getName((Selectable)innerValue));
            } else {
                this.handleValuePlaceholder(innerValue, binderSupplier);
            }
        } else if (value instanceof UnvaluedVariable) {
            this.handleVariablePlaceholder((UnvaluedVariable)value);
        } else {
            this.handleValuePlaceholder(value, binderSupplier);
        }
        return this;
    }

    private void handleVariablePlaceholder(UnvaluedVariable<?, ?> variable) {
        this.parsedSQL.addParam(variable.getName());
        this.parameterBinders.put(variable.getName(), this.parameterBinderRegistry.getBinder(variable.getValueType()));
        this.nextSqlSnippet();
    }

    private void handleValuePlaceholder(Object value, ParameterBinder<?> binderSupplier) {
        String paramName = String.valueOf(this.paramCounter.increment());
        this.parsedSQL.addParam(paramName);
        this.parameterBinders.put(paramName, binderSupplier);
        this.values.put(paramName, value);
        this.nextSqlSnippet();
    }

    private void nextSqlSnippet() {
        this.currentSQLSnippet = new StringAppender();
        this.parsedSQL.addSqlSnippet((CharSequence)this.currentSQLSnippet);
    }

    @Override
    public SQLAppender catColumn(Column column) {
        this.currentSQLSnippet.cat((Object)this.dmlNameProvider.getName(column));
        return this;
    }

    @Override
    public SQLAppender removeLastChars(int length) {
        this.currentSQLSnippet.cutTail(length);
        return this;
    }

    @Override
    public String getSQL() {
        return this.parsedSQL.toString();
    }

    public PreparedSQL toPreparedSQL(Map<String, Object> values) {
        HashMap<String, Object> mergedValues = new HashMap<String, Object>(this.getValues());
        mergedValues.putAll(values);
        this.unwrapVariables(mergedValues);
        Map valuesSizes = ExpandableSQL.sizes(mergedValues);
        ExpandableSQL expandableSQL = new ExpandableSQL(this.parsedSQL, valuesSizes);
        String placeholderSql = expandableSQL.getPreparedSQL();
        HashMap placeholderBinders = new HashMap();
        HashMap placeholderValues = new HashMap();
        mergedValues.forEach((paramName, value) -> {
            int[] markIndexes;
            ExpandableSQL.ExpandableParameter expandableParameter = (ExpandableSQL.ExpandableParameter)expandableSQL.getExpandableParameters().get(paramName);
            for (int markIndex : markIndexes = expandableParameter.getMarkIndexes()) {
                placeholderBinders.put(markIndex, this.parameterBinders.get(paramName));
            }
            ExpandableStatement.adaptIterablePlaceholders((Object)value, (int[])markIndexes, placeholderValues::put);
        });
        PreparedSQL result = new PreparedSQL(placeholderSql, placeholderBinders);
        result.setValues(placeholderValues);
        return result;
    }

    private void unwrapVariables(Map<String, Object> mergedValues) {
        mergedValues.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof ValuedVariable) {
                entry.setValue(((ValuedVariable)entry.getValue()).getValue());
            }
        });
    }
}

