/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.H2DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.H2TypeMapping;
import org.codefilarete.tool.collection.Arrays;

public class H2Dialect
extends Dialect {
    public H2Dialect() {
        super((JavaTypeToSqlTypeMapping)new H2TypeMapping());
    }

    protected H2DDLTableGenerator newDdlTableGenerator() {
        return new H2DDLTableGenerator(this.getSqlTypeRegistry());
    }

    public static class H2DMLNameProvider
    extends DMLNameProvider {
        public static final Set<String> KEYWORDS = Collections.unmodifiableSet(Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[0]));

        public H2DMLNameProvider(Map<Table, String> tableAliases) {
            super(tableAliases);
        }

        public String getSimpleName(Selectable<?> column) {
            if (KEYWORDS.contains(column.getExpression())) {
                return "`" + column.getExpression() + "`";
            }
            return super.getSimpleName(column);
        }

        public String getName(Fromable table) {
            if (KEYWORDS.contains(table.getName())) {
                return "`" + super.getName(table) + "`";
            }
            return super.getName(table);
        }
    }
}

