/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Map;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.builder.FromSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.PreparedSQLBuilder;
import org.codefilarete.stalactite.query.builder.PseudoTableSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.SelectSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.StringAppender;

public class QuerySQLBuilderFactory {
    private final ColumnBinderRegistry parameterBinderRegistry;
    private final SelectSQLBuilderFactory selectBuilderFactory;
    private final FromSQLBuilderFactory fromBuilderFactory;
    private final PseudoTableSQLBuilderFactory pseudoTableSQLBuilderFactory;
    private final WhereSQLBuilderFactory whereBuilderFactory;
    private final WhereSQLBuilderFactory havingBuilderFactory;
    private final FunctionSQLBuilderFactory functionSQLBuilderFactory;

    public QuerySQLBuilderFactory(ColumnBinderRegistry parameterBinderRegistry, SelectSQLBuilderFactory selectBuilderFactory, FromSQLBuilderFactory fromBuilderFactory, PseudoTableSQLBuilderFactory pseudoTableSQLBuilderFactory, WhereSQLBuilderFactory whereBuilderFactory, WhereSQLBuilderFactory havingBuilderFactory, FunctionSQLBuilderFactory functionSQLBuilderFactory) {
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.selectBuilderFactory = selectBuilderFactory;
        this.fromBuilderFactory = fromBuilderFactory;
        this.pseudoTableSQLBuilderFactory = pseudoTableSQLBuilderFactory;
        this.whereBuilderFactory = whereBuilderFactory;
        this.havingBuilderFactory = havingBuilderFactory;
        this.functionSQLBuilderFactory = functionSQLBuilderFactory;
    }

    public QuerySQLBuilderFactory(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping, ColumnBinderRegistry parameterBinderRegistry) {
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.selectBuilderFactory = new SelectSQLBuilderFactory(javaTypeToSqlTypeMapping);
        this.fromBuilderFactory = new FromSQLBuilderFactory();
        this.pseudoTableSQLBuilderFactory = new PseudoTableSQLBuilderFactory();
        this.whereBuilderFactory = new WhereSQLBuilderFactory(javaTypeToSqlTypeMapping, parameterBinderRegistry);
        this.havingBuilderFactory = new WhereSQLBuilderFactory(javaTypeToSqlTypeMapping, parameterBinderRegistry);
        this.functionSQLBuilderFactory = new FunctionSQLBuilderFactory(javaTypeToSqlTypeMapping);
    }

    public ColumnBinderRegistry getParameterBinderRegistry() {
        return this.parameterBinderRegistry;
    }

    public SelectSQLBuilderFactory getSelectBuilderFactory() {
        return this.selectBuilderFactory;
    }

    public FromSQLBuilderFactory getFromBuilderFactory() {
        return this.fromBuilderFactory;
    }

    public WhereSQLBuilderFactory getWhereBuilderFactory() {
        return this.whereBuilderFactory;
    }

    public WhereSQLBuilderFactory getHavingBuilderFactory() {
        return this.havingBuilderFactory;
    }

    public FunctionSQLBuilderFactory getFunctionSQLBuilderFactory() {
        return this.functionSQLBuilderFactory;
    }

    public QuerySQLBuilder queryBuilder(Query query, Iterable<AbstractCriterion> where) {
        if (where.iterator().hasNext()) {
            query.getWhere().and(where);
        }
        return this.queryBuilder(query);
    }

    public QuerySQLBuilder queryBuilder(Query query, Iterable<AbstractCriterion> where, Map<? extends Selectable<?>, ? extends Selectable<?>> columnClones) {
        if (where.iterator().hasNext()) {
            Criteria.copy(where, query.getWhere(), columnClones::get);
        }
        return this.queryBuilder(query);
    }

    public QuerySQLBuilder queryBuilder(Query query) {
        DMLNameProvider dmlNameProvider = new DMLNameProvider(arg_0 -> query.getFromSurrogate().getTableAliases().get(arg_0));
        return new QuerySQLBuilder(query, dmlNameProvider, this.selectBuilderFactory.queryBuilder(query.getSelectSurrogate(), dmlNameProvider), this.fromBuilderFactory.fromBuilder(query.getFromSurrogate(), dmlNameProvider, this, this.pseudoTableSQLBuilderFactory), this.whereBuilderFactory.whereBuilder(query.getWhereSurrogate(), dmlNameProvider), this.havingBuilderFactory.whereBuilder(query.getHavingSurrogate(), dmlNameProvider), this.functionSQLBuilderFactory.functionSQLBuilder(dmlNameProvider), this.parameterBinderRegistry);
    }

    public static class QuerySQLBuilder
    implements SQLBuilder,
    PreparedSQLBuilder {
        private final Query query;
        private final DMLNameProvider dmlNameProvider;
        private final SelectSQLBuilderFactory.SelectSQLBuilder selectSQLBuilder;
        private final FromSQLBuilderFactory.FromSQLBuilder fromSqlBuilder;
        private final WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder;
        private final WhereSQLBuilderFactory.WhereSQLBuilder havingBuilder;
        private final FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder;
        private final ColumnBinderRegistry parameterBinderRegistry;

        public QuerySQLBuilder(Query query, DMLNameProvider dmlNameProvider, SelectSQLBuilderFactory.SelectSQLBuilder selectSQLBuilder, FromSQLBuilderFactory.FromSQLBuilder fromSqlBuilder, WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder, WhereSQLBuilderFactory.WhereSQLBuilder havingBuilder, FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder, ColumnBinderRegistry parameterBinderRegistry) {
            this.query = query;
            this.dmlNameProvider = dmlNameProvider;
            this.selectSQLBuilder = selectSQLBuilder;
            this.fromSqlBuilder = fromSqlBuilder;
            this.whereSqlBuilder = whereSqlBuilder;
            this.havingBuilder = havingBuilder;
            this.functionSQLBuilder = functionSQLBuilder;
            this.parameterBinderRegistry = parameterBinderRegistry;
        }

        @Override
        public String toSQL() {
            StringAppender result = new StringAppender(500);
            this.toSQL(new StringSQLAppender(result, this.dmlNameProvider));
            return result.toString();
        }

        public void toSQL(SQLAppender sql) {
            Limit limit;
            OrderBy orderBy;
            Having having;
            GroupBy groupBy;
            sql.cat("select ", this.selectSQLBuilder.toSQL());
            sql.cat(" from ", this.fromSqlBuilder.toSQL());
            if (!this.query.getWhereSurrogate().getConditions().isEmpty()) {
                sql.cat(" where ", this.whereSqlBuilder.toSQL());
            }
            if (!(groupBy = this.query.getGroupBySurrogate()).getGroups().isEmpty()) {
                this.cat(groupBy, sql.cat(" group by ", new String[0]));
            }
            if (!(having = this.query.getHavingSurrogate()).getConditions().isEmpty()) {
                this.havingBuilder.appendTo(sql.cat(" having ", new String[0]));
            }
            if (!(orderBy = this.query.getOrderBySurrogate()).getColumns().isEmpty()) {
                this.cat(orderBy, sql.cat(" order by ", new String[0]));
            }
            sql.catIf((limit = this.query.getLimitSurrogate()).getCount() != null, " limit " + limit.getCount()).catIf(limit.getOffset() != null, " offset " + limit.getOffset());
        }

        @Override
        public ExpandableSQLAppender toPreparedSQL() {
            ExpandableSQLAppender preparedSQLAppender = new ExpandableSQLAppender(this.parameterBinderRegistry, this.dmlNameProvider);
            this.appendTo(preparedSQLAppender);
            return preparedSQLAppender;
        }

        public void appendTo(ExpandableSQLAppender sqlWrapper) {
            Limit limit;
            OrderBy orderBy;
            Having having;
            GroupBy groupBy;
            sqlWrapper.cat("select ", this.selectSQLBuilder.toSQL());
            sqlWrapper.cat(" from ", new String[0]);
            this.fromSqlBuilder.appendTo(sqlWrapper);
            if (!this.query.getWhereSurrogate().getConditions().isEmpty()) {
                sqlWrapper.cat(" where ", new String[0]);
                this.whereSqlBuilder.appendTo(sqlWrapper);
            }
            if (!(groupBy = this.query.getGroupBySurrogate()).getGroups().isEmpty()) {
                this.cat(groupBy, sqlWrapper.cat(" group by ", new String[0]));
            }
            if (!(having = this.query.getHavingSurrogate()).getConditions().isEmpty()) {
                sqlWrapper.cat(" having ", new String[0]);
                this.havingBuilder.appendTo(sqlWrapper);
            }
            if (!(orderBy = this.query.getOrderBySurrogate()).getColumns().isEmpty()) {
                sqlWrapper.cat(" order by ", new String[0]);
                this.cat(orderBy, (SQLAppender)sqlWrapper);
            }
            if ((limit = this.query.getLimitSurrogate()).getCount() != null) {
                sqlWrapper.cat(" limit ", new String[0]);
                sqlWrapper.catValue(new ValuedVariable<Integer>(limit.getCount()));
                if (limit.getOffset() != null) {
                    sqlWrapper.cat(" offset ", new String[0]);
                    sqlWrapper.catValue(new ValuedVariable<Integer>(limit.getOffset()));
                }
            }
        }

        private void cat(OrderBy orderBy, SQLAppender sql) {
            for (OrderBy.OrderedColumn o : orderBy) {
                Object column = o.getColumn();
                this.cat(column, sql);
                sql.catIf(o.getOrder() != null, o.getOrder() == OrderByChain.Order.ASC ? " asc" : " desc").cat(", ", new String[0]);
            }
            sql.removeLastChars(2);
        }

        private void cat(GroupBy groupBy, SQLAppender sql) {
            for (Object o : groupBy) {
                this.cat(o, sql);
                sql.cat(", ", new String[0]);
            }
            sql.removeLastChars(2);
        }

        private void cat(Object column, SQLAppender sql) {
            if (column instanceof String) {
                sql.cat((String)column, new String[0]);
            } else if (column instanceof SQLFunction) {
                this.functionSQLBuilder.cat((SQLFunction)column, sql);
            } else if (column instanceof Selectable) {
                sql.cat(this.dmlNameProvider.getName((Selectable)column), new String[0]);
            }
        }
    }
}

