/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.HashMap;
import java.util.Set;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.builder.PreparedSQLBuilder;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.trace.ModifiableInt;

public class PseudoTableSQLBuilderFactory {
    private static final String UNION_ALL_SEPARATOR = ") union all (";

    public PseudoTableSQLBuilder pseudoTableBuilder(QueryStatement union, QuerySQLBuilderFactory querySQLBuilderFactory) {
        return new PseudoTableSQLBuilder(union, querySQLBuilderFactory);
    }

    public static class PseudoTableSQLBuilder
    implements SQLBuilder,
    PreparedSQLBuilder {
        private final QueryStatement queryStatement;
        private final QuerySQLBuilderFactory querySQLBuilderFactory;

        public PseudoTableSQLBuilder(QueryStatement queryStatement, QuerySQLBuilderFactory querySQLBuilderFactory) {
            this.queryStatement = queryStatement;
            this.querySQLBuilderFactory = querySQLBuilderFactory;
        }

        @Override
        public CharSequence toSQL() {
            StringAppender result = new StringAppender(500);
            this.toSQL(new StringSQLAppender(result, new DMLNameProvider(this.queryStatement.getAliases()::get)));
            return result.toString();
        }

        public void toSQL(SQLAppender sqlAppender) {
            UnionGenerator sql = new UnionGenerator(sqlAppender);
            this.queryStatement.getQueries().forEach(query -> {
                sql.cat(query);
                sqlAppender.cat(" union all ", new String[0]);
            });
            sqlAppender.removeLastChars(" union all ".length());
        }

        @Override
        public ExpandableSQLAppender toPreparedSQL() {
            ExpandableSQLAppender expandableSQLAppender = new ExpandableSQLAppender(this.querySQLBuilderFactory.getParameterBinderRegistry(), new DMLNameProvider(this.queryStatement.getAliases()::get));
            this.appendTo(expandableSQLAppender);
            return expandableSQLAppender;
        }

        public void appendTo(ExpandableSQLAppender preparedSQLAppender) {
            Set<Query> queries = this.queryStatement.getQueries();
            HashMap parameterBinders = new HashMap();
            HashMap values = new HashMap();
            ModifiableInt parameterIndex = new ModifiableInt(1);
            preparedSQLAppender.cat("(", new String[0]);
            queries.forEach(query -> {
                this.querySQLBuilderFactory.queryBuilder((Query)query).appendTo(preparedSQLAppender);
                preparedSQLAppender.cat(PseudoTableSQLBuilderFactory.UNION_ALL_SEPARATOR, new String[0]);
            });
            preparedSQLAppender.removeLastChars(PseudoTableSQLBuilderFactory.UNION_ALL_SEPARATOR.length());
            preparedSQLAppender.cat(")", new String[0]);
        }

        private class UnionGenerator {
            private final SQLAppender sqlAppender;

            private UnionGenerator(SQLAppender sqlAppender) {
                this.sqlAppender = sqlAppender;
            }

            private void cat(Query query) {
                QuerySQLBuilderFactory.QuerySQLBuilder unionBuilder = PseudoTableSQLBuilder.this.querySQLBuilderFactory.queryBuilder(query);
                unionBuilder.toSQL(this.sqlAppender);
            }
        }
    }
}

