/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.projection;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.EntityCriteria;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.runtime.projection.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.projection.ProjectionQueryPageSupport;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.execution.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.projection.PartTreeStalactiteProjection;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameter;

class ProjectionQueryExecutor<C>
extends AbstractQueryExecutor<List<Object>, Object> {
    private final ProjectionQueryCriteriaSupport<C, ?> projectionQueryCriteriaSupport;
    private final Accumulator<ExecutableProjection.ProjectionDataProvider, List<Map<String, Object>>, List<Map<String, Object>>> accumulator;

    public ProjectionQueryExecutor(StalactiteQueryMethod method, ProjectionQueryCriteriaSupport<C, ?> defaultProjectionQueryCriteriaSupport, IdentityHashMap<JoinLink<?, ?>, AccessorChain<C, ?>> columnToProperties) {
        super(method);
        IdentityHashMap<JoinLink<?, ?>, String> aliases = AbstractRepositoryQuery.buildAliases(columnToProperties);
        this.projectionQueryCriteriaSupport = defaultProjectionQueryCriteriaSupport.copyFor(select -> columnToProperties.keySet().forEach(selectable -> select.add((Selectable)selectable, (String)aliases.get(selectable))));
        this.accumulator = new TupleAccumulator<C>(columnToProperties);
    }

    @Override
    public Supplier<List<Object>> buildQueryExecutor(StalactiteQueryMethodInvocationParameters invocationParameters) {
        return () -> {
            EntityPersister.ExecutableProjectionQuery<C, ?> projectionQuery = this.handleDynamicParameters(invocationParameters, this.projectionQueryCriteriaSupport);
            int i = 1;
            for (Parameter bindableParameter : invocationParameters.getParameters().getBindableParameters()) {
                Object value = invocationParameters.getBindableValue(bindableParameter.getIndex());
                projectionQuery.set(String.valueOf(i++), value);
            }
            return (List)projectionQuery.execute(this.accumulator);
        };
    }

    private EntityPersister.ExecutableProjectionQuery<C, ?> handleDynamicParameters(StalactiteQueryMethodInvocationParameters invocationParameters, ProjectionQueryCriteriaSupport<C, ?> actualProjectionQueryCriteriaSupport) {
        ProjectionQueryCriteriaSupport derivedQueryToUse;
        if (invocationParameters.getSort().isSorted()) {
            Class declaringClass = this.method.getEntityInformation().getJavaType();
            ProjectionQueryPageSupport dynamicSortSupport = new ProjectionQueryPageSupport();
            invocationParameters.getSort().stream().forEachOrdered(order -> {
                AccessorByMember accessor = Accessors.accessor((Class)declaringClass, (String)order.getProperty());
                dynamicSortSupport.orderBy(new AccessorChain(new Accessor[]{accessor}), order.getDirection() == Sort.Direction.ASC ? EntityCriteria.OrderByChain.Order.ASC : EntityCriteria.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
            derivedQueryToUse = actualProjectionQueryCriteriaSupport.copyFor(dynamicSortSupport);
        } else {
            derivedQueryToUse = actualProjectionQueryCriteriaSupport;
        }
        EntityPersister.ExecutableProjectionQuery result = derivedQueryToUse.wrapIntoExecutable();
        Limit limit = invocationParameters.getLimit();
        if (limit != null) {
            result.limit(limit.getCount().intValue(), limit.getOffset());
        }
        return result;
    }

    private static class TupleAccumulator<C>
    implements Accumulator<ExecutableProjection.ProjectionDataProvider, List<Map<String, Object>>, List<Map<String, Object>>> {
        private final IdentityHashMap<JoinLink<?, ?>, AccessorChain<C, ?>> columnToProperties;

        public TupleAccumulator(IdentityHashMap<JoinLink<?, ?>, AccessorChain<C, ?>> columnToProperties) {
            this.columnToProperties = columnToProperties;
        }

        public Supplier<List<Map<String, Object>>> supplier() {
            return LinkedList::new;
        }

        public BiConsumer<List<Map<String, Object>>, ExecutableProjection.ProjectionDataProvider> aggregator() {
            return (finalResult, databaseRowDataProvider) -> {
                HashMap<String, Object> row = new HashMap<String, Object>();
                finalResult.add(row);
                for (Map.Entry<JoinLink<?, ?>, AccessorChain<C, ?>> entry : this.columnToProperties.entrySet()) {
                    PartTreeStalactiteProjection.buildHierarchicMap(entry.getValue(), databaseRowDataProvider.getValue((Selectable)entry.getKey()), row);
                }
            };
        }

        public Function<List<Map<String, Object>>, List<Map<String, Object>>> finisher() {
            return Function.identity();
        }
    }
}

