/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.function.SerializableThrowingBiFunction;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class ResultSetReaderTest {
    ResultSetReaderTest() {
    }

    @Test
    void get_exceptionHandling() throws SQLException {
        ResultSetReader<Integer> resultSetReader = new ResultSetReader<Integer>(){

            public Class<Integer> getType() {
                return Integer.class;
            }

            public Integer doGet(ResultSet resultSet, String columnName) {
                return (Integer)new Hanger.Holder((Object)"A").get();
            }
        };
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSetMock.getObject("XX")).thenReturn((Object)"my too long String value");
        Assertions.assertThatThrownBy(() -> ResultSetReaderTest.lambda$get_exceptionHandling$0((ResultSetReader)resultSetReader, resultSetMock)).hasMessage("Error while reading column 'XX' : trying to read 'my too long Str...' as java.lang.Integer but was java.lang.String");
    }

    @Test
    void thenApply_typeIsConverterOne() {
        ResultSetReader<Long> resultSetReader = new ResultSetReader<Long>(){

            public Class<Long> getType() {
                return Long.TYPE;
            }

            public Long doGet(ResultSet resultSet, String columnName) {
                return 1L;
            }
        };
        Assertions.assertThat((Class)resultSetReader.getType()).isEqualTo(Long.TYPE);
        ResultSetReader testInstance1 = resultSetReader.thenApply(Date::new);
        Assertions.assertThat((Class)testInstance1.getType()).isEqualTo(Date.class);
        ResultSetReader testInstance2 = resultSetReader.thenApply(ResultSetReaderTest::getTimeAsStatic);
        Assertions.assertThat((Class)testInstance2.getType()).isEqualTo(Date.class);
        ResultSetReader testInstance3 = resultSetReader.thenApply(this::getTimeAsNonStatic);
        Assertions.assertThat((Class)testInstance3.getType()).isEqualTo(Date.class);
        DecimalFormat df = new DecimalFormat("");
        ResultSetReader testInstance4 = resultSetReader.thenApply(df::format);
        Assertions.assertThat((Class)testInstance4.getType()).isEqualTo(String.class);
    }

    static Stream<Arguments> ofMethodReference() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{ResultSet::getLong, Long.TYPE}), Arguments.arguments((Object[])new Object[]{ResultSet::getDate, java.sql.Date.class}), Arguments.arguments((Object[])new Object[]{ResultSet::getDouble, Double.TYPE}), Arguments.arguments((Object[])new Object[]{ResultSet::getFloat, Float.TYPE}), Arguments.arguments((Object[])new Object[]{ResultSet::getString, String.class}));
    }

    @ParameterizedTest
    @MethodSource
    <O> void ofMethodReference(SerializableThrowingBiFunction<ResultSet, String, O, SQLException> resultSetGetter, Class<O> expectedType) {
        Assertions.assertThat((Class)ResultSetReader.ofMethodReference(resultSetGetter).getType()).isEqualTo(expectedType);
    }

    public static Date getTimeAsStatic(long date) {
        return new Date(date);
    }

    public Date getTimeAsNonStatic(long date) {
        return new Date(date);
    }

    private static /* synthetic */ void lambda$get_exceptionHandling$0(ResultSetReader resultSetReader, ResultSet resultSetMock) throws Throwable {
        Integer cfr_ignored_0 = (Integer)resultSetReader.get(resultSetMock, "XX");
    }
}

