/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetoone;

import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneOwnedBySourceConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneOwnedByTargetConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;

public class OneToOneRelationConfigurer<SRC, TRGT, SRCID, TRGTID> {
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final OneToOneRelation<SRC, TRGT, TRGTID> oneToOneRelation;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final OneToOneConfigurerTemplate configurer;

    public OneToOneRelationConfigurer(OneToOneRelation<SRC, TRGT, TRGTID> oneToOneRelation, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, Dialect dialect, ConnectionConfiguration connectionConfiguration, ForeignKeyNamingStrategy foreignKeyNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy) {
        this.oneToOneRelation = oneToOneRelation;
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.configurer = oneToOneRelation.isRelationOwnedByTarget() ? new OneToOneOwnedByTargetConfigurer(sourcePersister, oneToOneRelation, joinColumnNamingStrategy, foreignKeyNamingStrategy, dialect, connectionConfiguration) : new OneToOneOwnedBySourceConfigurer(sourcePersister, oneToOneRelation, joinColumnNamingStrategy, foreignKeyNamingStrategy);
    }

    public ForeignKeyNamingStrategy getForeignKeyNamingStrategy() {
        return this.foreignKeyNamingStrategy;
    }

    public JoinColumnNamingStrategy getJoinColumnNamingStrategy() {
        return this.joinColumnNamingStrategy;
    }

    public void configure(String tableAlias, PersisterBuilderImpl<TRGT, TRGTID> targetPersisterBuilder, boolean loadSeparately) {
        ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = targetPersisterBuilder.build(this.dialect, this.connectionConfiguration, (Table)Nullable.nullable((Object)this.oneToOneRelation.getTargetTable()).getOr(Nullable.nullable(this.oneToOneRelation.getReverseColumn()).map(Column::getTable).get()));
        this.configurer.configure(tableAlias, targetPersister, loadSeparately);
    }

    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        return this.configurer.configureWithSelectIn2Phases(tableAlias, targetPersister, firstPhaseCycleLoadListener);
    }

    @FunctionalInterface
    public static interface FirstPhaseCycleLoadListener<SRC, TRGTID> {
        public void onFirstPhaseRowRead(SRC var1, TRGTID var2);
    }
}

