/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.DDLGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDLDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DDLDeployer.class);
    private final ConnectionProvider connectionProvider;
    private final DDLGenerator ddlGenerator;

    public static Collection<Table> collectTables(PersistenceContext persistenceContext) {
        LinkedHashSet<Table> result = new LinkedHashSet<Table>(20);
        persistenceContext.getPersisters().forEach(p -> result.addAll(((ConfiguredPersister)p).giveImpliedTables()));
        return result;
    }

    public DDLDeployer(PersistenceContext persistenceContext) {
        this(persistenceContext.getDialect().getDdlTableGenerator(), persistenceContext.getConnectionProvider());
        this.ddlGenerator.addTables(DDLDeployer.collectTables(persistenceContext));
    }

    public DDLDeployer(SqlTypeRegistry sqlTypeRegistry, ConnectionProvider connectionProvider) {
        this(new DDLTableGenerator(sqlTypeRegistry), connectionProvider);
    }

    public DDLDeployer(DDLTableGenerator ddlTableGenerator, ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        this.ddlGenerator = new DDLGenerator(ddlTableGenerator);
    }

    public DDLGenerator getDdlGenerator() {
        return this.ddlGenerator;
    }

    public void deployDDL() {
        this.execute(this.getCreationScripts());
    }

    public List<String> getCreationScripts() {
        return this.getDdlGenerator().getCreationScripts();
    }

    public void dropDDL() {
        this.execute(this.getDropScripts());
    }

    public List<String> getDropScripts() {
        return this.getDdlGenerator().getDropScripts();
    }

    protected void execute(List<String> sqls) {
        Connection currentConnection = this.getCurrentConnection();
        for (String sql : sqls) {
            try {
                Statement statement = currentConnection.createStatement();
                Throwable throwable = null;
                try {
                    LOGGER.debug(sql);
                    statement.execute(sql);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException t) {
                throw new SQLExecutionException(sql, (Throwable)t);
            }
        }
    }

    protected Connection getCurrentConnection() {
        return this.connectionProvider.giveConnection();
    }
}

