/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.PseudoTableSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class PseudoTableSQLBuilderFactoryTest {
    private final Dialect dialect = new Dialect();
    private final QuerySQLBuilderFactory querySQLBuilderFactory = this.dialect.getQuerySQLBuilderFactory();

    PseudoTableSQLBuilderFactoryTest() {
    }

    public static Object[][] toSQL() {
        Table tableToto = new Table(null, "Toto");
        Column colTotoA = tableToto.addColumn("a", String.class);
        Column colTotoB = tableToto.addColumn("b", String.class);
        Table tableTata = new Table(null, "Tata");
        Column colTataA = tableTata.addColumn("a", String.class);
        Column colTataB = tableTata.addColumn("b", String.class);
        Query query1 = (Query)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto).getQuery();
        Query query2 = (Query)QueryEase.select((Selectable)colTataA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableTata).getQuery();
        return new Object[][]{{query1, "select Toto.a, Toto.b from Toto"}, {new Union(new Query[]{query1, query2}), "select Toto.a, Toto.b from Toto union all select Tata.a, Tata.b from Tata"}};
    }

    @ParameterizedTest
    @MethodSource(value={"toSQL"})
    public void toSQL(QueryProvider<?> queryProvider, String expected) {
        PseudoTableSQLBuilderFactory.PseudoTableSQLBuilder testInstance = new PseudoTableSQLBuilderFactory.PseudoTableSQLBuilder(queryProvider.getQuery(), this.querySQLBuilderFactory);
        Assertions.assertThat((CharSequence)testInstance.toSQL()).isEqualTo((Object)expected);
    }
}

