/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.FromSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.PseudoTableSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.From;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.collection.IdentityMap;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class FromSQLBuilderTest {
    public static Object[][] toSQL_data() {
        Table tableToto = new Table(null, "Toto");
        Column colTotoA = tableToto.addColumn("a", String.class);
        Column colTotoB = tableToto.addColumn("b", String.class);
        Table tableTata = new Table(null, "Tata");
        Column colTataA = tableTata.addColumn("a", String.class);
        Column colTataB = tableTata.addColumn("b", String.class);
        Table tableTutu = new Table(null, "Tutu");
        Column colTutuA = tableTutu.addColumn("a", String.class);
        Column colTutuB = tableTutu.addColumn("b", String.class);
        Table tableToto2 = new Table(null, "Toto2");
        Column colToto2A = tableToto2.addColumn("a", String.class);
        Column colToto2B = tableToto2.addColumn("b", String.class);
        Union union = QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto, "T1").where(colTotoB, (CharSequence)"= 1").unionAll((QueryProvider)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto, "T2").where(colTotoB, (CharSequence)"= 2"));
        return new Object[][]{{new From((Fromable)tableToto).innerJoin((Fromable)tableTata, "Toto.id = Tata.id"), "Toto inner join Tata on Toto.id = Tata.id"}, {new From((Fromable)tableToto, "to").innerJoin((Fromable)tableTata, "ta", "to.id = ta.id"), "Toto as to inner join Tata as ta on to.id = ta.id"}, {new From((Fromable)tableToto).leftOuterJoin((Fromable)tableTata, "Toto.id = Tata.id"), "Toto left outer join Tata on Toto.id = Tata.id"}, {new From((Fromable)tableToto, "to").leftOuterJoin((Fromable)tableTata, "ta", "to.id = ta.id"), "Toto as to left outer join Tata as ta on to.id = ta.id"}, {new From((Fromable)tableToto).rightOuterJoin((Fromable)tableTata, "Toto.id = Tata.id"), "Toto right outer join Tata on Toto.id = Tata.id"}, {new From((Fromable)tableToto, "to").rightOuterJoin((Fromable)tableTata, "ta", "to.id = ta.id"), "Toto as to right outer join Tata as ta on to.id = ta.id"}, {new From((Fromable)tableToto).innerJoin((Fromable)tableTata, "Toto.a = Tata.a").innerJoin((Fromable)tableTutu, "Toto.b = Tutu.b"), "Toto inner join Tata on Toto.a = Tata.a inner join Tutu on Toto.b = Tutu.b"}, {new From((Fromable)tableToto, "to").innerJoin((Fromable)tableTata, "ta", "to.a = ta.a").innerJoin((Fromable)tableTutu, null, "to.b = Tutu.b"), "Toto as to inner join Tata as ta on to.a = ta.a inner join Tutu on to.b = Tutu.b"}, {new From((Fromable)tableToto, "to").innerJoin((Fromable)tableTata, null, "to.a = Tata.a").innerJoin((Fromable)tableTutu, "tu", "to.b = tu.b"), "Toto as to inner join Tata on to.a = Tata.a inner join Tutu as tu on to.b = tu.b"}, {new From((Fromable)tableToto).innerJoin((JoinLink)colTotoA, (JoinLink)colTataA), "Toto inner join Tata on Toto.a = Tata.a"}, {new From((Fromable)tableToto).innerJoin((JoinLink)colTotoA, (JoinLink)colTataA).setAlias((Fromable)colTotoA.getTable(), "to").setAlias((Fromable)colTataA.getTable(), "ta"), "Toto as to inner join Tata as ta on to.a = ta.a"}, {new From((Fromable)tableToto).leftOuterJoin((JoinLink)colTotoA, (JoinLink)colTataA), "Toto left outer join Tata on Toto.a = Tata.a"}, {new From((Fromable)tableToto).leftOuterJoin((JoinLink)colTotoA, (JoinLink)colTataA).setAlias((Fromable)colTotoA.getTable(), "to").setAlias((Fromable)colTataA.getTable(), "ta"), "Toto as to left outer join Tata as ta on to.a = ta.a"}, {new From((Fromable)tableToto).rightOuterJoin((JoinLink)colTotoA, (JoinLink)colTataA), "Toto right outer join Tata on Toto.a = Tata.a"}, {new From((Fromable)tableToto).rightOuterJoin((JoinLink)colTotoA, (JoinLink)colTataA).setAlias((Fromable)colTotoA.getTable(), "to").setAlias((Fromable)colTataA.getTable(), "ta"), "Toto as to right outer join Tata as ta on to.a = ta.a"}, {new From((Fromable)tableToto).innerJoin((JoinLink)colTotoA, (JoinLink)colTataA).innerJoin((JoinLink)colTotoB, (JoinLink)colTutuB), "Toto inner join Tata on Toto.a = Tata.a inner join Tutu on Toto.b = Tutu.b"}, {new From((Fromable)tableToto).innerJoin((JoinLink)colTotoA, (JoinLink)colTataA).innerJoin((JoinLink)colTotoB, (JoinLink)colTutuB).setAlias((Fromable)colTotoA.getTable(), "to").setAlias((Fromable)colTataA.getTable(), "ta"), "Toto as to inner join Tata as ta on to.a = ta.a inner join Tutu on to.b = Tutu.b"}, {new From((Fromable)tableToto).innerJoin((JoinLink)colTotoA, (JoinLink)colTataA).crossJoin((Fromable)tableToto2).innerJoin((JoinLink)colToto2B, (JoinLink)colTutuB).setAlias((Fromable)colTotoA.getTable(), "to").setAlias((Fromable)colTataA.getTable(), "ta"), "Toto as to inner join Tata as ta on to.a = ta.a cross join Toto2 inner join Tutu on Toto2.b = Tutu.b"}, {new From((Fromable)tableToto).innerJoin((JoinLink)colTotoA, (JoinLink)colTataA).innerJoin((JoinLink)colTotoB, (JoinLink)colTutuB).setAlias((Fromable)colTotoA.getTable(), "to").setAlias((Fromable)colTutuB.getTable(), "tu"), "Toto as to inner join Tata on to.a = Tata.a inner join Tutu as tu on to.b = tu.b"}, {new From((Fromable)tableToto).innerJoin((JoinLink)colTotoA, (JoinLink)colTataA).innerJoin((JoinLink)colTotoB, (JoinLink)colTutuB).innerJoin((JoinLink)colTutuB, (JoinLink)colToto2B).setAlias((Fromable)colTotoA.getTable(), "to").setAlias((Fromable)colTataA.getTable(), "ta").setAlias((Fromable)colTutuB.getTable(), "tu"), "Toto as to inner join Tata as ta on to.a = ta.a inner join Tutu as tu on to.b = tu.b inner join Toto2 on tu.b = Toto2.b"}, {new From((Fromable)tableToto).innerJoin((Fromable)tableTata, "Toto.a = Tata.a").innerJoin((JoinLink)colTotoB, (JoinLink)colTutuB), "Toto inner join Tata on Toto.a = Tata.a inner join Tutu on Toto.b = Tutu.b"}, {new From((Fromable)tableToto), "Toto"}, {new From((Fromable)tableToto).crossJoin((Fromable)tableTata), "Toto cross join Tata"}, {new From((Fromable)tableToto).innerJoin((Fromable)tableTata, "id = id"), "Toto inner join Tata on id = id"}, {new From((Fromable)tableToto, "to").crossJoin((Fromable)tableTata).innerJoin((Fromable)tableTutu, "", "id = id"), "Toto as to cross join Tata inner join Tutu on id = id"}, {new From((Fromable)tableToto, "to").crossJoin((Fromable)tableTata).innerJoin((JoinLink)colTotoA, (JoinLink)colTutuA).setAlias((Fromable)colTutuA.getTable(), ""), "Toto as to cross join Tata inner join Tutu on to.a = Tutu.a"}, {new From((Fromable)tableToto).leftOuterJoin((Fromable)tableTata, "id = id"), "Toto left outer join Tata on id = id"}, {new From((Fromable)tableToto).crossJoin((Fromable)tableTata).leftOuterJoin((Fromable)tableTutu, "id = id"), "Toto cross join Tata left outer join Tutu on id = id"}, {new From((Fromable)tableToto).rightOuterJoin((Fromable)tableTata, "id = id"), "Toto right outer join Tata on id = id"}, {new From((Fromable)tableToto).crossJoin((Fromable)tableTata).rightOuterJoin((Fromable)tableTutu, "id = id"), "Toto cross join Tata right outer join Tutu on id = id"}, {new From((Fromable)tableToto).leftOuterJoin((Fromable)union.asPseudoTable("Tutu"), "z = y"), "Toto left outer join (select T1.a, T1.b from Toto as T1 where T1.b = 1 union all select T2.a, T2.b from Toto as T2 where T2.b = 2) as Tutu on z = y"}};
    }

    @ParameterizedTest
    @MethodSource(value={"toSQL_data"})
    public void toSQL(From from, String expected) {
        FromSQLBuilderFactory.FromSQLBuilder testInstance = new FromSQLBuilderFactory.FromSQLBuilder(from, new DMLNameProvider(arg_0 -> ((IdentityMap)from.getTableAliases()).get(arg_0)), new QuerySQLBuilderFactory((JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), new ColumnBinderRegistry()), new PseudoTableSQLBuilderFactory());
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo(expected);
    }

    @Test
    void toSQL_supportsSeveralSameTable() {
        Table tableToto1 = new Table(null, "Toto");
        Column colToto1A = tableToto1.addColumn("a", String.class);
        Column colToto1B = tableToto1.addColumn("b", String.class);
        Table tableToto2 = new Table(null, tableToto1.getName());
        Column colToto2A = tableToto2.addColumn(colToto1A.getName(), colToto1A.getJavaType());
        Column colToto2B = tableToto2.addColumn(colToto1B.getName(), colToto1B.getJavaType());
        Table tableTata = new Table(null, "Tata");
        Column colTataA = tableTata.addColumn("a", String.class);
        Column colTataB = tableTata.addColumn("b", String.class);
        Table tableTutu = new Table(null, "Tutu");
        Column colTutuA = tableTutu.addColumn("a", String.class);
        Column colTutuB = tableTutu.addColumn("b", String.class);
        From from = new From((Fromable)tableToto1).innerJoin((JoinLink)colToto1A, (JoinLink)colTataA).innerJoin((JoinLink)colToto1B, (JoinLink)colTutuB).innerJoin((JoinLink)colTutuB, (JoinLink)colToto2B).setAlias((Fromable)tableToto1, "to").setAlias((Fromable)tableTata, "ta").setAlias((Fromable)tableTutu, "tu");
        FromSQLBuilderFactory.FromSQLBuilder testInstance = new FromSQLBuilderFactory.FromSQLBuilder(from, new DMLNameProvider(arg_0 -> ((IdentityMap)from.getTableAliases()).get(arg_0)), new QuerySQLBuilderFactory((JavaTypeToSqlTypeMapping)new DefaultTypeMapping(), new ColumnBinderRegistry()), new PseudoTableSQLBuilderFactory());
        from.getTableAliases().put((Object)tableToto2, (Object)"toChanged");
        from.getTableAliases().put((Object)tableTutu, (Object)"tuChanged");
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("Toto as to inner join Tata as ta on to.a = ta.a inner join Tutu as tuChanged on to.b = tuChanged.b inner join Toto as toChanged on tuChanged.b = toChanged.b");
    }
}

