/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.HashMap;
import java.util.Set;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.PreparedSQLBuilder;
import org.codefilarete.stalactite.query.builder.PreparedSQLWrapper;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringAppenderWrapper;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.trace.ModifiableInt;

public class PseudoTableSQLBuilderFactory {
    private static final String UNION_ALL_SEPARATOR = ") union all (";

    public PseudoTableSQLBuilder pseudoTableBuilder(QueryStatement union, QuerySQLBuilderFactory querySQLBuilderFactory) {
        return new PseudoTableSQLBuilder(union, querySQLBuilderFactory);
    }

    public static class PseudoTableSQLBuilder
    implements SQLBuilder,
    PreparedSQLBuilder {
        private final QueryStatement queryStatement;
        private final QuerySQLBuilderFactory querySQLBuilderFactory;

        public PseudoTableSQLBuilder(QueryStatement queryStatement, QuerySQLBuilderFactory querySQLBuilderFactory) {
            this.queryStatement = queryStatement;
            this.querySQLBuilderFactory = querySQLBuilderFactory;
        }

        @Override
        public CharSequence toSQL() {
            StringAppender result = new StringAppender(500);
            this.toSQL(new StringAppenderWrapper(result, new DMLNameProvider(this.queryStatement.getAliases()::get)));
            return result.toString();
        }

        public void toSQL(SQLAppender sqlAppender) {
            UnionGenerator sql = new UnionGenerator(sqlAppender);
            this.queryStatement.getQueries().forEach(query -> {
                sql.cat(query);
                sqlAppender.cat(" union all ", new String[0]);
            });
            sqlAppender.removeLastChars(" union all ".length());
        }

        @Override
        public PreparedSQL toPreparedSQL() {
            Set<Query> queries = this.queryStatement.getQueries();
            StringAppender unionSql = new StringAppender();
            HashMap parameterBinders = new HashMap();
            HashMap values = new HashMap();
            ModifiableInt parameterIndex = new ModifiableInt(1);
            queries.forEach(query -> {
                PreparedSQL preparedSql = this.querySQLBuilderFactory.queryBuilder((Query)query).toPreparedSQL();
                unionSql.cat((Object)preparedSql.getSQL(), (Object)PseudoTableSQLBuilderFactory.UNION_ALL_SEPARATOR);
                preparedSql.getValues().values().forEach(value -> {
                    values.put(parameterIndex.getValue(), value);
                    parameterBinders.put(parameterIndex.getValue(), preparedSql.getParameterBinder((Object)(1 + parameterIndex.getValue() % preparedSql.getValues().size())));
                    parameterIndex.increment();
                });
            });
            unionSql.cutTail(PseudoTableSQLBuilderFactory.UNION_ALL_SEPARATOR.length()).wrap((Object)"(", (Object)")");
            PreparedSQL preparedSQL = new PreparedSQL(unionSql.toString(), parameterBinders);
            preparedSQL.setValues(values);
            return preparedSQL;
        }

        public PreparedSQL toPreparedSQL(PreparedSQLWrapper preparedSQLWrapper) {
            Set<Query> queries = this.queryStatement.getQueries();
            HashMap parameterBinders = new HashMap();
            HashMap values = new HashMap();
            ModifiableInt parameterIndex = new ModifiableInt(1);
            preparedSQLWrapper.cat("(", new String[0]);
            queries.forEach(query -> {
                PreparedSQL preparedSql = this.querySQLBuilderFactory.queryBuilder((Query)query).toPreparedSQL(preparedSQLWrapper);
                preparedSQLWrapper.cat(PseudoTableSQLBuilderFactory.UNION_ALL_SEPARATOR, new String[0]);
                preparedSql.getValues().values().forEach(value -> {
                    values.put(parameterIndex.getValue(), value);
                    parameterBinders.put(parameterIndex.getValue(), preparedSql.getParameterBinder((Object)(1 + parameterIndex.getValue() % preparedSql.getValues().size())));
                    parameterIndex.increment();
                });
            });
            preparedSQLWrapper.removeLastChars(PseudoTableSQLBuilderFactory.UNION_ALL_SEPARATOR.length());
            preparedSQLWrapper.cat(")", new String[0]);
            PreparedSQL preparedSQL = new PreparedSQL(preparedSQLWrapper.toString(), parameterBinders);
            preparedSQL.setValues(values);
            return preparedSQL;
        }

        private class UnionGenerator {
            private final SQLAppender sqlAppender;

            private UnionGenerator(SQLAppender sqlAppender) {
                this.sqlAppender = sqlAppender;
            }

            private void cat(Query query) {
                QuerySQLBuilderFactory.QuerySQLBuilder unionBuilder = PseudoTableSQLBuilder.this.querySQLBuilderFactory.queryBuilder(query);
                unionBuilder.toSQL(this.sqlAppender);
            }
        }
    }
}

