/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.manager;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.runtime.WriteExecutor;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.WriteOperation;

public class AlreadyAssignedIdentifierManager<C, I>
implements IdentifierInsertionManager<C, I> {
    private final Class<I> identifierType;
    private final SetPersistedFlagAfterInsertListener setPersistedFlagAfterInsertListener = new SetPersistedFlagAfterInsertListener();
    private final SetPersistedFlagAfterSelectListener setPersistedFlagAfterSelectListener = new SetPersistedFlagAfterSelectListener();
    private final Consumer<C> markAsPersistedFunction;
    private final Function<C, Boolean> isPersistedFunction;

    public AlreadyAssignedIdentifierManager(Class<I> identifierType, Consumer<C> markAsPersistedFunction, Function<C, Boolean> isPersistedFunction) {
        this.identifierType = identifierType;
        this.markAsPersistedFunction = markAsPersistedFunction;
        this.isPersistedFunction = isPersistedFunction;
    }

    @Override
    public Class<I> getIdentifierType() {
        return this.identifierType;
    }

    public Function<C, Boolean> getIsPersistedFunction() {
        return this.isPersistedFunction;
    }

    @Override
    public WriteExecutor.JDBCBatchingIterator<C> buildJDBCBatchingIterator(Iterable<? extends C> entities, WriteOperation<? extends Column<? extends Table, ?>> writeOperation, int batchSize) {
        return new WriteExecutor.JDBCBatchingIterator<C>(entities, writeOperation, batchSize);
    }

    @Override
    public InsertListener<C> getInsertListener() {
        return this.setPersistedFlagAfterInsertListener;
    }

    @Override
    public SelectListener<C, I> getSelectListener() {
        return this.setPersistedFlagAfterSelectListener;
    }

    public void setPersistedFlag(C e) {
        if (this.markAsPersistedFunction != null) {
            this.markAsPersistedFunction.accept(e);
        }
    }

    private void markAsPersisted(Iterable<? extends C> entities) {
        for (C e : entities) {
            this.setPersistedFlag(e);
        }
    }

    private class SetPersistedFlagAfterSelectListener
    implements SelectListener<C, I> {
        private SetPersistedFlagAfterSelectListener() {
        }

        @Override
        public void afterSelect(Set<? extends C> entities) {
            AlreadyAssignedIdentifierManager.this.markAsPersisted(entities);
        }
    }

    private class SetPersistedFlagAfterInsertListener
    implements InsertListener<C> {
        private SetPersistedFlagAfterInsertListener() {
        }

        @Override
        public void afterInsert(Iterable<? extends C> entities) {
            AlreadyAssignedIdentifierManager.this.markAsPersisted(entities);
        }
    }
}

