/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.mapping.AbstractTransformer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EmbeddedBeanMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.ToMapRowTransformer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.Predicates;

public abstract class ColumnedMapMapping<C extends Map<K, V>, K, V, T extends Table<T>>
implements EmbeddedBeanMapping<C, T> {
    private final T targetTable;
    private final Set<Column<T, Object>> columns;
    private final ToMapRowTransformer<C> rowTransformer;

    public ColumnedMapMapping(T targetTable, Set<Column<T, Object>> columns, Class<C> rowClass) {
        this.targetTable = targetTable;
        this.columns = columns;
        this.rowTransformer = new LocalToMapRowTransformer(rowClass, this.getColumns(), this::getKey, this::toMapValue);
    }

    public T getTargetTable() {
        return this.targetTable;
    }

    @Override
    public Set<Column<T, Object>> getColumns() {
        return this.columns;
    }

    @Override
    public void addPropertySetByConstructor(ValueAccessPoint<C> accessor) {
    }

    protected String getColumnName(String columnsPrefix, int i) {
        return columnsPrefix + i;
    }

    @Override
    public Map<Column<T, Object>, Object> getInsertValues(C c) {
        HashMap<Column<T, Object>, Object> toReturn = new HashMap<Column<T, Object>, Object>();
        Object toIterate = c;
        if (org.codefilarete.tool.collection.Collections.isEmpty(c)) {
            toIterate = new HashMap();
        }
        toIterate.forEach((key, value) -> this.addUpsertValues(key, value, toReturn));
        for (Column<T, Object> column : this.columns) {
            if (toReturn.containsKey(column)) continue;
            toReturn.put(column, null);
        }
        return toReturn;
    }

    @Override
    public Map<Mapping.UpwhereColumn<T>, Object> getUpdateValues(C modified, C unmodified, boolean allColumns) {
        HashMap toReturn;
        block7: {
            block6: {
                HashMap unmodifiedColumns = new HashMap();
                toReturn = new HashMap();
                if (modified == null) break block6;
                for (Map.Entry entry : modified.entrySet()) {
                    Object modifiedKey = entry.getKey();
                    Object v = entry.getValue();
                    Column<T, Object> column = this.getColumn(modifiedKey);
                    if (!Predicates.equalOrNull(v, unmodified == null ? null : unmodified.get(modifiedKey))) {
                        toReturn.put(column, v);
                        continue;
                    }
                    unmodifiedColumns.put(column, v);
                }
                HashSet missingInModified = unmodified == null ? new HashSet() : new HashSet(unmodified.keySet());
                missingInModified.removeAll(modified.keySet());
                for (Object k : missingInModified) {
                    this.addUpsertValues(k, modified.get(k), toReturn);
                }
                if (!allColumns || toReturn.isEmpty()) break block7;
                LinkedHashSet<Column<T, Object>> linkedHashSet = new LinkedHashSet<Column<T, Object>>(this.columns);
                linkedHashSet.removeAll(toReturn.keySet());
                for (Column column : linkedHashSet) {
                    Object missingValue = unmodifiedColumns.get(column);
                    toReturn.put(column, missingValue);
                }
                break block7;
            }
            if (allColumns && unmodified != null) {
                for (Column<T, Object> column : this.columns) {
                    toReturn.put(column, null);
                }
            }
        }
        return this.convertToUpwhereColumn(toReturn);
    }

    private Map<Mapping.UpwhereColumn<T>, Object> convertToUpwhereColumn(Map<Column<T, ?>, Object> map) {
        HashMap convertion = new HashMap();
        map.forEach((c, s) -> convertion.put(new Mapping.UpwhereColumn(c, true), s));
        return convertion;
    }

    protected void addUpsertValues(K key, V value, Map<Column<T, ?>, Object> valuesToBePersisted) {
        Object o = this.toDatabaseValue(key, value);
        Column<T, Object> column = this.getColumn(key);
        valuesToBePersisted.put(column, o);
    }

    protected abstract Column<T, Object> getColumn(K var1);

    protected abstract Object toDatabaseValue(K var1, V var2);

    protected abstract K getKey(Column var1);

    protected abstract V toMapValue(K var1, Object var2);

    @Override
    public C transform(Row row) {
        return (C)((Map)this.rowTransformer.transform(row));
    }

    @Override
    public AbstractTransformer<C> copyTransformerWithAliases(ColumnedRow columnedRow) {
        return this.rowTransformer.copyWithAliases(columnedRow);
    }

    @Override
    public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getPropertyToColumn() {
        throw new UnsupportedOperationException(Reflections.toString(ColumnedMapMapping.class) + " can't export a mapping between some accessors and their columns");
    }

    @Override
    public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getReadonlyPropertyToColumn() {
        throw new UnsupportedOperationException(Reflections.toString(ColumnedMapMapping.class) + " can't export a mapping between some accessors and their columns");
    }

    @Override
    public Set<Column<T, Object>> getWritableColumns() {
        return this.columns;
    }

    @Override
    public Set<Column<T, Object>> getReadonlyColumns() {
        return Collections.emptySet();
    }

    private static class LocalToMapRowTransformer<M extends Map<K, V>, K, V>
    extends ToMapRowTransformer<M> {
        private final Iterable<Column> columns;
        private final Function<Column, K> keyProvider;
        private final BiFunction<K, Object, V> databaseValueConverter;

        private LocalToMapRowTransformer(Class<M> persistedClass, Iterable<Column> columns, Function<Column, K> keyProvider, BiFunction<K, Object, V> databaseValueConverter) {
            super(persistedClass);
            this.columns = columns;
            this.keyProvider = keyProvider;
            this.databaseValueConverter = databaseValueConverter;
        }

        private LocalToMapRowTransformer(Function<Function<Column<?, ?>, Object>, M> beanFactory, ColumnedRow columnedRow, Iterable<Column> columns, Function<Column, K> keyProvider, BiFunction<K, Object, V> databaseValueConverter) {
            super(beanFactory, columnedRow);
            this.columns = columns;
            this.keyProvider = keyProvider;
            this.databaseValueConverter = databaseValueConverter;
        }

        @Override
        public AbstractTransformer<M> copyWithAliases(ColumnedRow columnedRow) {
            return new LocalToMapRowTransformer<M, K, V>(this.beanFactory, columnedRow, this.columns, this.keyProvider, this.databaseValueConverter);
        }

        @Override
        public void applyRowToBean(Row row, M map) {
            for (Column column : this.columns) {
                K key = this.keyProvider.apply(column);
                Object value = this.getColumnedRow().getValue(column, row);
                map.put(key, this.databaseValueConverter.apply(key, value));
            }
        }
    }
}

