/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.model.From;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.IdentityMap;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;

public class EntityTreeQueryBuilder<C> {
    private final EntityJoinTree<C, Object> tree;
    private final ResultSetReaderRegistry parameterBinderProvider;
    private final AliasBuilder aliasBuilder = new AliasBuilder();

    public EntityTreeQueryBuilder(EntityJoinTree<C, ?> tree, ResultSetReaderRegistry parameterBinderProvider) {
        this.tree = tree;
        this.parameterBinderProvider = parameterBinderProvider;
    }

    public EntityTreeQuery<C> buildSelectQuery() {
        Query query = new Query();
        HashMap selectParameterBinders = new HashMap();
        IdentityHashMap columnClones = new IdentityHashMap();
        HashMap tableClonePerJoinNode = new HashMap();
        ResultHelper resultHelper = new ResultHelper(query, this.parameterBinderProvider, this.aliasBuilder, selectParameterBinders, tableClonePerJoinNode);
        JoinRoot<C, Object, ?> joinRoot = this.tree.getRoot();
        Duo<Fromable, IdentityHashMap<Selectable<?>, Selectable<?>>> rootClone = this.cloneTable(joinRoot);
        Fromable rootTableClone = (Fromable)rootClone.getLeft();
        columnClones.putAll((Map)rootClone.getRight());
        tableClonePerJoinNode.put(joinRoot, rootTableClone);
        query.getFromSurrogate().setRoot(rootTableClone);
        resultHelper.addColumnsToSelect(joinRoot, this.aliasBuilder.buildTableAlias(joinRoot));
        this.tree.foreachJoin(join -> {
            Duo<Fromable, IdentityHashMap<Selectable<?>, Selectable<?>>> joinClone = this.cloneTable((JoinNode)join);
            tableClonePerJoinNode.put((JoinRoot<C, Object, ?>)join, (Fromable)joinClone.getLeft());
            columnClones.putAll((Map)joinClone.getRight());
        });
        resultHelper.applyJoinTree(this.tree);
        EntityTreeInflater entityTreeInflater = new EntityTreeInflater(resultHelper.buildConsumerTree(this.tree), resultHelper.getColumnAliases(), Maps.innerJoinOnValuesAndKeys(this.tree.getJoinIndex(), tableClonePerJoinNode));
        return new EntityTreeQuery(query, selectParameterBinders, entityTreeInflater, columnClones);
    }

    @VisibleForTesting
    Duo<Fromable, IdentityHashMap<Selectable<?>, Selectable<?>>> cloneTable(JoinNode joinNode) {
        Object joinFromable = joinNode.getTable();
        if (joinFromable instanceof Table) {
            Table table = new Table(joinFromable.getName());
            IdentityHashMap columnClones = new IdentityHashMap(table.getColumns().size());
            ((Table)joinFromable).getColumns().forEach(column -> {
                Column clone = table.addColumn(column.getName(), column.getJavaType(), column.getSize());
                columnClones.put(column, clone);
            });
            return new Duo((Object)table, columnClones);
        }
        if (joinFromable instanceof Union.UnionInFrom) {
            Union.UnionInFrom unionInFrom = new Union.UnionInFrom(joinFromable.getName(), ((Union.UnionInFrom)joinFromable).getUnion());
            IdentityHashMap columnClones = new IdentityHashMap(unionInFrom.getColumns().size());
            ((Union.UnionInFrom)joinFromable).getColumns().forEach(column -> {
                Union.PseudoColumn clone = unionInFrom.getUnion().registerColumn(column.getExpression(), column.getJavaType());
                columnClones.put(column, clone);
            });
            return new Duo((Object)unionInFrom, columnClones);
        }
        throw new UnsupportedOperationException("Cloning " + Reflections.toString(joinNode.getTable().getClass()) + " is not implemented");
    }

    private static class AliasBuilder {
        private AliasBuilder() {
        }

        public String buildTableAlias(JoinRoot joinRoot) {
            return this.giveTableAlias(joinRoot);
        }

        private String giveTableAlias(JoinNode node) {
            return (String)Strings.preventEmpty((CharSequence)node.getTableAlias(), (CharSequence)node.getTable().getName());
        }

        public String buildTableAlias(AbstractJoinNode joinNode) {
            StringAppender aliasBuilder = new StringAppender(){

                public StringAppender cat(Object o) {
                    if (o instanceof AbstractJoinNode) {
                        AbstractJoinNode localNode = (AbstractJoinNode)o;
                        return super.cat((Object)this.giveTableAlias(localNode));
                    }
                    return super.cat(o);
                }
            };
            List nodeParents = Iterables.copy((Iterator)new AbstractJoinNode.JoinNodeHierarchyIterator(joinNode));
            Collections.reverse(nodeParents);
            aliasBuilder.ccat((Iterable)nodeParents, (Object)"_");
            return aliasBuilder.toString();
        }

        public String buildColumnAlias(String tableAlias, Selectable selectableColumn) {
            return tableAlias + "_" + selectableColumn.getExpression();
        }
    }

    public static class EntityTreeQuery<C> {
        private final Query query;
        private final Map<String, ParameterBinder<?>> selectParameterBinders;
        private final EntityTreeInflater<C> entityTreeInflater;
        private final IdentityHashMap<Selectable<?>, Selectable<?>> columnClones;

        private EntityTreeQuery(Query query, Map<String, ParameterBinder<?>> selectParameterBinders, EntityTreeInflater<C> entityTreeInflater, IdentityHashMap<Selectable<?>, Selectable<?>> columnClones) {
            this.selectParameterBinders = selectParameterBinders;
            this.query = query;
            this.entityTreeInflater = entityTreeInflater;
            this.columnClones = columnClones;
        }

        public Query getQuery() {
            return this.query;
        }

        public Map<String, ParameterBinder<?>> getSelectParameterBinders() {
            return this.selectParameterBinders;
        }

        public Map<Selectable<?>, String> getColumnAliases() {
            return this.query.getAliases();
        }

        public EntityTreeInflater<C> getInflater() {
            return this.entityTreeInflater;
        }

        public Map<Selectable<?>, Selectable<?>> getColumnClones() {
            return this.columnClones;
        }
    }

    private static class ResultHelper {
        private final ResultSetReaderRegistry parameterBinderProvider;
        private final AliasBuilder aliasBuilder;
        private final Query query;
        private final Map<String, ResultSetReader> selectParameterBinders;
        private final IdentityMap<Selectable, String> columnAliases = new IdentityMap();
        private final Map<JoinNode, Fromable> tablePerJoinNode;

        private ResultHelper(Query query, ResultSetReaderRegistry parameterBinderProvider, AliasBuilder aliasBuilder, Map<String, ? extends ResultSetReader> selectParameterBinders, Map<JoinNode, Fromable> tablePerJoinNode) {
            this.parameterBinderProvider = parameterBinderProvider;
            this.aliasBuilder = aliasBuilder;
            this.query = query;
            this.selectParameterBinders = selectParameterBinders;
            this.tablePerJoinNode = tablePerJoinNode;
        }

        public IdentityMap<Selectable, String> getColumnAliases() {
            return this.columnAliases;
        }

        private <JOINTYPE> void applyJoinTree(EntityJoinTree<?, ?> tree) {
            From targetFrom = this.query.getFromSurrogate();
            tree.foreachJoin(join -> {
                String tableAlias = this.aliasBuilder.buildTableAlias((AbstractJoinNode)join);
                this.addColumnsToSelect((JoinNode)join, tableAlias);
                Key.KeyBuilder leftJoinLinkClone = Key.from((Fromable)this.tablePerJoinNode.get(join.getParent()));
                join.getLeftJoinLink().getColumns().forEach(column -> leftJoinLinkClone.addColumn((JoinLink)this.tablePerJoinNode.get(join.getParent()).findColumn(column.getExpression())));
                Key leftJoinColumn = leftJoinLinkClone.build();
                Fromable tableClone = this.tablePerJoinNode.get(join);
                Key.KeyBuilder rightJoinLinkClone = Key.from((Fromable)this.tablePerJoinNode.get(join));
                join.getRightJoinLink().getColumns().forEach(column -> rightJoinLinkClone.addColumn((JoinLink)tableClone.findColumn(column.getExpression())));
                Key rightJoinColumn = rightJoinLinkClone.build();
                switch (join.getJoinType()) {
                    case INNER: {
                        targetFrom.innerJoin(leftJoinColumn, rightJoinColumn);
                        break;
                    }
                    case OUTER: {
                        targetFrom.leftOuterJoin(leftJoinColumn, rightJoinColumn);
                    }
                }
                targetFrom.setAlias(tableClone, tableAlias);
            });
        }

        private <T1 extends Fromable> void addColumnsToSelect(JoinNode<T1> joinNode, String tableAlias) {
            Set<Selectable<?>> selectableColumns = joinNode.getColumnsToSelect();
            for (Selectable<?> selectableColumn : selectableColumns) {
                ResultSetReader reader;
                Fromable nodeTable = this.tablePerJoinNode.get(joinNode);
                Selectable columnClone = nodeTable.findColumn(selectableColumn.getExpression());
                if (columnClone == null) {
                    throw new IllegalArgumentException("Column '" + selectableColumn.getExpression() + "' not found in table " + nodeTable.getAbsoluteName());
                }
                String alias = this.aliasBuilder.buildColumnAlias(tableAlias, selectableColumn);
                this.query.select(columnClone, alias);
                if (selectableColumn instanceof Column) {
                    reader = this.parameterBinderProvider.getReader((Object)((Column)selectableColumn));
                    this.selectParameterBinders.put(alias, reader);
                } else {
                    reader = this.parameterBinderProvider.getReader(selectableColumn.getJavaType());
                }
                this.selectParameterBinders.put(alias, reader);
                this.columnAliases.put((Object)columnClone, (Object)alias);
            }
        }

        private EntityTreeInflater.ConsumerNode buildConsumerTree(EntityJoinTree<?, ?> tree) {
            EntityTreeInflater.ConsumerNode consumerRoot = new EntityTreeInflater.ConsumerNode(tree.getRoot().toConsumer(this.createDedicatedRowDecoder(tree.getRoot())));
            tree.foreachJoinWithDepth(consumerRoot, (targetOwner, currentNode) -> {
                JoinRowConsumer consumer = currentNode.toConsumer(this.createDedicatedRowDecoder((JoinNode)currentNode));
                EntityTreeInflater.ConsumerNode consumerNode = new EntityTreeInflater.ConsumerNode(consumer);
                targetOwner.addConsumer(consumerNode);
                return consumerNode;
            });
            return consumerRoot;
        }

        private ColumnedRow createDedicatedRowDecoder(JoinNode node) {
            return new ColumnedRow(column -> (String)this.columnAliases.get((Object)this.tablePerJoinNode.get(node).findColumn(column.getExpression())));
        }
    }
}

