/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.tool.InvocationHandlerSupport;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ExpandableStatementTest {
    public static Object[][] testDoApplyValue_data() {
        ParameterBinder parameterBinderMock = (ParameterBinder)InvocationHandlerSupport.mock(ParameterBinder.class, (Class[])new Class[0]);
        return new Object[][]{{"select * from Toto where id = :a", Maps.asMap((Object)"a", (Object)17), Maps.asMap((Object)"a", (Object)parameterBinderMock), Maps.asMap((Object)1, (Object)17)}, {"select * from Toto where id = :a", Maps.asMap((Object)"a", (Object)Arrays.asList((Object[])new Integer[]{17})), Maps.asMap((Object)"a", (Object)parameterBinderMock), Maps.asMap((Object)1, (Object)Arrays.asList((Object[])new Integer[]{17}))}, {"select * from Toto where id = :a", Maps.asMap((Object)"a", (Object)Arrays.asList((Object[])new Integer[]{17, 23})), Maps.asMap((Object)"a", (Object)parameterBinderMock), Maps.asMap((Object)1, (Object)17).add((Object)2, (Object)23)}, {"select * from Toto where time = :b and id = :a", Maps.asMap((Object)"a", (Object)17).add((Object)"b", (Object)-17), Maps.asMap((Object)"a", (Object)parameterBinderMock).add((Object)"b", (Object)parameterBinderMock), Maps.asMap((Object)2, (Object)17).add((Object)1, (Object)-17)}, {"select * from Toto where time = :b and id = :a", Maps.asMap((Object)"a", (Object)Arrays.asList((Object[])new Integer[]{17})).add((Object)"b", (Object)-17), Maps.asMap((Object)"a", (Object)parameterBinderMock).add((Object)"b", (Object)parameterBinderMock), Maps.asMap((Object)2, (Object)Arrays.asList((Object[])new Integer[]{17})).add((Object)1, (Object)-17)}, {"select * from Toto where time = :b and id = :a", Maps.asMap((Object)"a", (Object)Arrays.asList((Object[])new Integer[]{17, 23})).add((Object)"b", (Object)-17), Maps.asMap((Object)"a", (Object)parameterBinderMock).add((Object)"b", (Object)parameterBinderMock), Maps.asMap((Object)2, (Object)17).add((Object)3, (Object)23).add((Object)1, (Object)-17)}, {"select * from Toto where id = :a or id = :a", Maps.asMap((Object)"a", (Object)17), Maps.asMap((Object)"a", (Object)parameterBinderMock), Maps.asMap((Object)1, (Object)17).add((Object)2, (Object)17)}, {"select * from Toto where id = :a or id = :a", Maps.asMap((Object)"a", (Object)Arrays.asList((Object[])new Integer[]{17, 23, 31})), Maps.asMap((Object)"a", (Object)parameterBinderMock), Maps.asMap((Object)1, (Object)17).add((Object)2, (Object)23).add((Object)3, (Object)31).add((Object)4, (Object)17).add((Object)5, (Object)23).add((Object)6, (Object)31)}, {"select * from Toto where id = :a and time = :b or id = :a", Maps.asMap((Object)"a", (Object)17).add((Object)"b", (Object)-17), Maps.asMap((Object)"a", (Object)parameterBinderMock).add((Object)"b", (Object)parameterBinderMock), Maps.asMap((Object)1, (Object)17).add((Object)2, (Object)-17).add((Object)3, (Object)17)}, {"select * from Toto where id = :a and time = :b or id = :a", Maps.asMap((Object)"a", (Object)Arrays.asList((Object[])new Integer[]{17, 23, 31})).add((Object)"b", (Object)-17), Maps.asMap((Object)"a", (Object)parameterBinderMock).add((Object)"b", (Object)parameterBinderMock), Maps.asMap((Object)1, (Object)17).add((Object)2, (Object)23).add((Object)3, (Object)31).add((Object)4, (Object)-17).add((Object)5, (Object)17).add((Object)6, (Object)23).add((Object)7, (Object)31)}};
    }

    @ParameterizedTest
    @MethodSource(value={"testDoApplyValue_data"})
    public void testDoApplyValue(String sql, Map<String, Object> paramValues, Map<String, PreparedStatementWriter> binders, Map<Integer, Integer> expectedIndexes) {
        final HashMap appliedIndexedValues = new HashMap();
        StringParamedSQL testInstance = new StringParamedSQL(sql, binders){

            protected <T> void doApplyValue(int index, T value, PreparedStatementWriter<T> paramBinder, PreparedStatement statement) {
                appliedIndexedValues.put(index, value);
                super.doApplyValue(index, value, paramBinder, statement);
            }
        };
        for (Map.Entry<String, Object> paramValue : paramValues.entrySet()) {
            testInstance.setValue(paramValue.getKey(), paramValue.getValue());
        }
        testInstance.ensureExpandableSQL(testInstance.getValues());
        testInstance.applyValues((PreparedStatement)InvocationHandlerSupport.mock(PreparedStatement.class, (Class[])new Class[0]));
        Assertions.assertThat(appliedIndexedValues).isEqualTo(new HashMap<Integer, Integer>(expectedIndexes));
    }
}

