/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manytomany;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.stalactite.engine.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.ColumnNamingStrategy;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.AssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.IndexedAssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyAssociationConfiguration;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.runtime.AssociationRecord;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.engine.runtime.AssociationTable;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationTable;
import org.codefilarete.stalactite.engine.runtime.onetomany.AbstractOneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.ManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithIndexedAssociationTableEngine;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.bean.InstanceFieldIterator;
import org.codefilarete.tool.collection.Iterables;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ManyToManyRelationConfigurer<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>> {
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final PersisterRegistry persisterRegistry;
    private final ManyToManyWithAssociationTableConfigurer<SRC, TRGT, SRCID, TRGTID, C1, C2, ?, ?> configurer;
    private final ManyToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, ?, ?> associationConfiguration;

    public ManyToManyRelationConfigurer(ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry, ForeignKeyNamingStrategy foreignKeyNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy, ColumnNamingStrategy indexColumnNamingStrategy, AssociationTableNamingStrategy associationTableNamingStrategy) {
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.persisterRegistry = persisterRegistry;
        PrimaryKey<?, SRCID> leftPrimaryKey = this.lookupSourcePrimaryKey(sourcePersister);
        CascadeOptions.RelationMode maintenanceMode = manyToManyRelation.getRelationMode();
        boolean orphanRemoval = maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL;
        boolean writeAuthorized = maintenanceMode != CascadeOptions.RelationMode.READ_ONLY;
        this.associationConfiguration = new ManyToManyAssociationConfiguration(manyToManyRelation, sourcePersister, leftPrimaryKey, foreignKeyNamingStrategy, indexColumnNamingStrategy, orphanRemoval, writeAuthorized);
        this.configurer = new ManyToManyWithAssociationTableConfigurer(this.associationConfiguration, associationTableNamingStrategy, dialect, maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY, connectionConfiguration);
    }

    public void configure(PersisterBuilderImpl<TRGT, TRGTID> targetPersisterBuilder) {
        Table targetTable = this.determineTargetTable(this.associationConfiguration.getManyToManyRelation());
        ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = targetPersisterBuilder.build(this.dialect, this.connectionConfiguration, this.persisterRegistry, targetTable);
        this.configurer.configure(targetPersister, this.associationConfiguration.getManyToManyRelation().isFetchSeparately());
    }

    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, OneToManyRelationConfigurer.FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        return this.configurer.configureWithSelectIn2Phases(tableAlias, targetPersister, firstPhaseCycleLoadListener);
    }

    private Table determineTargetTable(ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation) {
        return manyToManyRelation.getTargetTable();
    }

    protected PrimaryKey<?, SRCID> lookupSourcePrimaryKey(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister) {
        return sourcePersister.getMapping().getTargetTable().getPrimaryKey();
    }

    private static class ManyToManyWithAssociationTableConfigurer<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>>
    extends ConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> {
        private final AssociationTableNamingStrategy associationTableNamingStrategy;
        private final Dialect dialect;
        private final boolean maintainAssociationOnly;
        private final ConnectionConfiguration connectionConfiguration;
        private AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C1, AssociationRecord, ?> associationTableEngine;

        private ManyToManyWithAssociationTableConfigurer(ManyToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> manyAssociationConfiguration, AssociationTableNamingStrategy associationTableNamingStrategy, Dialect dialect, boolean maintainAssociationOnly, ConnectionConfiguration connectionConfiguration) {
            super(manyAssociationConfiguration);
            this.associationTableNamingStrategy = associationTableNamingStrategy;
            this.dialect = dialect;
            this.maintainAssociationOnly = maintainAssociationOnly;
            this.connectionConfiguration = connectionConfiguration;
        }

        private void prepare(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            Table rightTable = targetPersister.getMapping().getTargetTable();
            PrimaryKey rightPrimaryKey = rightTable.getPrimaryKey();
            this.determineAccessorDefinition(targetPersister);
            String associationTableName = this.associationTableNamingStrategy.giveName(this.accessorDefinition, this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey);
            ManyRelationDescriptor<Object, TRGT, Collection> manyRelationDescriptor = new ManyRelationDescriptor<Object, TRGT, Collection>(arg_0 -> this.associationConfiguration.getCollectionGetter().get(arg_0), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), this.associationConfiguration.giveCollectionFactory(), this.buildReverseCombiner(targetPersister.getClassToPersist()));
            if (this.associationConfiguration.getManyToManyRelation().isOrdered()) {
                this.assignEngineForIndexedAssociation(rightPrimaryKey, associationTableName, manyRelationDescriptor, targetPersister);
            } else {
                this.assignEngineForNonIndexedAssociation(rightPrimaryKey, associationTableName, manyRelationDescriptor, targetPersister);
            }
        }

        private SerializableBiConsumer<TRGT, SRC> buildReverseCombiner(Class<TRGT> targetClass) {
            Class sourceEntityType;
            InstanceFieldIterator targetFields;
            Field reverseField;
            ManyToManyRelation.MappedByConfiguration mappedByConfiguration = this.associationConfiguration.getManyToManyRelation().getMappedByConfiguration();
            if (mappedByConfiguration.isEmpty()) {
                return null;
            }
            PropertyAccessor collectionAccessor = this.associationConfiguration.buildReversePropertyAccessor();
            if (collectionAccessor == null && (reverseField = (Field)Iterables.find((Iterator)(targetFields = new InstanceFieldIterator(targetClass)), arg_0 -> ManyToManyWithAssociationTableConfigurer.lambda$buildReverseCombiner$0(sourceEntityType = this.associationConfiguration.getSrcPersister().getClassToPersist(), arg_0))) != null) {
                Nullable reverseGetterMethod = Nullable.nullable((Object)Accessors.accessorByMethod((Field)reverseField));
                if (reverseGetterMethod.isPresent()) {
                    collectionAccessor = new PropertyAccessor((ReversibleAccessor)reverseGetterMethod.get());
                } else {
                    Nullable reverseSetterMethod = Nullable.nullable((Object)Accessors.mutatorByMethod((Field)reverseField));
                    if (reverseSetterMethod.isPresent()) {
                        collectionAccessor = new PropertyAccessor((ReversibleMutator)reverseSetterMethod.get());
                    }
                }
            }
            Nullable configuredCombiner = Nullable.nullable(mappedByConfiguration.getReverseCombiner());
            if (collectionAccessor == null) {
                return (SerializableBiConsumer)configuredCombiner.get();
            }
            Supplier reverseCollectionFactory = mappedByConfiguration.getReverseCollectionFactory();
            if (reverseCollectionFactory == null) {
                Class collectionType = AccessorDefinition.giveDefinition(collectionAccessor).getMemberType();
                reverseCollectionFactory = BeanRelationFixer.giveCollectionFactory((Class)collectionType);
            }
            PropertyAccessor finalCollectionAccessor = collectionAccessor;
            SerializableBiConsumer combiner = (SerializableBiConsumer)configuredCombiner.getOr((SerializableBiConsumer & Serializable)(trgt, src) -> ((Collection)finalCollectionAccessor.get(trgt)).add(src));
            Supplier effectiveCollectionFactory = reverseCollectionFactory;
            return (arg_0, arg_1) -> ManyToManyWithAssociationTableConfigurer.lambda$buildReverseCombiner$60a6898c$1(finalCollectionAccessor, (Supplier)effectiveCollectionFactory, combiner, arg_0, arg_1);
        }

        @Override
        void configure(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, boolean loadSeparately) {
            this.prepare(targetPersister);
            this.associationTableEngine.addSelectCascade(this.associationConfiguration.getSrcPersister(), loadSeparately);
            this.addWriteCascades(this.associationTableEngine);
        }

        @Override
        public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, OneToManyRelationConfigurer.FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
            this.prepare(targetPersister);
            this.associationTableEngine.addSelectCascadeIn2Phases(firstPhaseCycleLoadListener);
            this.addWriteCascades(this.associationTableEngine);
            return new CascadeConfigurationResult<SRC, TRGT>(this.associationTableEngine.getManyRelationDescriptor().getRelationFixer(), this.associationConfiguration.getSrcPersister());
        }

        private void addWriteCascades(AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C1, ? extends AssociationRecord, ? extends AssociationTable> oneToManyWithAssociationTableEngine) {
            if (this.associationConfiguration.isWriteAuthorized()) {
                oneToManyWithAssociationTableEngine.addInsertCascade(this.maintainAssociationOnly);
                oneToManyWithAssociationTableEngine.addUpdateCascade(this.associationConfiguration.isOrphanRemoval(), this.maintainAssociationOnly);
                oneToManyWithAssociationTableEngine.addDeleteCascade(this.associationConfiguration.isOrphanRemoval(), this.dialect);
            }
        }

        private <ASSOCIATIONTABLE extends AssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>> void assignEngineForNonIndexedAssociation(PrimaryKey<RIGHTTABLE, TRGTID> rightPrimaryKey, String associationTableName, ManyRelationDescriptor<SRC, TRGT, C1> manyRelationDescriptor, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            boolean createOneSideForeignKey = !this.associationConfiguration.getManyToManyRelation().isSourceTablePerClassPolymorphic();
            boolean createManySideForeignKey = !this.associationConfiguration.getManyToManyRelation().isTargetTablePerClassPolymorphic();
            AssociationTable intermediaryTable = new AssociationTable(this.associationConfiguration.getLeftPrimaryKey().getTable().getSchema(), associationTableName, this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey, this.accessorDefinition, this.associationTableNamingStrategy, this.associationConfiguration.getForeignKeyNamingStrategy(), createOneSideForeignKey, createManySideForeignKey);
            AssociationRecordPersister associationPersister = new AssociationRecordPersister(new AssociationRecordMapping(intermediaryTable, this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler(), targetPersister.getMapping().getIdMapping().getIdentifierAssembler(), intermediaryTable.getLeftIdentifierColumnMapping(), intermediaryTable.getRightIdentifierColumnMapping()), this.dialect, this.connectionConfiguration);
            this.associationTableEngine = new OneToManyWithAssociationTableEngine(this.associationConfiguration.getSrcPersister(), targetPersister, manyRelationDescriptor, associationPersister, this.dialect.getWriteOperationFactory());
        }

        private <ASSOCIATIONTABLE extends IndexedAssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>> void assignEngineForIndexedAssociation(PrimaryKey<RIGHTTABLE, TRGTID> rightPrimaryKey, String associationTableName, ManyRelationDescriptor manyRelationDescriptor, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            ManyToManyRelation relation = this.associationConfiguration.getManyToManyRelation();
            String indexingColumnName = (String)Nullable.nullable((Object)relation.getIndexingColumnName()).getOr(() -> this.associationConfiguration.getIndexColumnNamingStrategy().giveName(this.accessorDefinition));
            boolean createOneSideForeignKey = !relation.isSourceTablePerClassPolymorphic();
            boolean createManySideForeignKey = !relation.isTargetTablePerClassPolymorphic();
            IndexedAssociationTable intermediaryTable = new IndexedAssociationTable(this.associationConfiguration.getLeftPrimaryKey().getTable().getSchema(), associationTableName, this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey, this.accessorDefinition, this.associationTableNamingStrategy, this.associationConfiguration.getForeignKeyNamingStrategy(), createOneSideForeignKey, createManySideForeignKey, indexingColumnName);
            intermediaryTable.addForeignKey(this.associationConfiguration.getForeignKeyNamingStrategy()::giveName, intermediaryTable.getOneSideForeignKey(), (Key)this.associationConfiguration.getLeftPrimaryKey());
            AssociationRecordPersister indexedAssociationPersister = new AssociationRecordPersister(new IndexedAssociationRecordMapping(intermediaryTable, this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler(), targetPersister.getMapping().getIdMapping().getIdentifierAssembler(), intermediaryTable.getLeftIdentifierColumnMapping(), intermediaryTable.getRightIdentifierColumnMapping()), this.dialect, this.connectionConfiguration);
            this.associationTableEngine = new OneToManyWithIndexedAssociationTableEngine(this.associationConfiguration.getSrcPersister(), targetPersister, manyRelationDescriptor, indexedAssociationPersister, intermediaryTable.getIndexColumn(), this.dialect.getWriteOperationFactory());
        }

        private static /* synthetic */ void lambda$buildReverseCombiner$60a6898c$1(PropertyAccessor finalCollectionAccessor, Supplier effectiveCollectionFactory, SerializableBiConsumer combiner, Object trgt, Object src) {
            if (finalCollectionAccessor.get(trgt) == null) {
                finalCollectionAccessor.set(trgt, effectiveCollectionFactory.get());
            }
            combiner.accept(trgt, src);
        }

        private static /* synthetic */ boolean lambda$buildReverseCombiner$0(Class sourceEntityType, Field field) {
            return Collection.class.isAssignableFrom(field.getType()) && ((ParameterizedTypeImpl)field.getGenericType()).getActualTypeArguments()[0].equals(sourceEntityType);
        }
    }

    private static abstract class ConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> {
        protected final ManyToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> associationConfiguration;
        protected AccessorDefinition accessorDefinition;

        protected ConfigurerTemplate(ManyToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> associationConfiguration) {
            this.associationConfiguration = associationConfiguration;
        }

        void determineAccessorDefinition(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            this.accessorDefinition = new AccessorDefinition(this.associationConfiguration.getManyToManyRelation().getMethodReference().getDeclaringClass(), AccessorDefinition.giveDefinition(this.associationConfiguration.getManyToManyRelation().getMethodReference()).getName(), targetPersister.getClassToPersist());
        }

        abstract void configure(ConfiguredRelationalPersister<TRGT, TRGTID> var1, boolean var2);

        public abstract CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String var1, ConfiguredRelationalPersister<TRGT, TRGTID> var2, OneToManyRelationConfigurer.FirstPhaseCycleLoadListener<SRC, TRGTID> var3);
    }
}

