/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.hsqldb.statement.binder;

import java.io.InputStream;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.codefilarete.stalactite.sql.hsqldb.statement.binder.JdbcTypePreparedStatementWriter;
import org.codefilarete.stalactite.sql.hsqldb.statement.binder.JdbcTypeResultSetReader;
import org.codefilarete.stalactite.sql.hsqldb.statement.binder.ZonedDateTimePreparedStatementWriter;
import org.codefilarete.stalactite.sql.hsqldb.statement.binder.ZonedDateTimeResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;

public final class HSQLDBParameterBinders {
    public static final ParameterBinder<InputStream> BINARYSTREAM_BINDER = new LambdaParameterBinder(DefaultResultSetReaders.BINARYSTREAM_READER, (PreparedStatementWriter)new PreparedStatementWriter<InputStream>(){

        public void set(PreparedStatement p, int i, InputStream v) throws SQLException {
            if (v == null) {
                p.setObject(i, null);
            } else {
                p.setBinaryStream(i, v);
            }
        }

        public Class<InputStream> getType() {
            return InputStream.class;
        }
    });
    public static final ParameterBinder<ZonedDateTime> ZONED_DATE_TIME_BINDER = new NullAwareParameterBinder((ResultSetReader)new ZonedDateTimeResultSetReader(), (PreparedStatementWriter)new ZonedDateTimePreparedStatementWriter());
    public static final ParameterBinder<OffsetDateTime> OFFSET_DATE_TIME_BINDER = new NullAwareParameterBinder(new JdbcTypeResultSetReader<OffsetDateTime>(OffsetDateTime.class), new JdbcTypePreparedStatementWriter<OffsetDateTime>(OffsetDateTime.class, JDBCType.TIMESTAMP_WITH_TIMEZONE));

    private HSQLDBParameterBinders() {
    }
}

