/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.ReadOnlyList;

public class JoinRoot<C, I, T extends Fromable>
implements JoinNode<C, T> {
    private final EntityJoinTree<C, I> tree;
    private final EntityInflater<C, I> entityInflater;
    private final T table;
    private final List<AbstractJoinNode<?, ?, ?, ?>> joins = new ArrayList();
    @Nullable
    private String tableAlias;
    @Nullable
    private EntityTreeJoinNodeConsumptionListener<C> consumptionListener;
    private final IdentityHashMap<JoinLink<?, ?>, JoinLink<?, ?>> columnClones;

    public JoinRoot(EntityJoinTree<C, I> tree, EntityInflater<C, I> entityInflater, T table) {
        this.tree = tree;
        this.entityInflater = entityInflater;
        this.table = table;
        this.columnClones = new IdentityHashMap();
        table.getColumns().forEach(column -> this.columnClones.put((JoinLink)column, (JoinLink)column));
    }

    public JoinRoot(EntityJoinTree<C, I> tree, EntityInflater<C, I> entityInflater, T table, IdentityHashMap<? extends JoinLink<?, ?>, ? extends JoinLink<?, ?>> columnClones) {
        this.tree = tree;
        this.entityInflater = entityInflater;
        this.table = table;
        this.columnClones = columnClones;
    }

    public EntityInflater<C, I> getEntityInflater() {
        return this.entityInflater;
    }

    @Nullable
    EntityTreeJoinNodeConsumptionListener<C> getConsumptionListener() {
        return this.consumptionListener;
    }

    public JoinRoot<C, I, T> setConsumptionListener(@Nullable EntityTreeJoinNodeConsumptionListener<C> consumptionListener) {
        this.consumptionListener = consumptionListener;
        return this;
    }

    @Override
    public IdentityHashMap<JoinLink<?, ?>, JoinLink<?, ?>> getOriginalColumnsToLocalOnes() {
        return this.columnClones;
    }

    @Override
    public EntityJoinTree<C, I> getTree() {
        return this.tree;
    }

    @Override
    public T getTable() {
        return this.table;
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return this.entityInflater.getSelectableColumns();
    }

    @Override
    public ReadOnlyList<AbstractJoinNode<?, ?, ?, ?>> getJoins() {
        return new ReadOnlyList(this.joins);
    }

    @Override
    public void add(AbstractJoinNode node) {
        this.joins.add(node);
    }

    @Override
    @Nullable
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public JoinRowConsumer.RootJoinRowConsumer<C> toConsumer(JoinNode<C, T> joinNode) {
        return new JoinRootRowConsumer(this, this.entityInflater);
    }

    public class JoinRootRowConsumer
    implements JoinRowConsumer.RootJoinRowConsumer<C> {
        private final JoinRoot<C, ?, ?> joinNode;
        private final Class<C> entityType;
        private final Function<ColumnedRow, I> identifierDecoder;
        private final RowTransformer<C> entityBuilder;

        public JoinRootRowConsumer(JoinRoot<C, ?, ?> joinNode, EntityInflater<C, I> entityInflater) {
            this.joinNode = joinNode;
            this.entityType = entityInflater.getEntityType();
            this.identifierDecoder = entityInflater::giveIdentifier;
            this.entityBuilder = entityInflater.getRowTransformer();
        }

        public JoinRoot<C, ?, ?> getNode() {
            return this.joinNode;
        }

        @Override
        public C createRootInstance(ColumnedRow row, EntityTreeInflater.TreeInflationContext context) {
            Object identifier = this.identifierDecoder.apply(row);
            Object result = null;
            if (identifier != null) {
                result = context.giveEntityFromCache(this.entityType, identifier, () -> this.entityBuilder.transform(row));
            }
            if (JoinRoot.this.getConsumptionListener() != null) {
                JoinRoot.this.getConsumptionListener().onNodeConsumption(result, row);
            }
            return result;
        }

        public String toString() {
            return Reflections.toString(this.getClass()) + " entityType=" + Reflections.toString(this.entityType);
        }
    }
}

